/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.drivers.pfeiffer;

import java.util.HashMap;
import java.util.Map;
import org.lsst.ccs.drivers.ascii.Ascii;
import org.lsst.ccs.drivers.commons.DriverConstants;
import org.lsst.ccs.drivers.commons.DriverException;

public class TPG361
extends Ascii {
    public static final int DEV_INFO_TYPE = 0;
    public static final int DEV_INFO_MODEL = 1;
    public static final int DEV_INFO_SERIAL = 2;
    public static final int DEV_INFO_FW_VER = 3;
    public static final int DEV_INFO_HW_VER = 4;
    public static final int NUM_DEV_INFO = 5;
    private static final double READ_TIMEOUT = 1.0;
    private static final String ACK = "\u0006";
    private static final String NAK = "\u0015";
    private static final byte ENQ = 5;
    private static final byte ETX = 3;
    private static final Map<String, String> errorMap = new HashMap<String, String>();
    private int numGauge = 0;

    public TPG361() {
        this.setOptions(Ascii.Option.NO_NET);
    }

    public void open(DriverConstants.ConnType connType, String ident, int parm1, int parm2) throws DriverException {
        super.open(connType, ident, parm1, parm2);
        try {
            this.setTimeout(1.0);
            this.setCommandTerm(Ascii.Terminator.CR);
            this.setResponseTerm(Ascii.Terminator.CRLF);
            String type = this.getDeviceInfo()[0];
            if (type.startsWith("TPG36")) {
                this.numGauge = type.charAt(5) - 48;
            }
            if (this.numGauge < 1 || this.numGauge > 2) {
                throw new DriverException("Unrecognized device type: " + type);
            }
        }
        catch (DriverException e) {
            this.closeSilent();
            this.numGauge = 0;
            throw e;
        }
    }

    public String[] getDeviceInfo() throws DriverException {
        String rawInfo = this.readString("AYT");
        String[] devInfo = rawInfo.split(",");
        if (devInfo.length != 5) {
            throw new DriverException("Unrecognized device information: " + rawInfo);
        }
        return devInfo;
    }

    public String getGaugeID() throws DriverException {
        return this.getGaugeID(0);
    }

    public String getGaugeID(int gauge) throws DriverException {
        this.checkGauge(gauge);
        String resp = this.readString("TID");
        try {
            return resp.split(",")[gauge];
        }
        catch (IndexOutOfBoundsException e) {
            throw new DriverException("Unrecognized gauge ID response: " + resp);
        }
    }

    public void setUnit(Unit unit) throws DriverException {
        this.writeCommand("UNI," + unit.ordinal());
    }

    public Unit getUnit() throws DriverException {
        String resp = this.readString("UNI");
        try {
            return Unit.values()[Integer.valueOf(resp)];
        }
        catch (IndexOutOfBoundsException | NumberFormatException e) {
            throw new DriverException("Unrecognized unit response: " + resp);
        }
    }

    public String getError() throws DriverException {
        return this.readString("ERR");
    }

    public void gaugeOn() throws DriverException {
        this.gaugeOn(0);
    }

    public void gaugeOn(int gauge) throws DriverException {
        this.checkGauge(gauge);
        this.writeCommand("SEN," + (this.numGauge == 1 ? "2" : (gauge == 0 ? "2,0" : "0,2")));
    }

    public void gaugeOff() throws DriverException {
        this.gaugeOff(0);
    }

    public void gaugeOff(int gauge) throws DriverException {
        this.checkGauge(gauge);
        this.writeCommand("SEN," + (this.numGauge == 1 ? "1" : (gauge == 0 ? "1,0" : "0,1")));
    }

    public GaugeStatus getGaugeStatus() throws DriverException {
        return this.getGaugeStatus(0);
    }

    public GaugeStatus getGaugeStatus(int gauge) throws DriverException {
        this.checkGauge(gauge);
        String resp = this.readString("SEN");
        try {
            return GaugeStatus.values()[Integer.valueOf(resp.split(",")[gauge])];
        }
        catch (IndexOutOfBoundsException | NumberFormatException e) {
            throw new DriverException("Unrecognized status information: " + resp);
        }
    }

    public double[] readPressure() throws DriverException {
        return this.readPressure(0);
    }

    public double[] readPressure(int gauge) throws DriverException {
        this.checkGauge(gauge);
        String resp = this.readString("PR" + (gauge + 1));
        try {
            String[] statValue = resp.split(",");
            double[] pressure = new double[]{0.0, 0.0};
            pressure[0] = Double.parseDouble(statValue[1]);
            pressure[1] = Double.parseDouble(statValue[0]);
            return pressure;
        }
        catch (IndexOutOfBoundsException | NumberFormatException e) {
            throw new DriverException("Unrecognized pressure response: " + resp);
        }
    }

    public double readTemperature() throws DriverException {
        String resp = this.readString("TMP");
        try {
            return Double.parseDouble(resp);
        }
        catch (NumberFormatException e) {
            throw new DriverException("Unrecognized temperature response: " + resp);
        }
    }

    public int getOperatingHours() throws DriverException {
        String resp = this.readString("RHR");
        try {
            return Integer.valueOf(resp);
        }
        catch (NumberFormatException e) {
            throw new DriverException("Unrecognized operating hours response: " + resp);
        }
    }

    public synchronized void writeCommand(String command) throws DriverException {
        this.write(command);
        String reply = this.read();
        if (reply.equals(NAK)) {
            String error = this.readResponse();
            Object text = errorMap.get(error);
            if (text == null) {
                text = "invalid error string (" + error + ")";
            }
            throw new DriverException("Command error: " + (String)text);
        }
        if (!reply.equals(ACK)) {
            throw new DriverException("Unrecognized command response: " + reply);
        }
    }

    public synchronized String readResponse() throws DriverException {
        this.writeBytes(new byte[]{5});
        return this.read();
    }

    public synchronized String readString(String command) throws DriverException {
        this.writeCommand(command);
        return this.readResponse();
    }

    public synchronized void clearInput() throws DriverException {
        this.writeBytes(new byte[]{3});
    }

    private void checkGauge(int gauge) throws DriverException {
        if (gauge < 0 || gauge >= this.numGauge) {
            throw new DriverException("Invalid gauge number: " + gauge);
        }
    }

    static {
        errorMap.put("1000", "controller error");
        errorMap.put("0100", "no hardware");
        errorMap.put("0010", "invalid parameter");
        errorMap.put("0001", "syntax error");
    }

    public static enum Unit {
        MBAR,
        TORR,
        PASCAL,
        MICRON,
        HPASCAL,
        VOLT;

    }

    public static enum GaugeStatus {
        ABSENT,
        OFF,
        ON;

    }
}

