/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.drivers.pfeiffer;

import java.util.HashMap;
import java.util.Map;
import org.lsst.ccs.command.annotations.Argument;
import org.lsst.ccs.drivers.ascii.Ascii;
import org.lsst.ccs.drivers.commons.DriverConstants;
import org.lsst.ccs.drivers.commons.DriverException;
import org.lsst.ccs.drivers.commons.DriverTimeoutException;

public class ASM380
extends Ascii {
    public static final int ST_FILAMENT_2 = 1;
    public static final int ST_FILAMENT_ON = 2;
    public static final int ST_IN_CYCLE = 4;
    public static final int ST_CYCLE_TYPE = 24;
    public static final int ST_SNIFF_TEST = 32;
    public static final int ST_AUTOCAL_OK = 64;
    public static final int ST_PANEL_UNLOCKED = 128;
    public static final int ST_NO_FAULTS = 256;
    public static final int ST_INLET_VENT = 512;
    public static final int ST_CYCLE_AVAIL = 1024;
    public static final int ST_HIGH_VAC_SYNC = 2048;
    public static final int ST_SNIFF_UNCLOGGED = 16384;
    public static final int IX_FILAMENT_2 = 0;
    public static final int IX_FILAMENT_ON = 1;
    public static final int IX_IN_CYCLE = 2;
    public static final int IX_CYCLE_TYPE = 3;
    public static final int IX_SNIFF_TEST = 4;
    public static final int IX_AUTOCAL_OK = 5;
    public static final int IX_PANEL_UNLOCKED = 6;
    public static final int IX_NO_FAULTS = 7;
    public static final int IX_INLET_VENT = 8;
    public static final int IX_CYCLE_AVAIL = 9;
    public static final int IX_HIGH_VAC_SYNC = 10;
    public static final int IX_SNIFF_UNCLOGGED = 11;
    public static final int NUM_STATUS_ITEMS = 12;
    private static final double READ_TIMEOUT = 1.0;
    private static final int BAUD_RATE = 9600;
    private static final byte ACK = 6;
    private static final byte NAK = 21;
    private static final byte CR = 13;
    private static String[] CYCLE_TYPES = new String[]{"atmos", "grossLeak", "normal", "highSens"};
    private static final Map<Integer, String> STATUS_DESCS = new HashMap<Integer, String>();

    public ASM380() {
        this.setOptions(Ascii.Option.NO_NET);
    }

    @Override
    public void open(DriverConstants.ConnType connType, String ident, int parm1, int parm2) throws DriverException {
        super.open(connType, ident, 9600, 0);
        try {
            this.setTimeout(1.0);
            this.setCommandTerm(Ascii.Terminator.CR);
            String version = this.getVersion();
            if (!version.startsWith("ASM380")) {
                throw new DriverException("Unrecognized version string: " + version);
            }
        }
        catch (DriverException e) {
            this.closeSilent();
            throw e;
        }
    }

    public String getVersion() throws DriverException {
        return this.writeCommand("?MD");
    }

    public int getStatus() throws DriverException {
        String resp = this.writeCommand("?ST");
        if (resp.length() == 5) {
            try {
                return Integer.parseInt(resp);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        ASM380.throwResponseException(resp);
        return 0;
    }

    public String[] decodeStatus() throws DriverException {
        int status = this.getStatus();
        String[] items = new String[]{String.format("%-17s %s", "Active filament:", (status & 1) != 0 ? 2 : 1), String.format("%-17s %s", "Filament on:", (status & 2) != 0), String.format("%-17s %s", "In cycle:", (status & 4) != 0), String.format("%-17s %s", "Cycle type:", CYCLE_TYPES[(status & 0x18) >> Integer.numberOfTrailingZeros(24)]), String.format("%-17s %s", "Sniff test:", (status & 0x20) != 0), String.format("%-17s %s", "Auto calib okay:", (status & 0x40) != 0), String.format("%-17s %s", "Panel locked:", (status & 0x80) == 0), String.format("%-17s %s", "Errors active:", (status & 0x100) == 0), String.format("%-17s %s", "Inlet vent:", (status & 0x200) != 0 ? "open" : "closed"), String.format("%-17s %s", "Cycle available:", (status & 0x400) != 0), String.format("%-17s %s", "High vac sync:", (status & 0x800) != 0), String.format("%-17s %s", "Sniffer clogged:", (status & 0x4000) == 0)};
        return items;
    }

    public double readInletPressure() throws DriverException {
        return ASM380.decodeCF(this.writeCommand("?PE"));
    }

    public int readTemperature() throws DriverException {
        String resp = this.writeCommand("?TE");
        if (resp.length() == 3) {
            try {
                return Integer.parseInt(resp.substring(0, 2));
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        ASM380.throwResponseException(resp);
        return 0;
    }

    public int getPrimaryHours() throws DriverException {
        String resp = this.writeCommand("?MC0");
        if (resp.length() == 10) {
            try {
                return Integer.parseInt(resp.substring(0, 5));
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        ASM380.throwResponseException(resp);
        return 0;
    }

    public int getHighVacHours() throws DriverException {
        String resp = this.writeCommand("?MC1");
        if (resp.length() == 10) {
            try {
                return Integer.valueOf(resp.substring(0, 5));
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        ASM380.throwResponseException(resp);
        return 0;
    }

    public int[] getWarningCodes() throws DriverException {
        return this.getCodes(false);
    }

    public int[] getFaultCodes() throws DriverException {
        return this.getCodes(true);
    }

    private int[] getCodes(boolean isFault) throws DriverException {
        String resp = this.writeCommand(isFault ? "?ER" : "?WA");
        if (resp.length() > 0) {
            try {
                int count = Integer.parseInt(resp.substring(0, 1));
                if (resp.length() == 4 * count + 1) {
                    int[] codes = new int[count];
                    for (int j = 0; j < count; ++j) {
                        codes[j] = Integer.parseInt(resp.substring(4 * j + 1, 4 * j + 5));
                    }
                    return codes;
                }
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        ASM380.throwResponseException(resp);
        return null;
    }

    public void clearWarnings() throws DriverException {
        this.writeCommand("!WA");
    }

    public void clearFaults() throws DriverException {
        this.writeCommand("!RE");
    }

    public void pumpOn(boolean on) throws DriverException {
        if (on) {
            this.writeCommand("=CYE");
        } else {
            this.writeCommand("=CYD");
        }
    }

    public String getPumpStatus() throws DriverException {
        int status = this.getStatus();
        return (status & 4) != 0 ? "pumping on" : "pumping off";
    }

    public String getCycleStatus() throws DriverException {
        String stat = this.writeCommand("?CY");
        Object status = "";
        switch (stat) {
            case "ST": {
                status = "start-up phase";
                break;
            }
            case "CZ": {
                status = "electronic zero calibration";
                break;
            }
            case "CM": {
                status = "other calibration";
                break;
            }
            case "HV": {
                status = "hard vacuum cycle";
                break;
            }
            case "SN": {
                status = "sniffing test mode";
                break;
            }
            default: {
                status = "unexpected response: " + stat;
            }
        }
        return status;
    }

    public void enableAlarm(boolean enable) throws DriverException {
        if (enable) {
            this.writeCommand("=HPE");
        } else {
            this.writeCommand("=HPD");
        }
    }

    public void enableFilament(boolean enable) throws DriverException {
        if (enable) {
            this.writeCommand("=SCE");
        } else {
            this.writeCommand("=SCD");
        }
    }

    public void resetTriodeSafety() throws DriverException {
        this.writeCommand("=SCR");
    }

    public void openVentValve(boolean open) throws DriverException {
        if (open) {
            this.writeCommand("=IVE");
        } else {
            this.writeCommand("=IVD");
        }
    }

    public void setVentValveParms(@Argument(description="delay before actuation (0->2 secs)") int delay, @Argument(description="time (seconds) in actuated state") int period) throws DriverException {
        int min = period / 60;
        int sec = period - min * 60;
        String command = "=IVPM" + delay + "E" + String.format("%02d%02d", min, sec);
        this.writeCommand(command);
    }

    public void setVentValveNominal() throws DriverException {
        this.writeCommand("=IVPM0D0000");
    }

    public String getVentValveParms() throws DriverException {
        String stat = this.writeCommand("?IVP");
        return "parameter settings string: " + stat + "format:xyzmmss x=A/M:auto/man opening|y:delay 0/1/2s|z=E/D:timer enable|mm:minutes open|ss:seconds open";
    }

    public String getVentValveStatus() throws DriverException {
        return this.writeCommand("?IV").contains("E") ? "open" : "closed";
    }

    public synchronized String writeCommand(String command) throws DriverException {
        this.write(command);
        byte[] readBuff = new byte[1024];
        int curr = 0;
        int buffIn = 0;
        block3: while (true) {
            byte buffByte;
            try {
                buffIn += this.readBytes(readBuff, buffIn);
            }
            catch (DriverTimeoutException re) {
                throw re;
            }
            catch (DriverException re) {
                this.closeSilent();
                throw re;
            }
            do {
                if (curr >= buffIn) continue block3;
                if ((buffByte = readBuff[curr++]) != 6) continue;
                return new String(readBuff, 0, curr > 1 && readBuff[curr - 2] == 13 ? curr - 2 : curr - 1);
            } while (buffByte != 21);
            break;
        }
        throw new DriverException("Invalid command: " + command);
    }

    private static double decodeCF(String cfData) throws DriverException {
        try {
            return Double.parseDouble(cfData.substring(0, 3) + "e" + cfData.substring(3));
        }
        catch (NumberFormatException e) {
            throw new DriverException("Invalid CF data: " + cfData);
        }
    }

    private static void throwResponseException(String resp) throws DriverException {
        throw new DriverException("Unexpected command response: " + resp);
    }

    static {
        STATUS_DESCS.put(0, "Active filament:");
        STATUS_DESCS.put(1, "Filament on:");
        STATUS_DESCS.put(2, "In cycle:");
        STATUS_DESCS.put(3, "Cycle type:");
        STATUS_DESCS.put(4, "Sniff test:");
        STATUS_DESCS.put(5, "Auto calib okay:");
        STATUS_DESCS.put(6, "Panel locked:");
        STATUS_DESCS.put(7, "Errors active:");
        STATUS_DESCS.put(8, "Inlet vent:");
        STATUS_DESCS.put(9, "Cycle available:");
        STATUS_DESCS.put(10, "High vac sync:");
        STATUS_DESCS.put(11, "Sniffer clogged:");
    }
}

