package org.lsst.ccs.drivers.pfeiffer;

import org.lsst.ccs.command.annotations.Argument;
import org.lsst.ccs.command.annotations.Command;
import org.lsst.ccs.drivers.commons.DriverException;

/**
 ***************************************************************************
 **
 ** Program to test the TPG261 device driver * * @author Homer *
 * **************************************************************************
 */
public class TestTPG261 {

    /**
     **************************************************************************
     **
     ** Public constants *
     * **************************************************************************
     */
    public enum onOff {
        OFF, ON;
    }

    private TPG261 mydev;
    /*
     TestTPG261() throws DriverException {
        
     }
     */

    @Command(name = "open", description = "Open a device for use")
    public void open(
            @Argument(name = "devId", description = "The device ID of the device to open") String MyDevId,
            @Argument(name = "baud", description = "baud rate") Integer baud
    ) throws DriverException {

        mydev = new TPG261();
        mydev.open(MyDevId, baud);
    }

    @Command(name = "openftdi", description = "Open a device for use")
    public void openftdi(
            @Argument(name = "devId", description = "The device ID of the device to open") String MyDevId,
            @Argument(name = "baud", description = "baud rate") Integer baud
    ) throws DriverException {

        mydev = new TPG261();
        mydev.openftdi(MyDevId, baud);
    }

    /*
     @Command(name = "close", description = "Close the device")
     public void close() throws Exception {
     mydev.close();
     }
     */
    @Command(name = "readpressure", description = "Read pressure ")
    public double readpressure() throws DriverException {
        return mydev.getPressure();
    }

    @Command(name = "getstate", description = "Get state of the vacuum gauge")
    public onOff getstate() throws DriverException {
        return mydev.getStatus().contains("1") ? onOff.ON : onOff.OFF;
    }

}
