/*
 * To change this license header, choose License Headers in Project Properties.
 * To change this template file, choose Tools | Templates
 * and open the template in the editor.
 */
package org.lsst.ccs.drivers.parker;

/**
 * Names and numbers the unsigned long controller parameters associated with
 * particular programs.
 * @author tether
 */
public enum ProgramUnsigned {

    /** Reflects the current state of program execution. */
    PROGRAM_FLAGS(4128, 1),

    /** The line number of the current line being executed or the last line that was executed
     before the program stopped.
     */
    PROGRAM_LINE_NUMBER(7168, 16);

    private final int base;
    private final int step;

    ProgramUnsigned(final int base, final int step) {
        this.base = base;
        this.step = step;
    }

    /**
     * Gets the controller's index number for the parameter for a given program.
     * @param program the program.
     * @return the parameter index number.
     */
    public int index(final ProgramName program) {return base + program.index() * step;}

    /**
     * Gets the string used to refer to the parameter in AcroBasic, given the program.
     * @param program the program.
     * @return the reference string.
     */
    public String reference(final ProgramName program) {return "P" + index(program);}
}
