package org.lsst.ccs.drivers.parker;

/**
 * Defines the names and numbers used for some LONG motor controller system parameters, that is, 
 * unsigned 32-bit parameters not associated with any particular program, axis, master or encoder. 
 * @author tether
 */
public enum SystemUnsigned {
    /** The states of the optically isolated input lines. The state of the n'th input is
      * given by {@code (inputLines >> n) & 1}.
     */
    INPUT_LINES(4096),
    
    /**
     * The states of the optically isolated output lines. The state of the n'th output is
     * given by {@code (outputLines >> n) & 1}.
     */
    OUTPUT_LINES(4097),
    
    /**
     * Miscellaneous outputs on ACR90x0 and Aries controllers.
     */
    ACR9000_MISC_OUTPUTS(4099),
    
    /**
     * User flag bits, group 0.
     */
    USER_FLAGS0(4100),
    
    /**
     * (ACR9000 and Aries) Miscellaneous control flags, group 1.
     */
    ACR9000_MISC_FLAGS1(4272),
    
    /** For periodic sampling, the interval in milliseconds between samples. */
    SAMPLE_TIMER_PERIOD(6915),
    
    /** The system clock, time in milliseconds since last reset. */
    SYSTEM_CLOCK(6916);
    
    private final int indexNum;
    
    SystemUnsigned(int idex) {
        this.indexNum = idex;
    }
    
    /**
     * Gets the parameter index number used by the motor controller.
     * @return the index.
     */
    public int index() {return indexNum;}
    
    /**
     * Gets the parameter reference string used in AcroBasic.
     * @return the reference string.
     */
    public String reference() {return "P" + index();}
}
