package org.lsst.ccs.drivers.parker;

/**
 * Provides names for eight of the 16 possible ACR masters. A master is a motion generator;
 * it has control of one or more axes. 
 * @see AxisName
 */
public enum MasterName {
    MASTER0, MASTER1, MASTER2, MASTER3, MASTER4, MASTER5, MASTER6, MASTER7;
    
    /**
     * Gets the motor controller's index number of the master.
     * @return the index.
     */
    public int index() {return this.ordinal();}
    
    /**
     * Gets the string used to refer to the master in AcroBasic.
     * @return the reference string.
     */
    public String reference() {return name();}
}
