/*
 * To change this license header, choose License Headers in Project Properties.
 * To change this template file, choose Tools | Templates
 * and open the template in the editor.
 */
package org.lsst.ccs.drivers.parker;

/**
 * Names and numbers some of the sources of sample triggering signals used for the
 * INTCAP controller command.
 * The trigger sources are named in an abstract way; you have to read the description of
 * the INTCAP command for the mapping of each to real hardware resources on a particular model
 * of controller. Even so, some of the abstract trigger sources aren't
 * recognized by some models.
 * <p>
 * As the names suggest, INTCAP can trigger on the rising or falling edge of a signal.
 * Marker signals tell whether the axis is at one of possibly several positions
 * recognized by the hardware. Some encoders have a mark for home position, for example.
 * Externals are generally mapped to general-purpose input lines.
 * @author tether
 */
public enum CaptureTrigger {

    /** Valid for all controllers. */
    RISING_FIRST_MARKER,
    
    /** Invalid for AR-xxPE. */
    RISING_SECOND_MARKER,

    /** Valid for all controllers. */
    RISING_FIRST_EXTERNAL,

    /** Valid for all controllers. */
    RISING_SECOND_EXTERNAL,

    /** Valid for all controllers. */
    FALLING_FIRST_MARKER,
    
    /** Invalid for AR-xxPE. */
    FALLING_SECOND_MARKER,

    /** Valid for all controllers. */
    FALLING_FIRST_EXTERNAL,

    /** Valid for all controllers. */
    FALLING_SECOND_EXTERNAL,
    
    /** Invalid on AR-xxPE and AR-xxCE. */
    RISING_THIRD_MARKER,

    /** Invalid on AR-xxPE and AR-xxCE. */
    RISING_FOURTH_MARKER,

    /** Valid for all controllers. */
    RISING_THIRD_EXTERNAL,

    /** Invalid for AR-xxPE. */
    RISING_FOURTH_EXTERNAL,

    /** Invalid on AR-xxPE and AR-xxCE. */
    FALLING_THIRD_MARKER,

    /** Invalid on AR-xxPE and AR-xxCE. */
    FALLING_FOURTH_MARKER,

    /** Valid for all controllers. */
    FALLING_THIRD_EXTERNAL,

    /** Invalid for AR-xxPE. */
    FALLING_FOURTH_EXTERNAL
}
