package org.lsst.ccs.drivers.parker;

/**
 * Defines names for eight of the 16 possible axes. Each axis is controlled by a master
 * and controls one or two encoders; one encoder for position and perhaps another for
 * velocity. 
 * @see MasterName
 * @see EncoderName
 * @author tether
 */
public enum AxisName {
    AXIS0, AXIS1, AXIS2, AXIS3, AXIS4, AXIS5, AXIS6, AXIS7;
    
    /**
     * Gets the motor controller's index number of the axis.
     * @return the index.
     */
    public int index() {return this.ordinal();}
    
    /**
     * Gets the string used to refer to the axis in AcroBasic.
     * @return the reference string.
     */
    public String reference() {return name();}
}
