package org.lsst.ccs.drivers.parker;

/**
 * Defines names and numbers for axis parameters that are signed LONGs.
 * @author tether
 */
public enum AxisLong {
    
    /** Hardware position, in counts, captured using the INTCAP command. Normally this requires
     *  an encoder but the INTCAP command description tells how to use it for stepper
     *  motors with no encoders. */
    HARDWARE_CAPTURE(12292, 256),
    
    /** Hardware position, in counts, captured by setting the Trigger Software Capture bit. Normally
     *  this requires an encoder but the INTCAP command description tells
     *  how to use it for stepper motors with no encoders. */
    SOFTWARE_CAPTURE(12293, 256),
    
    /** Where we're supposed to be, in encoder counts or stepper counts. Use the PPU setting to
     *  convert this to a coordinate. This value is the sum of Current Position, Gear Offset, Jog
     *  Offset, Cam Offset, Ballscrew Offset and Backlash Offset.
     */
    PRIMARY_SETPOINT(12294, 256);
    
    private final int base;
    
    private final int step;
    
    AxisLong(final int base, final int step) {
        this.base = base;
        this.step = step;
    }
    
    /**
     * Gets the controller's index for this parameter for a given axis.
     * @param axis the axis.
     * @return the index.
     */
    public int index(AxisName axis) {return base + axis.index() * step;}
    
    /**
     * Gets the AcroBasic string reference for this parameter for a given axis.
     * @param axis the axis.
     * @return the reference string.
     */
    public String reference(AxisName axis) {return "P" + index(axis);}
}
