package org.lsst.ccs.drivers.parker;

/**
 * Defines names and numbers for some signed LONG encoder parameters.
 * @author tether
 */
public enum EncoderLong {
    
    /** The motor position in raw encoder counts, updated at every servo interrupt. */
    ENCODER_POSITION(6144, 16);
        
    private final int base;
    private final int step;
    
    EncoderLong(final int base, final int step) {
        this.base = base;
        this.step = step;
    }
    
    /**
     * Gets the motor controller's index for the parameter for a given encoder.
     * @param enc the encoder.
     * @return the parameter index.
     */
    public int index(final EncoderName enc) {
        return base + enc.index() * step;
    }
    
    /**
     * Gets the AcroBasic reference string for the parameter for a given encoder.
     * @param enc the encoder.
     * @return the parameter reference string.
     */
    public String reference(final EncoderName enc) {return "P" + index(enc);}
   
}
