package org.lsst.ccs.drivers.parker;

/**
 * Names and numbers the parameters associated with a given communications
 * connection to the controller.
 * @author tether
 */
public enum ConnectionUnsigned {

    /**
     * Connection status. 0=never user, 1=connected w/o watchdog, 2=connected with watchdog,
     * 3=closed by client, 4=aborted by watchdog, 8=closure requested by program,
     * 9=closed by program request.
     */
    CONNECTION_STATUS,

    /**
     * The IP address of the external client, with the first octet of the address
     * in the high-order byte of the parameters integer value.
     */
    CLIENT_IP_ADDRESS,

    /**
     * The port to which the client connected.
     */
    CLIENT_IP_PORT,

    /**
     * The number of seconds since last time the connection's status changed.
     */
    CURRENT_STATUS_DURATION,

    /**
     * The controller command stream associated with the connection.
     */
    STREAM_NUMBER,

    /**
     *
     */
    WATCHDOG_NUMBER;

    private final static int BASE = 7680;
    private final static int STEP = 8;

    /**
     * Gets the controller index number associated with the parameter for a given connection.
     * @param conn the connection.
     * @return the parameter index number.
     */
    public int index(ConnectionName conn) {return BASE + ordinal() + conn.index() * STEP;}

    /**
     * Gets the string used to refer to a connection parameter in AcroBasic for a given connection.
     * @param conn the connection.
     * @return the reference string.
     */
    public String reference(ConnectionName conn) {return "P" + index(conn);}

}
