package org.lsst.ccs.drivers.parker;

/**
 * Defines names for eight of the possible 16 AcroBasic programs. Use {@code ordinal()} to get
 * the index number used by the motor controller and use {@code name()} to get
 * the string used in AcroBasic commands.
 * @author tether
 */
public enum ProgramName {
    PROG0, PROG1, PROG2, PROG3, PROG4, PROG5, PROG6, PROG7;
    
    /**
     * Gets the motor controller's index number of the program.
     * @return the index.
     */
    public int index() {return this.ordinal();}
    
    /**
     * Gets the string used to refer to the program in AcroBasic.
     * @return the reference string.
     */
    public String reference() {return name();}
}
