package org.lsst.ccs.drivers.parker;

/**
 * Defines names for eight out of 16 possible encoders. An encode is attached to one
 * axis in order to provide position or velocity. 
 * @see AxisName
 * @see MasterName
 * @author tether
 */
public enum EncoderName {
    ENC0, ENC1, ENC2, ENC3, ENC4, ENC5, ENC6, ENC7;
    
    /**
     * Gets the motor controller's index number of the encoder.
     * @return the index.
     */
    public int index() {return this.ordinal();}
    
    /**
     * Gets the string used to refer to the encoder in AcroBasic.
     * @return the reference string.
     */
    public String reference() {return name();}
}
