package org.lsst.ccs.drivers.parker;

/**
 * Defines names and numbers for axis parameters that are unsigned LONGs.
 * @author tether
 */
public enum AxisUnsigned {
    
    /** The first set of axis flags. */
    PRIMARY_AXIS_FLAGS(4120, 1),
    
    /** The second set of axis flags. */
    SECONDARY_AXIS_FLAGS(4168, 1),
    
    /** The third set of axis flags. */
    TERTIARY_AXIS_FLAGS(4296, 1),
    
    /** The fourth set of axis flags. */
    QUATERNARY_AXIS_FLAGS(4360, 1),
    
    /** The fifth set of axis flags. */
    QUINARY_AXIS_FLAGS(4600, 1);
    
    private final int base;
    
    private final int step;
    
    AxisUnsigned(final int base, final int step) {
        this.base = base;
        this.step = step;
    }
    
    /**
     * Gets the controller's index for this parameter for a given axis.
     * @param axis the axis.
     * @return the index.
     */
    public int index(AxisName axis) {return base + axis.index() * step;}
    
    /**
     * Gets the AcroBasic string reference for this parameter for a given axis.
     * @param axis the axis.
     * @return the reference string.
     */
    public String reference(AxisName axis) {return "P" + index(axis);}
}
