/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.command;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import org.lsst.ccs.command.BasicCommand;
import org.lsst.ccs.command.CommandArgumentMatchException;
import org.lsst.ccs.command.Dictionary;
import org.lsst.ccs.command.DictionaryArgument;
import org.lsst.ccs.command.DictionaryCommand;
import org.lsst.ccs.command.DictionaryHelpGenerator;
import org.lsst.ccs.command.annotations.Command;

public abstract class DictionaryUtils {
    static String basicHelpForDictionary(Dictionary dict) {
        return DictionaryUtils.basicHelpForDictionary(dict, "");
    }

    static String basicHelpForDictionary(Dictionary dict, String indent) {
        StringBuilder helpOut = new StringBuilder();
        ArrayList<DictionaryCommand> sorted = new ArrayList<DictionaryCommand>();
        for (DictionaryCommand def : dict) {
            if (def.getCategory() == Command.CommandCategory.SYSTEM) continue;
            sorted.add(def);
        }
        Collections.sort(sorted, new CommandDefinitionComparator());
        DictionaryHelpGenerator helpGenerator = dict.getHelpGenerator();
        for (DictionaryCommand def : sorted) {
            String help = DictionaryUtils.basicHelpForCommand(def);
            if (helpGenerator != null && helpGenerator.hasHelp(def)) {
                help = helpGenerator.modifyHelpForCommand(def, help, true);
            }
            helpOut.append(indent).append(help);
        }
        return helpOut.toString();
    }

    static String basicHelpForCommand(DictionaryCommand def) {
        StringBuilder builder = new StringBuilder();
        builder.append(def.getCommandName());
        Object[] objectArray = def.getArguments();
        int n = objectArray.length;
        int n2 = 0;
        while (n2 < n) {
            DictionaryArgument param = objectArray[n2];
            List<String> allowedValues = param.getAllowedValues();
            builder.append(' ').append(allowedValues.size() == 1 ? allowedValues.get(0) : param.getName());
            ++n2;
        }
        if (def.isVarArgs()) {
            builder.append("...");
        }
        if (builder.length() <= 30) {
            int i = builder.length();
            while (i < 31) {
                builder.append(" ");
                ++i;
            }
        } else {
            builder.append("\n                               ");
        }
        builder.append(def.getDescription()).append("\n");
        if (def.getAliases().length > 0) {
            builder.append("    aliases:");
            objectArray = def.getAliases();
            n = objectArray.length;
            n2 = 0;
            while (n2 < n) {
                Object alias = objectArray[n2];
                builder.append(" ").append((String)alias);
                ++n2;
            }
            builder.append("\n");
        }
        return builder.toString();
    }

    static DictionaryCommand findCommand(Dictionary dict, String command, int argCount) {
        try {
            return dict.findCommand(new BasicCommandNullArgs(command, argCount));
        }
        catch (CommandArgumentMatchException commandArgumentMatchException) {
            return null;
        }
    }

    static boolean containsCommand(Dictionary dict, String command, int argCount) {
        try {
            return dict.containsCommand(new BasicCommandNullArgs(command, argCount));
        }
        catch (CommandArgumentMatchException commandArgumentMatchException) {
            return false;
        }
    }

    static boolean containsDictionaryCommand(Dictionary dict, DictionaryCommand newCmd) {
        for (DictionaryCommand oldCommand : dict) {
            ArrayList<String> cmdNameOrAliases = new ArrayList<String>();
            cmdNameOrAliases.add(oldCommand.getCommandName());
            String[] aliases = oldCommand.getAliases();
            if (aliases != null) {
                cmdNameOrAliases.addAll(Arrays.asList(aliases));
            }
            for (String cmdNameOrAlias : cmdNameOrAliases) {
                if (!newCmd.getCommandName().equals(cmdNameOrAlias)) continue;
                if (newCmd.isVarArgs() || oldCommand.isVarArgs()) {
                    return true;
                }
                if (newCmd.getArguments().length != oldCommand.getArguments().length) continue;
                boolean isOk = false;
                int i = 0;
                int nArgs = newCmd.getArguments().length;
                if (i < nArgs) {
                    DictionaryArgument newArg = newCmd.getArguments()[i];
                    DictionaryArgument oldArg = oldCommand.getArguments()[i];
                    if (newArg.getAllowedValues().isEmpty() || oldArg.getAllowedValues().isEmpty()) {
                        return true;
                    }
                    ArrayList<String> allowedValues = new ArrayList<String>(newArg.getAllowedValues());
                    allowedValues.retainAll(oldArg.getAllowedValues());
                    if (!allowedValues.isEmpty()) {
                        return true;
                    }
                    isOk = true;
                }
                if (isOk) continue;
                return true;
            }
        }
        return false;
    }

    static boolean commandMatch(DictionaryCommand def, BasicCommand tc) throws CommandArgumentMatchException {
        String command = tc.getCommand();
        int argumentCount = tc.getArgumentCount();
        ArrayList<String> cmdNameOrAliases = new ArrayList<String>();
        cmdNameOrAliases.add(def.getCommandName());
        String[] aliases = def.getAliases();
        if (aliases != null) {
            cmdNameOrAliases.addAll(Arrays.asList(aliases));
        }
        for (String cmdNameOrAlias : cmdNameOrAliases) {
            if (!cmdNameOrAlias.equals(command)) continue;
            boolean argumentCountOk = false;
            int cmdNumberOfArguments = def.getArguments().length;
            if (argumentCount == cmdNumberOfArguments) {
                argumentCountOk = true;
            } else if (argumentCount >= cmdNumberOfArguments - 1 && def.isVarArgs()) {
                argumentCountOk = true;
            } else if (argumentCount < cmdNumberOfArguments) {
                argumentCountOk = true;
                int i = argumentCount;
                while (i < cmdNumberOfArguments) {
                    if (def.getArguments()[i].getDefaultValue() == null) {
                        argumentCountOk = false;
                        break;
                    }
                    ++i;
                }
            }
            if (!argumentCountOk) continue;
            if (argumentCount == 0) {
                return true;
            }
            Object[] argValues = tc.getArguments();
            if (argValues != null) {
                boolean argMatch = true;
                int i = 0;
                while (i < argValues.length) {
                    if (i >= def.getArguments().length) {
                        return true;
                    }
                    List<String> allowedValues = def.getArguments()[i].getAllowedValues();
                    if (allowedValues != null && !allowedValues.isEmpty()) {
                        argMatch = false;
                        for (String allowedValue : allowedValues) {
                            if (!allowedValue.toLowerCase().equals(argValues[i].toString().toLowerCase())) continue;
                            argMatch = true;
                            break;
                        }
                    }
                    if (!argMatch) {
                        throw new CommandArgumentMatchException("Illegal value \"" + argValues[i] + "\" for argument \"" + def.getArguments()[i].getName() + "\"." + "Allowed values are: " + allowedValues);
                    }
                    ++i;
                }
                return true;
            }
            return true;
        }
        return false;
    }

    private static class BasicCommandNullArgs
    implements BasicCommand {
        private final String commandName;
        private final int argumentCount;

        BasicCommandNullArgs(String commandName, int argumentCount) {
            this.commandName = commandName;
            this.argumentCount = argumentCount;
        }

        @Override
        public int getArgumentCount() {
            return this.argumentCount;
        }

        @Override
        public String getCommand() {
            return this.commandName;
        }

        @Override
        public Object getArgument(int i) {
            return null;
        }

        @Override
        public Object[] getArguments() {
            return null;
        }

        public String toString() {
            return this.prettyToString();
        }
    }

    private static class CommandDefinitionComparator
    implements Comparator<DictionaryCommand> {
        private CommandDefinitionComparator() {
        }

        @Override
        public int compare(DictionaryCommand o1, DictionaryCommand o2) {
            return o1.getCommandName().compareTo(o2.getCommandName());
        }
    }
}

