/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.command;

import java.util.List;
import org.lsst.ccs.command.BasicCommand;
import org.lsst.ccs.command.StringTokenizer;

public class TokenizedCommand
implements BasicCommand {
    private final List<StringTokenizer.Token> tokens;
    private final String[] args;
    private static final long serialVersionUID = -687119049448004978L;

    public TokenizedCommand(String command) {
        this.tokens = StringTokenizer.tokenize(command);
        int argCount = this.getArgumentCount();
        this.args = new String[argCount];
        int i = 0;
        while (i < argCount) {
            this.args[i] = this.getArgument(i);
            ++i;
        }
    }

    @Override
    public String getCommand() {
        return this.tokens.get(0).getString();
    }

    int getCommandLocation() {
        return this.tokens.get(0).getLocation();
    }

    @Override
    public String getArgument(int index) {
        return this.tokens.get(index + 1).getString();
    }

    public String[] getArguments() {
        return this.args;
    }

    int getArgumentLocation(int index) {
        return this.tokens.get(index + 1).getLocation();
    }

    @Override
    public int getArgumentCount() {
        return Math.max(this.tokens.size() - 1, 0);
    }

    public boolean isEmpty() {
        return this.tokens.isEmpty();
    }

    public String toString() {
        return this.prettyToString();
    }
}

