/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.drivers.parker;

import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintStream;
import java.net.Socket;
import java.net.SocketException;
import java.net.SocketTimeoutException;
import java.net.UnknownHostException;
import java.util.GregorianCalendar;
import org.lsst.ccs.utilities.conv.Convert;
import org.lsst.ccs.utilities.sa.ConsOut;
import org.lsst.ccs.utilities.sa.Output;

public final class AcrComm {
    public static final int ACR_SYS_PTR = -1604321248;
    public static final int ACO_GET_RESPONSE = 1;
    public static final int ACO_ECHO_COMMAND = 2;
    public static final int ACO_SHOW_PROMPT = 4;
    public static final int ACT_CONV_INT = 0;
    public static final int ACT_CONV_FP64 = 1;
    public static final int ACT_CONV_FP32 = 2;
    public static final int ACV_DV = 0;
    public static final int ACV_DA = 1;
    public static final int ACV_SV = 2;
    public static final int ACV_SA = 3;
    public static final int ACV_LV = 4;
    public static final int ACV_LA = 5;
    public static final int ACV_$V = 6;
    public static final int ACV_$A = 7;
    public static final int INP_LINE_PRM = 4096;
    public static final int PRIM_AXIS_PRM = 4120;
    public static final int ENC_POSN_PRM = 6144;
    public static final int SAMP_PERD_PRM = 6915;
    public static final int SYS_CLOCK_PRM = 6916;
    public static final int CAP_POSN_PRM = 12292;
    public static final int PGAIN_PRM = 12304;
    public static final int IGAIN_PRM = 12305;
    public static final int DGAIN_PRM = 12308;
    public static final int POS_TLM_PRM = 12328;
    public static final int NEG_TLM_PRM = 12329;
    public static final int JOG_VEL_PRM = 12348;
    public static final int JOG_ACC_PRM = 12349;
    public static final int JOG_DEC_PRM = 12350;
    public static final int JOG_JRK_PRM = 12351;
    public static final int PPU_PRM = 12375;
    public static final int CMDD_CURR_PRM = 28738;
    public static final int CMDD_TORQ_PRM = 28739;
    public static final int ACTL_TORQ_PRM = 28740;
    public static final int DRIVE_TEMP_PRM = 28743;
    public static final int BUS_VOLT_PRM = 28745;
    public static final int TEMP_INT_PRM = 39167;
    public static final int TEMP_FLT_PRM = 39423;
    public static final int INPUT4_BIT = 4;
    public static final int OUTPUT33_BIT = 33;
    public static final int SAMP_ARM_BIT = 104;
    public static final int SAMP_ACTV_BIT = 105;
    public static final int SAMP_MODE_BIT = 106;
    public static final int MOVE_SYNC_BIT = 128;
    public static final int CAL_SYNC_BIT = 129;
    public static final int KILL_MOVE_BIT = 522;
    public static final int CAP_CMPL_BIT = 777;
    public static final int JOG_ACTV_BIT = 792;
    public static final int LINE_NUM_BIT = 5651;
    public static final int KILL_MOTN_BIT = 8467;
    public static final int POSN_ERR_BIT = 8479;
    public static final int POS_EOT_BIT = 16132;
    public static final int NEG_EOT_BIT = 16133;
    public static final int POS_SLM_BIT = 16140;
    public static final int NEG_SLM_BIT = 16141;
    public static final int HOME_FND_BIT = 16134;
    public static final int HOME_FAIL_BIT = 16135;
    public static final int INVT_PEOT_BIT = 16144;
    public static final int INVT_NEOT_BIT = 16145;
    public static final int INVT_HOME_BIT = 16146;
    public static final int ENAB_PEOT_BIT = 16148;
    public static final int ENAB_NEOT_BIT = 16149;
    public static final int ENAB_PSLM_BIT = 16150;
    public static final int ENAB_NSLM_BIT = 16151;
    public static final int HOME_BKUP_BIT = 16152;
    public static final int HOME_NEDG_BIT = 16153;
    public static final int HOME_NFNL_BIT = 16154;
    public static final int ICM_RISE_1ST = 2;
    public static final int ICM_FALL_1ST = 6;
    public static final int ICM_RISE_2ND = 3;
    public static final int ICM_FALL_2ND = 7;
    public static final int ICM_RISE_3RD = 10;
    public static final int ICM_FALL_3RD = 14;
    public static final int ICM_RISE_4TH = 11;
    public static final int ICM_FALL_4TH = 15;
    private static final int SOCK_MGMT = 5004;
    private static final int SOCK_BIN = 5006;
    private static final int TMO_NONE = 0;
    private static final int TMO_SHORT = 100;
    private static final int TMO_LONG = 2000;
    private static final int L_PROMPT = 4;
    private static final int CON_STAT_PRM = 7680;
    private static final int CON_ADDR_PRM = 7681;
    private static final int CON_PORT_PRM = 7682;
    private static final int CON_STRM_PRM = 7684;
    private static final byte LF = 10;
    private static final byte CR = 13;
    private static final byte GT = 62;
    private static final byte PEE = 80;
    private Output out;
    private Socket mgmtSock = null;
    private Socket binSock = null;
    private InputStream mgmtInp;
    private InputStream binInp;
    private OutputStream mgmtOut;
    private OutputStream binOut;
    private String prompt = "ERR>";
    private Cleanup clean = new Cleanup();
    private PrintStream log = null;
    private Thread watchdog = new Thread(new Watchdog());
    private boolean logLF = true;
    private boolean exiting = false;
    private int binPort;
    private int ipAddr = 0;
    private int acrStream = 0;
    private static final int[][] encParms;

    static {
        int[][] nArrayArray = new int[7][];
        int[] nArray = new int[4];
        nArray[0] = 248;
        nArray[1] = 3;
        nArray[2] = 255;
        nArrayArray[0] = nArray;
        int[] nArray2 = new int[4];
        nArray2[0] = 255;
        nArray2[2] = 143;
        nArray2[3] = 4;
        nArrayArray[1] = nArray2;
        int[] nArray3 = new int[4];
        nArray3[0] = 255;
        nArray3[1] = 3;
        nArray3[2] = 31;
        nArrayArray[2] = nArray3;
        int[] nArray4 = new int[4];
        nArray4[0] = 248;
        nArray4[2] = 255;
        nArray4[3] = 8;
        nArrayArray[3] = nArray4;
        int[] nArray5 = new int[4];
        nArray5[0] = 64;
        nArray5[2] = 143;
        nArray5[3] = 4;
        nArrayArray[4] = nArray5;
        int[] nArray6 = new int[4];
        nArray6[0] = 64;
        nArray6[2] = 31;
        nArray6[3] = 5;
        nArrayArray[5] = nArray6;
        int[] nArray7 = new int[4];
        nArray7[0] = 64;
        nArray7[1] = 3;
        nArray7[2] = 31;
        nArrayArray[6] = nArray7;
        encParms = nArrayArray;
    }

    public AcrComm(String node, boolean logging, Output iOut) {
        Runtime.getRuntime().addShutdownHook(this.clean);
        if (logging) {
            this.logOpen(null);
        }
        this.out = iOut != null ? iOut : new ConsOut();
        try {
            this.mgmtSock = new Socket(node, 5004);
            this.mgmtInp = this.mgmtSock.getInputStream();
            this.mgmtOut = this.mgmtSock.getOutputStream();
        }
        catch (UnknownHostException e) {
            throw new Exception((Throwable)e);
        }
        catch (SocketException e) {
            throw new Exception((Throwable)e);
        }
        catch (IOException e) {
            throw new Exception((Throwable)e);
        }
        try {
            this.binSock = new Socket(node, 5006);
            this.binInp = this.binSock.getInputStream();
            this.binOut = this.binSock.getOutputStream();
        }
        catch (UnknownHostException e) {
            throw new Exception((Throwable)e);
        }
        catch (SocketException e) {
            throw new Exception((Throwable)e);
        }
        catch (IOException e) {
            throw new Exception((Throwable)e);
        }
        try {
            this.binSock.setSoTimeout(2000);
            int leng = this.rcveAsc(2);
            if (leng == 0) {
                leng = this.sendStr("ver", 0);
            }
            this.binSock.setSoTimeout(0);
        }
        catch (SocketException e) {
            throw new Exception((Throwable)e);
        }
        this.binPort = this.binSock.getLocalPort();
        byte[] bAddr = this.binSock.getLocalAddress().getAddress();
        int j = 0;
        while (j < bAddr.length) {
            this.ipAddr = this.ipAddr << 8 | bAddr[j] & 0xFF;
            ++j;
        }
        j = 0;
        while (j < 24) {
            int status = this.getIntParm(7680 + j);
            if ((status == 1 || status == 2) && this.binPort == this.getIntParm(7682 + j) && this.ipAddr == this.getIntParm(7681 + j)) {
                this.acrStream = this.getIntParm(7684 + j);
                break;
            }
            j += 8;
        }
        this.out.println("Connected to stream " + this.acrStream);
        this.watchdog.start();
    }

    public AcrComm(String node) {
        this(node, false, null);
    }

    public AcrComm(String node, boolean logging) {
        this(node, logging, null);
    }

    public AcrComm(String node, Output iOut) {
        this(node, false, iOut);
    }

    public String getPrompt() {
        return this.prompt;
    }

    public int getStream() {
        return this.acrStream;
    }

    public void sendFile(String fName, int optns) {
        FileInputStream file;
        int off = 0;
        byte[] buff = new byte[1000];
        byte[] save = new byte[3];
        try {
            file = new FileInputStream(fName);
        }
        catch (FileNotFoundException e) {
            this.out.println(e);
            return;
        }
        if ((optns & 2) == 0) {
            this.sendStr("echo 0", 0);
        }
        while (true) {
            int leng;
            int txt = 0;
            try {
                leng = file.read(buff, off, buff.length - 3 - off);
            }
            catch (IOException e) {
                this.out.println(e);
                break;
            }
            if (leng < 0) break;
            leng += off;
            while (true) {
                int j;
                int pad;
                int end = txt;
                while (end < leng && buff[end] != 10) {
                    ++end;
                }
                if (end >= leng) break;
                int lEnd = end;
                buff[end++] = 13;
                if ((optns & 4) != 0) {
                    this.out.print(this.prompt);
                }
                if ((pad = end - txt & 3) != 0) {
                    pad = 4 - pad;
                    j = 0;
                    while (j < pad) {
                        save[j] = buff[end];
                        buff[end++] = 0;
                        ++j;
                    }
                }
                try {
                    this.binOut.write(buff, txt, end - txt);
                    if (this.log != null) {
                        this.logAscii(true, true, buff, txt, lEnd - txt);
                    }
                }
                catch (IOException e) {
                    throw new Exception((Throwable)e);
                }
                j = pad - 1;
                while (j >= 0) {
                    buff[--end] = save[j];
                    --j;
                }
                this.rcveAsc(2);
                txt = end;
            }
            off = leng - txt;
            if (off <= 0) continue;
            System.arraycopy(buff, txt, buff, 0, off);
        }
        if ((optns & 2) == 0) {
            this.sendStr("echo 1", 2);
        }
        try {
            file.close();
        }
        catch (IOException iOException) {}
    }

    public int sendStr(String cmnd, int optn) {
        if (cmnd != null) {
            int pad = 4 - (cmnd.length() & 3);
            try {
                this.binOut.write((String.valueOf(cmnd) + "\r\u0000\u0000\u0000".substring(0, pad)).getBytes());
                if (this.log != null) {
                    this.logStr(cmnd);
                }
            }
            catch (IOException e) {
                throw new Exception((Throwable)e);
            }
        }
        return this.rcveAsc(optn);
    }

    public int rcveAsc(int optn) {
        int offs = 0;
        byte[] buff = new byte[1000];
        boolean skip = (optn & 2) == 0;
        boolean first = true;
        while (true) {
            String tPrompt;
            int leng;
            try {
                leng = this.binInp.read(buff, offs, buff.length - offs);
                if (this.log != null) {
                    this.logAscii(false, first, buff, offs, leng);
                    first = false;
                }
            }
            catch (SocketTimeoutException socketTimeoutException) {
                this.out.write(buff, 0, offs);
                return 0;
            }
            catch (IOException e) {
                this.out.write(buff, 0, offs);
                throw new Exception((Throwable)e);
            }
            if (leng < 0) {
                this.out.write(buff, 0, offs);
                return -1;
            }
            leng += offs;
            int txt = 0;
            if (skip) {
                while (txt < leng && buff[txt] != 10) {
                    ++txt;
                }
                if (txt < leng) {
                    ++txt;
                    skip = false;
                }
            }
            int prm = leng;
            while (prm > 0 && buff[prm - 1] != 10) {
                --prm;
            }
            if (txt < prm) {
                this.out.write(buff, txt, prm - txt);
            }
            offs = leng - prm;
            if (prm > 0) {
                System.arraycopy(buff, prm, buff, 0, offs);
            }
            if ((leng = offs - 4) >= 0 && buff[offs - 1] == 62 && ((tPrompt = new String(buff, leng, 4)).equals("SYS>") || buff[leng] == 80 && Character.isDigit(buff[leng + 1]) && Character.isDigit(buff[leng + 2]))) {
                if (leng > 0) {
                    this.out.write(buff, 0, leng);
                }
                this.prompt = tPrompt;
                return 1;
            }
            if (offs < buff.length) continue;
            this.out.write(buff, 0, buff.length);
            offs = 0;
            skip = false;
        }
    }

    public void sendBin(byte[] cmnd) {
        try {
            this.binOut.write(cmnd, 0, cmnd.length);
            if (this.log != null) {
                this.logBin(true, cmnd, cmnd.length);
            }
        }
        catch (IOException e) {
            throw new Exception((Throwable)e);
        }
    }

    public int rcveBin(byte[] buff, int leng) {
        int nRead;
        int offs = 0;
        do {
            try {
                nRead = this.binInp.read(buff, offs, leng - offs);
            }
            catch (SocketTimeoutException socketTimeoutException) {
                nRead = 0;
            }
            catch (IOException e) {
                throw new Exception((Throwable)e);
            }
            if (nRead >= 0) continue;
            return -1;
        } while ((offs += nRead) < leng && nRead != 0);
        if (this.log != null) {
            this.logBin(false, buff, offs);
        }
        return offs;
    }

    public int getParmAsInt(int pnum) {
        byte[] cmnd = new byte[4];
        byte[] resp = new byte[8];
        this.encodePnum(pnum, cmnd);
        this.sendBin(cmnd);
        this.rcveBin(resp, resp.length);
        return Convert.bytesToInt(resp, 4);
    }

    public int getIntParm(int pnum) {
        byte[] cmnd = new byte[4];
        byte[] resp = new byte[8];
        cmnd[0] = 0;
        cmnd[1] = -120;
        Convert.shortToBytes((short)pnum, cmnd, 2);
        this.sendBin(cmnd);
        this.rcveBin(resp, resp.length);
        return Convert.bytesToInt(resp, 4);
    }

    public void setIntParm(int pnum, int value) {
        byte[] cmnd = new byte[8];
        cmnd[0] = 0;
        cmnd[1] = -119;
        Convert.shortToBytes((short)pnum, cmnd, 2);
        Convert.intToBytes(value, cmnd, 4);
        this.sendBin(cmnd);
    }

    public int getFloatParmAsInt(int pnum) {
        byte[] cmnd = new byte[4];
        byte[] resp = new byte[8];
        cmnd[0] = 0;
        cmnd[1] = -118;
        Convert.shortToBytes((short)pnum, cmnd, 2);
        this.sendBin(cmnd);
        this.rcveBin(resp, resp.length);
        return Convert.bytesToInt(resp, 4);
    }

    public float getFloatParm(int pnum) {
        byte[] cmnd = new byte[4];
        byte[] resp = new byte[8];
        cmnd[0] = 0;
        cmnd[1] = -118;
        Convert.shortToBytes((short)pnum, cmnd, 2);
        this.sendBin(cmnd);
        this.rcveBin(resp, resp.length);
        return Convert.bytesToFloat(resp, 4);
    }

    public void setFloatParm(int pnum, float value) {
        byte[] cmnd = new byte[8];
        cmnd[0] = 0;
        cmnd[1] = -117;
        Convert.shortToBytes((short)pnum, cmnd, 2);
        Convert.floatToBytes(value, cmnd, 4);
        this.sendBin(cmnd);
    }

    public int getUserParms(int pnum, double[] value, int count) {
        int[] pBase = new int[1];
        int[] nParm = new int[1];
        this.peek(-1604321248, 0, pBase, 1);
        if (pBase[0] == 0) {
            return 0;
        }
        this.peek(pBase[0], 0, nParm, 1);
        if (nParm[0] < 2 * pnum) {
            return 0;
        }
        if (nParm[0] < 2 * (pnum + count)) {
            count = nParm[0] / 2 - pnum;
        }
        int[] iValue = new int[2 * count];
        this.peek(pBase[0] + 4 + 8 * pnum, 0, iValue, iValue.length);
        int j = 0;
        while (j < count) {
            long lValue = (long)iValue[2 * j] & 0xFFFFFFFFL | (long)iValue[2 * j + 1] << 32;
            value[j] = Double.longBitsToDouble(lValue);
            ++j;
        }
        return count;
    }

    public int setUserParms(int pnum, double[] value, int count) {
        int[] pBase = new int[1];
        int[] nParm = new int[1];
        this.peek(-1604321248, 0, pBase, 1);
        if (pBase[0] == 0) {
            return 0;
        }
        this.peek(pBase[0], 0, nParm, 1);
        if (nParm[0] < 2 * pnum) {
            return 0;
        }
        if (nParm[0] < 2 * (pnum + count)) {
            count = nParm[0] / 2 - pnum;
        }
        int[] iValue = new int[2 * count];
        int j = 0;
        while (j < count) {
            long lValue = Double.doubleToLongBits(value[j]);
            iValue[2 * j] = (int)lValue;
            iValue[2 * j + 1] = (int)(lValue >> 32);
            ++j;
        }
        this.poke(pBase[0] + 4 + 8 * pnum, 0, iValue, iValue.length);
        return count;
    }

    public int getParmAddr(int pnum) {
        byte[] cmnd = new byte[4];
        byte[] resp = new byte[8];
        cmnd[0] = 0;
        cmnd[1] = -109;
        Convert.shortToBytes((short)pnum, cmnd, 2);
        this.sendBin(cmnd);
        this.rcveBin(resp, resp.length);
        return Convert.bytesToInt(resp, 4);
    }

    public int getVarAddr(int pnum, int vcode) {
        byte[] cmnd = new byte[4];
        byte[] resp = new byte[8];
        cmnd[0] = 0;
        cmnd[1] = -110;
        cmnd[2] = (byte)pnum;
        cmnd[3] = (byte)vcode;
        this.sendBin(cmnd);
        this.rcveBin(resp, resp.length);
        return Convert.bytesToInt(resp, 4);
    }

    public int getVarCount(int pnum, int type, int array) {
        int vAddr = this.getVarAddr(pnum, type);
        if (vAddr == 0) {
            return 0;
        }
        int[] nVar = new int[1];
        this.peek(vAddr, 0, nVar, 1);
        if ((type & 1) == 0 || array < 0) {
            return nVar[0];
        }
        if (array >= nVar[0]) {
            return 0;
        }
        int[] addr = new int[1];
        this.peek(vAddr + 4 + 4 * array, 0, addr, 1);
        if (addr[0] == 0) {
            return 0;
        }
        this.peek(addr[0], 0, nVar, 1);
        return nVar[0];
    }

    public int peekVars(int pnum, int type, int index, int count, int[] value) {
        if ((type & 1) != 0 || type == 6) {
            return 0;
        }
        int vAddr = this.getVarAddr(pnum, type);
        if (vAddr == 0) {
            return 0;
        }
        int[] nVar = new int[1];
        this.peek(vAddr, 0, nVar, 1);
        if (index < 0) {
            index = 0;
        }
        if (index >= nVar[0]) {
            return 0;
        }
        if (count <= 0) {
            return 0;
        }
        if (count > nVar[0] - index) {
            count = nVar[0] - index;
        }
        int wdSz = type == 0 ? 2 : 1;
        this.peek(vAddr + 4 + 4 * wdSz * index, 0, value, wdSz * count);
        return count;
    }

    public int peekVars(int pnum, int type, int array, int index, int count, int[] value) {
        if ((type & 1) == 0 || type == 7) {
            return 0;
        }
        int vAddr = this.getVarAddr(pnum, type);
        if (vAddr == 0) {
            return 0;
        }
        int[] nArr = new int[1];
        this.peek(vAddr, 0, nArr, 1);
        if (array < 0) {
            array = 0;
        }
        if (array >= nArr[0]) {
            return 0;
        }
        int[] addr = new int[1];
        this.peek(vAddr + 4 + 4 * array, 0, addr, 1);
        if (addr[0] == 0) {
            return 0;
        }
        int[] nVar = new int[1];
        this.peek(addr[0], 0, nVar, 1);
        if (index < 0) {
            index = 0;
        }
        if (index >= nVar[0]) {
            return 0;
        }
        if (count <= 0) {
            return 0;
        }
        if (count > nVar[0] - index) {
            count = nVar[0] - index;
        }
        int wdSz = type == 1 ? 2 : 1;
        this.peek(addr[0] + 4 + 4 * wdSz * index, 0, value, wdSz * count);
        return count;
    }

    public int getVars(int pnum, int index, int count, int[] value) {
        int vAddr = this.getVarAddr(pnum, 4);
        if (vAddr == 0) {
            return 0;
        }
        int[] nVar = new int[1];
        this.peek(vAddr, 0, nVar, 1);
        if (index < 0) {
            index = 0;
        }
        if (index >= nVar[0]) {
            return 0;
        }
        if (count <= 0) {
            return 0;
        }
        if (count > nVar[0] - index) {
            count = nVar[0] - index;
        }
        this.peek(vAddr + 4 + 4 * index, 0, value, count);
        return count;
    }

    public int getVars(int pnum, int array, int index, int count, int[] value) {
        int vAddr = this.getVarAddr(pnum, 5);
        if (vAddr == 0) {
            return 0;
        }
        int[] nArr = new int[1];
        this.peek(vAddr, 0, nArr, 1);
        if (array < 0) {
            array = 0;
        }
        if (array >= nArr[0]) {
            return 0;
        }
        int[] addr = new int[1];
        this.peek(vAddr + 4 + 4 * array, 0, addr, 1);
        if (addr[0] == 0) {
            return 0;
        }
        int[] nVar = new int[1];
        this.peek(addr[0], 0, nVar, 1);
        if (index < 0) {
            index = 0;
        }
        if (index >= nVar[0]) {
            return 0;
        }
        if (count <= 0) {
            return 0;
        }
        if (count > nVar[0] - index) {
            count = nVar[0] - index;
        }
        this.peek(addr[0] + 4 + 4 * index, 0, value, count);
        return count;
    }

    public int getVars(int pnum, int index, int count, float[] value) {
        int vAddr = this.getVarAddr(pnum, 2);
        if (vAddr == 0) {
            return 0;
        }
        int[] nVar = new int[1];
        this.peek(vAddr, 0, nVar, 1);
        if (index < 0) {
            index = 0;
        }
        if (index >= nVar[0]) {
            return 0;
        }
        if (count <= 0) {
            return 0;
        }
        if (count > nVar[0] - index) {
            count = nVar[0] - index;
        }
        int[] iValue = new int[count];
        this.peek(vAddr + 4 + 4 * index, 0, iValue, count);
        int j = 0;
        while (j < count) {
            value[j] = Float.intBitsToFloat(iValue[j]);
            ++j;
        }
        return count;
    }

    public int getVars(int pnum, int array, int index, int count, float[] value) {
        int vAddr = this.getVarAddr(pnum, 3);
        if (vAddr == 0) {
            return 0;
        }
        int[] nArr = new int[1];
        this.peek(vAddr, 0, nArr, 1);
        if (array < 0) {
            array = 0;
        }
        if (array >= nArr[0]) {
            return 0;
        }
        int[] addr = new int[1];
        this.peek(vAddr + 4 + 4 * array, 0, addr, 1);
        if (addr[0] == 0) {
            return 0;
        }
        int[] nVar = new int[1];
        this.peek(addr[0], 0, nVar, 1);
        if (index < 0) {
            index = 0;
        }
        if (index >= nVar[0]) {
            return 0;
        }
        if (count <= 0) {
            return 0;
        }
        if (count > nVar[0] - index) {
            count = nVar[0] - index;
        }
        int[] iValue = new int[count];
        this.peek(addr[0] + 4 + 4 * index, 0, iValue, count);
        int j = 0;
        while (j < count) {
            value[j] = Float.intBitsToFloat(iValue[j]);
            ++j;
        }
        return count;
    }

    public int getVars(int pnum, int index, int count, double[] value) {
        int vAddr = this.getVarAddr(pnum, 0);
        if (vAddr == 0) {
            return 0;
        }
        int[] nVar = new int[1];
        this.peek(vAddr, 0, nVar, 1);
        if (index < 0) {
            index = 0;
        }
        if (index >= nVar[0]) {
            return 0;
        }
        if (count <= 0) {
            return 0;
        }
        if (count > nVar[0] - index) {
            count = nVar[0] - index;
        }
        int[] iValue = new int[2 * count];
        this.peek(vAddr + 4 + 8 * index, 0, iValue, 2 * count);
        int j = 0;
        while (j < count) {
            long lValue = (long)iValue[2 * j] & 0xFFFFFFFFL | (long)iValue[2 * j + 1] << 32;
            value[j] = Double.longBitsToDouble(lValue);
            ++j;
        }
        return count;
    }

    public int getVars(int pnum, int array, int index, int count, double[] value) {
        int vAddr = this.getVarAddr(pnum, 1);
        if (vAddr == 0) {
            return 0;
        }
        int[] nArr = new int[1];
        this.peek(vAddr, 0, nArr, 1);
        if (array < 0) {
            array = 0;
        }
        if (array >= nArr[0]) {
            return 0;
        }
        int[] addr = new int[1];
        this.peek(vAddr + 4 + 4 * array, 0, addr, 1);
        if (addr[0] == 0) {
            return 0;
        }
        int[] nVar = new int[1];
        this.peek(addr[0], 0, nVar, 1);
        if (index < 0) {
            index = 0;
        }
        if (index >= nVar[0]) {
            return 0;
        }
        if (count <= 0) {
            return 0;
        }
        if (count > nVar[0] - index) {
            count = nVar[0] - index;
        }
        int[] iValue = new int[2 * count];
        this.peek(addr[0] + 4 + 8 * index, 0, iValue, 2 * count);
        int j = 0;
        while (j < count) {
            int cfr_ignored_0 = iValue[2 * j];
            int cfr_ignored_1 = iValue[2 * j + 1];
            ++j;
        }
        return count;
    }

    public int getVars(int pnum, int index, int count, String[] value) {
        int vAddr = this.getVarAddr(pnum, 6);
        if (vAddr == 0) {
            return 0;
        }
        int[] dims = new int[2];
        this.peek(vAddr, 0, dims, 2);
        if (index < 0) {
            index = 0;
        }
        if (index >= dims[0]) {
            return 0;
        }
        if (count <= 0) {
            return 0;
        }
        if (count > dims[0] - index) {
            count = dims[0] - index;
        }
        int eSize = 1 + (dims[1] + 3) / 4;
        int[] iValue = new int[eSize * count];
        this.peek(vAddr + 8 + 4 * eSize * index, 0, iValue, eSize * count);
        byte[] strng = new byte[4 * (eSize - 1)];
        int j = 0;
        while (j < count) {
            int sSize = iValue[eSize * j];
            int k = 0;
            while (k < sSize) {
                Convert.intToBytes(iValue[eSize * j + 1 + k / 4], strng, k);
                k += 4;
            }
            value[j] = new String(strng, 0, sSize);
            ++j;
        }
        return count;
    }

    public int getVars(int pnum, int array, int index, int count, String[] value) {
        int vAddr = this.getVarAddr(pnum, 7);
        if (vAddr == 0) {
            return 0;
        }
        int[] nArr = new int[1];
        this.peek(vAddr, 0, nArr, 1);
        if (array < 0) {
            array = 0;
        }
        if (array >= nArr[0]) {
            return 0;
        }
        int[] addr = new int[1];
        this.peek(vAddr + 4 + 4 * array, 0, addr, 1);
        if (addr[0] == 0) {
            return 0;
        }
        int[] dims = new int[2];
        this.peek(addr[0], 0, dims, 2);
        if (index < 0) {
            index = 0;
        }
        if (index >= dims[0]) {
            return 0;
        }
        if (count <= 0) {
            return 0;
        }
        if (count > dims[0] - index) {
            count = dims[0] - index;
        }
        int eSize = 1 + (dims[1] + 3) / 4;
        int[] iValue = new int[eSize * count];
        this.peek(addr[0] + 8 + 4 * eSize * index, 0, iValue, eSize * count);
        byte[] strng = new byte[4 * (eSize - 1)];
        int j = 0;
        while (j < count) {
            int sSize = iValue[eSize * j];
            int k = 0;
            while (k < sSize) {
                Convert.intToBytes(iValue[eSize * j + 1 + k / 4], strng, k);
                k += 4;
            }
            value[j] = new String(strng, 0, sSize);
            ++j;
        }
        return count;
    }

    public int getBit(int bnum) {
        return this.getIntParm((bnum >> 5) + 4096) >> (bnum & 0x1F) & 1;
    }

    public void setBit(int bnum) {
        byte[] cmnd = new byte[4];
        cmnd[0] = 28;
        Convert.shortToBytes((short)bnum, cmnd, 1);
        cmnd[3] = 0;
        this.sendBin(cmnd);
    }

    public void clearBit(int bnum) {
        byte[] cmnd = new byte[4];
        cmnd[0] = 29;
        Convert.shortToBytes((short)bnum, cmnd, 1);
        cmnd[3] = 0;
        this.sendBin(cmnd);
    }

    public void peek(int addr, int type, int[] value, int count) {
        int size = count > 255 ? 255 : count;
        byte[] cmnd = new byte[8];
        byte[] resp = new byte[4 * size + 8];
        cmnd[0] = 0;
        cmnd[1] = -112;
        cmnd[2] = (byte)type;
        int index = 0;
        while (index < count) {
            if (size > count - index) {
                size = count - index;
            }
            cmnd[3] = (byte)size;
            Convert.intToBytes(addr, cmnd, 4);
            this.sendBin(cmnd);
            this.rcveBin(resp, 4 * size + 8);
            int j = 0;
            while (j < size) {
                value[index++] = Convert.bytesToInt(resp, 4 * j + 8);
                ++j;
            }
            addr += 4 * size;
        }
    }

    public void poke(int addr, int type, int[] value, int count) {
        int size = count > 255 ? 255 : count;
        byte[] cmnd = new byte[4 * size + 8];
        cmnd[0] = 0;
        cmnd[1] = -111;
        cmnd[2] = (byte)type;
        int index = 0;
        while (index < count) {
            if (size > count - index) {
                size = count - index;
            }
            cmnd[3] = (byte)size;
            Convert.intToBytes(addr, cmnd, 4);
            int j = 0;
            while (j < size) {
                Convert.intToBytes(value[index++], cmnd, 4 * j + 8);
                ++j;
            }
            this.sendBin(cmnd);
            addr += 4 * size;
        }
    }

    public void drain() {
        if (this.binSock == null) {
            return;
        }
        try {
            byte[] buff = new byte[64];
            this.binSock.setSoTimeout(100);
            while (this.rcveBin(buff, buff.length) > 0) {
            }
            this.binSock.setSoTimeout(0);
        }
        catch (SocketException e) {
            this.out.println(e);
        }
    }

    public void logOpen(String name) {
        if (this.log != null) {
            this.out.println("Already logging");
            return;
        }
        String file = String.valueOf(name != null ? name : "AcrComm") + "_" + System.currentTimeMillis() / 1000L + ".log";
        try {
            this.log = new PrintStream(file);
        }
        catch (IOException e) {
            this.out.println("Cannot open log file " + file);
            this.out.println(e);
            return;
        }
    }

    public void logClose() {
        if (this.log == null) {
            this.out.println("Not logging");
        } else {
            this.log.close();
            this.log = null;
        }
    }

    private void encodePnum(int pnum, byte[] cmnd) {
        int index = (pnum &= 0xFFFF) < 6144 ? 0 : (pnum < 6912 ? 1 : (pnum < 7168 ? 2 : (pnum < 7680 ? 1 : (pnum < 8192 ? 2 : (pnum < 24576 ? 3 : (pnum < 24832 ? 1 : (pnum < 32768 ? 3 : (pnum < 33280 ? 6 : (pnum < 36864 ? 4 : (pnum < 37376 ? 5 : (pnum < 38144 ? 6 : (pnum < 38392 ? 4 : 6))))))))))));
        int codeMask = encParms[index][0];
        int indexShift = encParms[index][1];
        int indexMask = encParms[index][2];
        int maskShift = encParms[index][3];
        cmnd[0] = 0;
        cmnd[1] = codeMask == 64 ? (byte)(pnum >> 8 | codeMask) : (byte)(pnum >> 8 & codeMask);
        cmnd[2] = (byte)(pnum >> indexShift & indexMask);
        cmnd[3] = (byte)(1 << (pnum >> maskShift & 7));
    }

    private void logBin(boolean sent, byte[] buff, int leng) {
        if (!this.logLF) {
            this.log.println();
        }
        GregorianCalendar cal = new GregorianCalendar();
        cal.setTimeInMillis(System.currentTimeMillis());
        int j = 0;
        while (j < leng) {
            if ((j & 0x1F) == 0) {
                if (j == 0) {
                    this.log.format("%tF %<tT.%<tL: Bin %s:", cal, sent ? "cmnd" : "resp");
                } else {
                    this.log.format("\n%34s", "");
                }
            }
            if ((j & 3) == 0) {
                this.log.print(" ");
            }
            this.log.format("%02x", buff[j ^ 3]);
            ++j;
        }
        this.log.println();
        this.logLF = true;
    }

    private void logAscii(boolean sent, boolean first, byte[] buff, int offs, int leng) {
        if (first) {
            if (!this.logLF) {
                this.log.println();
            }
            GregorianCalendar cal = new GregorianCalendar();
            cal.setTimeInMillis(System.currentTimeMillis());
            this.log.format("%tF %<tT.%<tL: Asc %s: ", cal, sent ? "cmnd" : "resp");
            this.logLF = false;
        }
        int end = offs + leng;
        int pos = offs;
        pos = offs;
        while (pos < end) {
            if (buff[pos] == 10) {
                if (this.logLF) {
                    this.log.format("%35s", "");
                }
                this.log.write(buff, offs, pos + 1 - offs);
                offs = pos + 1;
                this.logLF = true;
            }
            ++pos;
        }
        if (pos > offs) {
            if (this.logLF) {
                this.log.format("%35s", "");
            }
            this.log.write(buff, offs, pos - offs);
            this.logLF = false;
        }
    }

    private void logStr(String cmnd) {
        if (!this.logLF) {
            this.log.println();
        }
        GregorianCalendar cal = new GregorianCalendar();
        cal.setTimeInMillis(System.currentTimeMillis());
        this.log.format("%tF %<tT.%<tL: Asc cmnd: %s\n", cal, cmnd);
        this.logLF = true;
    }

    private class Cleanup
    extends Thread {
        private Cleanup() {
        }

        @Override
        public void run() {
            AcrComm.this.exiting = true;
            try {
                AcrComm.this.drain();
            }
            catch (RuntimeException runtimeException) {
                AcrComm.this.out.println("Error draining sockets");
            }
            try {
                if (AcrComm.this.mgmtSock != null) {
                    AcrComm.this.mgmtSock.close();
                }
            }
            catch (IOException iOException) {
                AcrComm.this.out.println("Error closing watchdog socket");
            }
            try {
                if (AcrComm.this.binSock != null) {
                    AcrComm.this.binSock.close();
                }
            }
            catch (IOException iOException) {
                AcrComm.this.out.println("Error closing binary socket");
            }
            if (AcrComm.this.log != null) {
                AcrComm.this.log.close();
            }
        }
    }

    public class Exception
    extends RuntimeException {
        public Exception(Throwable e) {
            super(e);
        }
    }

    private class Watchdog
    implements Runnable {
        private Watchdog() {
        }

        @Override
        public void run() {
            int period = 5000;
            byte[] cmnd = new byte[24];
            byte[] resp = new byte[24];
            Convert.intToBytesBE(1, cmnd, 0);
            Convert.intToBytesBE(period, cmnd, 4);
            Convert.intToBytesBE(3, cmnd, 8);
            Convert.intToBytesBE(AcrComm.this.ipAddr, cmnd, 12);
            Convert.intToBytesBE(AcrComm.this.binPort, cmnd, 16);
            Convert.intToBytesBE(0, cmnd, 20);
            while (!AcrComm.this.exiting) {
                int nRead;
                try {
                    AcrComm.this.mgmtOut.write(cmnd, 0, cmnd.length);
                }
                catch (IOException e) {
                    throw new Exception((Throwable)e);
                }
                int offs = 0;
                do {
                    try {
                        nRead = AcrComm.this.mgmtInp.read(resp, offs, resp.length - offs);
                    }
                    catch (SocketTimeoutException socketTimeoutException) {
                        nRead = 0;
                    }
                    catch (IOException e) {
                        throw new Exception((Throwable)e);
                    }
                    if (nRead <= 0) continue;
                    offs += nRead;
                } while (offs < resp.length && nRead > 0);
                try {
                    Thread.sleep(period);
                }
                catch (InterruptedException interruptedException) {
                    break;
                }
            }
        }
    }
}

