/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.drivers.parker;

import java.io.IOException;
import java.util.GregorianCalendar;
import java.util.Scanner;
import jline.ConsoleReader;
import org.lsst.ccs.drivers.parker.AcrComm;
import org.lsst.ccs.utilities.sa.CmndProc;
import org.lsst.ccs.utilities.sa.ConsOut;
import org.lsst.ccs.utilities.sa.Output;

public class TestAcrComm
implements CmndProc.Dispatch {
    private static final int CMD_SEND = 0;
    private static final int CMD_DRAIN = 1;
    private static final int CMD_PDUMP = 2;
    private static final int CMD_PIDUMP = 3;
    private static final int CMD_PFDUMP = 4;
    private static final int CMD_PADUMP = 5;
    private static final int CMD_PISHOW = 6;
    private static final int CMD_PFSHOW = 7;
    private static final int CMD_IPEEK = 8;
    private static final int CMD_FPEEK = 9;
    private static final int CMD_BSHOW = 10;
    private static final int CMD_BSET = 11;
    private static final int CMD_BCLR = 12;
    private static final int CMD_CTRLX = 13;
    private static final int CMD_CTRLY = 14;
    private static final int CMD_CTRLZ = 15;
    private static final int CMD_VADUMP = 16;
    private static final int CMD_VSHOW = 17;
    private static final int CMD_VDUMP = 18;
    private static final int CMD_VCSHOW = 19;
    private static final int CMD_PMAP = 20;
    private static final int CMD_PGSHOW = 21;
    private static final int CMD_PISET = 22;
    private static final int CMD_PFSET = 23;
    private static final int CMD_PUSHOW = 24;
    private static final int CMD_PUSET = 25;
    private static final int CMD_TIME = 26;
    private static final int CMD_LOPEN = 27;
    private static final int CMD_LCLOSE = 28;
    private static final int CMD_CLOCK = 29;
    private static final int CMD_PGDUMP = 30;
    private static final int NUM_CMDS = 31;
    private static final String[] helpSend = new String[]{"Send a file to the controller", "send <filename>", "filename  The name of the file to send"};
    private static final String[] helpDrain = new String[]{"Drain the input from the controller", "drain"};
    private static final String[] helpPmap = new String[]{"Show map of valid parameters", "pmap <first> [<count>]", "first   The number of the first parameter to map", "count   The optional number of parameters to map (default 64)"};
    private static final String[] helpPdump = new String[]{"Dump parameter values", "pdump <first> [<count>]", "first   The number of the first parameter to dump", "count   The optional number of parameters to dump (default 1)"};
    private static final String[] helpPidump = new String[]{"Dump parameter values as integers", "pidump <first> [<count>]", "first   The number of the first parameter to dump", "count   The optional number of parameters to dump (default 1)"};
    private static final String[] helpPfdump = new String[]{"Dump parameter values as floats", "pfdump <first> [<count>]", "first   The number of the first parameter to dump", "count   The optional number of parameters to dump (default 1)"};
    private static final String[] helpPadump = new String[]{"Dump parameter addresses", "padump <first> [<count>]", "first   The number of the first parameter address to dump", "count   The optional number of addresses to dump (default 1)"};
    private static final String[] helpPgdump = new String[]{"Dump (in hexadecimal) a named group of parameters", "pgdump <group>", "group   The name of the parameter group to dump"};
    private static final String[] helpPishow = new String[]{"Show parameter values as integers", "pishow <first> [<count>]", "first   The number of the first parameter to show", "count   The optional number of parameters to show (default 1)"};
    private static final String[] helpPfshow = new String[]{"Show parameter values as floats", "pfshow <first> [<count>]", "first   The number of the first parameter to show", "count   The optional number of parameters to show (default 1)"};
    private static final String[] helpPushow = new String[]{"Show user parameter values (doubles)", "pushow <first> [<count>]", "first   The number of the first user parameter to show", "count   The optional number of parameters to show (default 1)"};
    private static final String[] helpPgshow = new String[]{"Show a named group of parameters", "pgshow <group>", "group   The name of the parameter group to display"};
    private static final String[] helpPiset = new String[]{"Set the value of an integer parameter", "piset   <parm> <value>", "parm    The number of the parameter to set", "value   The value to set"};
    private static final String[] helpPfset = new String[]{"Set the value of a float parameter", "pfset   <parm> <value>", "parm    The number of the parameter to set", "value   The value to set"};
    private static final String[] helpPuset = new String[]{"Set the values of user parameters (doubles)", "puset   <parm> <value1>... [<value8>] ", "parm    The number of the first parameter to set", "valuen  The values to set"};
    private static final String[] helpVadump = new String[]{"Dump variable base address", "vadump <prog> [<type1>]... [<type8>]", "prog   The number of the program containing the variable(s)", "typen  The type of variable (dv, da, sv, sa, lv, la, $v, $a) dflt all"};
    private static final String[] helpVcshow = new String[]{"Show variable count", "vcshow <prog> [<type>] [<array>]", "prog   The number of the program containing the variable(s)", "type   The type of variable (dv, da, sv, sa, lv, la, $v, $a) dflt all", "array  The array index for array types, or -1 for all (default -1)"};
    private static final String[] helpVshow = new String[]{"Show variable values", "vshow <prog> <type> [<array>] [<index>] [<count>]", "prog   The number of the program containing the variable(s)", "type   The type of variable (dv, da, sv, sa, lv, la, $v or $a)", "array  The array index (default 0)", "index  The index of the first variable to show (default 0)", "count  The number of variables to show or -1 for all (default 1)"};
    private static final String[] helpVdump = new String[]{"Dump variable values", "vdump <prog> <type> [<array>] [<index>] [<count>]", "prog   The number of the program containing the variable(s)", "type   The type of variable (dv, da, sv, sa, lv or la)", "array  The array index (default 0)", "index  The index of the first variable to show (default 0)", "count  The number of variables to show or -1 for all (default 1)"};
    private static final String[] helpIpeek = new String[]{"Dump memory contents as integers", "ipeek <first> [<count>]", "first   The address of the first word to dump", "count   The optional number of words to dump (default 1)"};
    private static final String[] helpFpeek = new String[]{"Dump memory contents as floats", "fpeek <first> [<count>]", "first   The address of the first word to dump", "count   The optional number of words to dump (default 1)"};
    private static final String[] helpBshow = new String[]{"Show flag bit values", "bshow <first> [<count>]", "first   The number of the first flag bit to show", "count   The optional number of flag bits to show (default 1)"};
    private static final String[] helpBset = new String[]{"Set a flag bit", "bset <bitnum>", "bitnum  The number (0 - 65535) of the flag bit to set"};
    private static final String[] helpBclr = new String[]{"Clear a flag bit", "bclr <bitnum>", "bitnum  The number (0 - 65535) of the flag bit to clear"};
    private static final String[] helpTime = new String[]{"Time various operations", "time <type> [<count>]", "type   The type of operation to time (binary, ascii, null, program)", "count  The number of operations to do (default 10)"};
    private static final String[] helpClock = new String[]{"Display controller clock periodically", "clock <period> [<type>]", "period  The period (in seconds) between clock displays; 0 = stop", "type    The clock to display: 0 = uptime; 1 = realtime"};
    private static final String[] helpLopen = new String[]{"Open the log file", "lopen [<name>]", "name  The name of the root portion of the log file"};
    private static final String[] helpLclose = new String[]{"Close the log file", "lclose"};
    private static final String[] helpX = new String[]{"Send ctrl-X", "x"};
    private static final String[] helpY = new String[]{"Send ctrl-Y", "y"};
    private static final String[] helpZ = new String[]{"Send ctrl-Z", "z"};
    private static final int TIM_TYP_BINARY = 0;
    private static final int TIM_TYP_ASCII = 1;
    private static final int TIM_TYP_NULL = 2;
    private static final int TIM_TYP_PROG = 3;
    private static final int PGRP_MSTATUS = 0;
    private static final int PGRP_MCONFIG = 1;
    private static final int PGRP_JOG = 2;
    private static final int PGRP_POSITION = 3;
    private static final int PGRP_SERVO = 4;
    private static final int PGRP_LIMITS = 5;
    private static final int PGRP_MISC = 6;
    private static final int NUM_PGRPS = 7;
    private int clockPeriod;
    private int clockType = 0;
    private final Output out;
    private final CmndProc.Lookup varTypes;
    private final CmndProc.Lookup groupNames;
    private final CmndProc.Lookup timeTypes;
    private ConsoleReader reader;
    private CmndProc proc;
    private AcrComm acr;
    private boolean acrMode = false;
    private ParmGroup[] groups = new ParmGroup[7];
    private Thread clockThread;

    public TestAcrComm(AcrComm iAcr, String node, CmndProc cProc, boolean log, Output iOut) throws IOException {
        this.out = iOut != null ? iOut : new ConsOut();
        CmndProc.Command cmnd = new CmndProc.Command(31);
        cmnd.add("send", 0, helpSend);
        cmnd.add("drain", 1, helpDrain);
        cmnd.add("pmap", 20, helpPmap);
        cmnd.add("pdump", 2, helpPdump);
        cmnd.add("pidump", 3, helpPidump);
        cmnd.add("pfdump", 4, helpPfdump);
        cmnd.add("padump", 5, helpPadump);
        cmnd.add("pgdump", 30, helpPgdump);
        cmnd.add("pishow", 6, helpPishow);
        cmnd.add("pfshow", 7, helpPfshow);
        cmnd.add("pushow", 24, helpPushow);
        cmnd.add("pgshow", 21, helpPgshow);
        cmnd.add("piset", 22, helpPiset);
        cmnd.add("pfset", 23, helpPfset);
        cmnd.add("puset", 25, helpPuset);
        cmnd.add("vadump", 16, helpVadump);
        cmnd.add("vshow", 17, helpVshow);
        cmnd.add("vcshow", 19, helpVcshow);
        cmnd.add("vdump", 18, helpVdump);
        cmnd.add("ipeek", 8, helpIpeek);
        cmnd.add("fpeek", 9, helpFpeek);
        cmnd.add("bshow", 10, helpBshow);
        cmnd.add("bset", 11, helpBset);
        cmnd.add("bclr", 12, helpBclr);
        cmnd.add("time", 26, helpTime);
        cmnd.add("clock", 29, helpClock);
        cmnd.add("lopen", 27, helpLopen);
        cmnd.add("lclose", 28, helpLclose);
        cmnd.add("x", 13, helpX);
        cmnd.add("y", 14, helpY);
        cmnd.add("z", 15, helpZ);
        this.timeTypes = new CmndProc.Lookup(4);
        this.timeTypes.add("binary", 0);
        this.timeTypes.add("ascii", 1);
        this.timeTypes.add("program", 3);
        this.timeTypes.add("null", 2);
        this.varTypes = new CmndProc.Lookup(8);
        this.varTypes.add("dv", 0);
        this.varTypes.add("da", 1);
        this.varTypes.add("sv", 2);
        this.varTypes.add("sa", 3);
        this.varTypes.add("lv", 4);
        this.varTypes.add("la", 5);
        this.varTypes.add("$v", 6);
        this.varTypes.add("$a", 7);
        this.groupNames = new CmndProc.Lookup(7);
        this.groupNames.add("mstatus", 0);
        this.groupNames.add("mconfig", 1);
        this.groupNames.add("jog", 2);
        this.groupNames.add("position", 3);
        this.groupNames.add("servo", 4);
        this.groupNames.add("limits", 5);
        this.groupNames.add("misc", 6);
        ParmGroup pGroup = this.groups[0] = new ParmGroup("Motor status", 16);
        pGroup.add("S6  - Continuous Current Rating", 28736, 1);
        pGroup.add("S7  - Maximum Current Rating", 28737, 1);
        pGroup.add("S9  - Commanded Current", 28738, 1);
        pGroup.add("S10 - Commanded Torque / Force", 28739, 1);
        pGroup.add("S11 - Actual Torque / Force", 28740, 1);
        pGroup.add("S16 - Position of Encoder", 28693, 0);
        pGroup.add("S20 - Drive Temperature", 28743, 1);
        pGroup.add("S21 - Modelled Motor Temperature", 28744, 1);
        pGroup.add("S22 - Bus Voltage", 28745, 1);
        pGroup.add("S24 - Operating Hours", 28695, 0);
        pGroup.add("S25 - Operating Minutes", 28696, 0);
        pGroup.add("S26 - Operating Milliseconds", 28697, 0);
        pGroup.add("S27 - Hall State", 28694, 0);
        pGroup.add("S33 - Power-Up Hours", -1, 0);
        pGroup.add("S34 - Power-Up Minutes", -1, 0);
        pGroup.add("S35 - Feedback Source", -1, 0);
        pGroup = this.groups[1] = new ParmGroup("Motor configuration", 41);
        pGroup.add("C0   - Encoder resolution", 28674, 0);
        pGroup.add("C1   - Continuous current", 28704, 1);
        pGroup.add("C2   - Continuous Current Derating", 28705, 1);
        pGroup.add("C3   - Peak Current", 28706, 1);
        pGroup.add("C4   - Motor Inductance", 28707, 1);
        pGroup.add("C5   - Motor Inductance Factor", 28708, 1);
        pGroup.add("C6   - Maximum Motor Winding Temperature", 28709, 1);
        pGroup.add("C7   - Motor Winding Resistance", 28710, 1);
        pGroup.add("C8   - Motor Rated Speed", 28711, 1);
        pGroup.add("C9   - Number of Motor Pole Pairs", 28675, 0);
        pGroup.add("C10  - Motor Damping", 28712, 1);
        pGroup.add("C11  - Motor Rotor Inertia / Forcer Mass", 28713, 1);
        pGroup.add("C12  - Motor Electrical Pitch", 28715, 1);
        pGroup.add("C14  - Torque / Force Limit", 28717, 1);
        pGroup.add("C15  - Motor Ke", 28714, 1);
        pGroup.add("C16  - Current Loop Bandwidth", -1, 0);
        pGroup.add("C18  - Current Foldback Enable", 28684, 0);
        pGroup.add("C20  - Encoder Polarity", -1, 0);
        pGroup.add("C21  - Max. Pre-Quadrature Encoder Frequency", -1, 0);
        pGroup.add("C22  - Hall Sensor Configuration", -1, 0);
        pGroup.add("C23  - Hall-Only Commutation", -1, 0);
        pGroup.add("C25  - Motor Temperature Switch Type", 28682, 0);
        pGroup.add("C26  - Motor Ambient Temperature", 28719, 1);
        pGroup.add("C27  - Motor Winding Thermal Resistance", 28720, 1);
        pGroup.add("C28  - Motor Thermal Time Constant", 28721, 1);
        pGroup.add("C29  - Motor Winding Time Constant", 28722, 1);
        pGroup.add("C38  - Drive PWM Frequency", -1, 0);
        pGroup.add("C39  - Thermal Switch Checking", -1, 0);
        pGroup.add("C41  - Output Brake Delay", -1, 0);
        pGroup.add("C44  - Error Log Selection", -1, 0);
        pGroup.add("C46  - Fault on Drive Disable", 28685, 0);
        pGroup.add("C47  - Custom Winding Number", -1, 0);
        pGroup.add("C67  - Drive Control Mode", 28680, 0);
        pGroup.add("C81  - Set Alignment Angle", -1, 0);
        pGroup.add("C82  - Encoder Offset", -1, 1);
        pGroup.add("C103 - Drive Disable Delay", -1, 0);
        pGroup.add("C117 - I/O Debounce Time", -1, 0);
        pGroup.add("C119 - Hall-Less Commutation Gain", -1, 0);
        pGroup.add("C120 - Hall-Less Commutation Peak Current", -1, 1);
        pGroup.add("C121 - Hall-Less Commutation Damping", -1, 0);
        pGroup.add("C137 - Encoder Loss Time", -1, 0);
        pGroup = this.groups[2] = new ParmGroup("JOG Parameters", 6);
        pGroup.add("JOG VEL Setting", 12348, 1);
        pGroup.add("JOG ACC Setting", 12349, 1);
        pGroup.add("JOG DEC Setting", 12350, 1);
        pGroup.add("JOG JRK Setting", 12351, 1);
        pGroup.add("Current JOG VEL", 12346, 1);
        pGroup.add("Current JOG ACC", 12347, 1);
        pGroup = this.groups[3] = new ParmGroup("Position Parameters", 8);
        pGroup.add("Current Position", 12288, 0);
        pGroup.add("Target Position", 12289, 0);
        pGroup.add("Actual Position", 12290, 0);
        pGroup.add("Following Error", 12291, 0);
        pGroup.add("Hardware Capture", 12292, 0);
        pGroup.add("Software Capture", 12293, 0);
        pGroup.add("Primary Setpoint", 12294, 0);
        pGroup.add("Secondary Setpoint", 12295, 0);
        pGroup = this.groups[4] = new ParmGroup("Servo Parameters", 8);
        pGroup.add("Proportional Gain (PGAIN)", 12304, 1);
        pGroup.add("Integral Gain (IGAIN)", 12305, 1);
        pGroup.add("Integral Limit (ILIMIT)", 12306, 1);
        pGroup.add("Integral Delay (IDELAY)", 12307, 1);
        pGroup.add("Derivative Gain (DGAIN)", 12308, 1);
        pGroup.add("Derivative Width (DWIDTH)", 12309, 1);
        pGroup.add("Feedforward Velocity (FFVEL)", 12310, 1);
        pGroup.add("Feedforward Acceleration (FFACC)", 12311, 1);
        pGroup = this.groups[5] = new ParmGroup("Limit Parameters", 15);
        pGroup.add("Plus Excess Error (EXC)", 12320, 1);
        pGroup.add("Minus Excess Error (EXC)", 12321, 1);
        pGroup.add("Plus In Position (IPB)", 12322, 1);
        pGroup.add("Minus In Position (IPB)", 12323, 1);
        pGroup.add("Plus A Limit (ALM)", 12324, 1);
        pGroup.add("Minus A Limit (ALM)", 12325, 1);
        pGroup.add("Plus B Limit (BLM)", 12326, 1);
        pGroup.add("Minus B Limit (BLM)", 12327, 1);
        pGroup.add("Plus Torque Limit (TLM)", 12328, 1);
        pGroup.add("Minus Torque Limit (TLM)", 12329, 1);
        pGroup.add("Plus Torque Band", 12330, 1);
        pGroup.add("Minus Torque Band", 12331, 1);
        pGroup.add("Backlash Setting (BKL)", 12332, 1);
        pGroup.add("Plus Jog Limit (JLM)", 12334, 1);
        pGroup.add("Minus Jog Limit (JLM)", 12335, 1);
        pGroup = this.groups[6] = new ParmGroup("Miscellaneous Parameters", 3);
        pGroup.add("System Clock", 6916, 0);
        pGroup.add("Encoder Position", 6144, 0);
        pGroup.add("PPU", 12375, 1);
        this.reader = new ConsoleReader();
        this.acr = iAcr == null ? new AcrComm(node, log, this.out) : iAcr;
        this.proc = cProc == null ? new CmndProc() : cProc;
        this.proc.add((CmndProc.Dispatch)this, cmnd);
    }

    public TestAcrComm(AcrComm acr, CmndProc cProc, boolean log, Output iOut) throws IOException {
        this(acr, "", cProc, log, iOut);
    }

    public TestAcrComm(String node, CmndProc cProc, boolean log, Output iOut) throws IOException {
        this(null, node, cProc, log, iOut);
    }

    public static void main(String[] args) {
        TestAcrComm tacr = null;
        if (args.length == 0) {
            System.out.println("No controller node specified");
            System.exit(0);
        }
        try {
            tacr = new TestAcrComm(args[0], null, args.length > 1, null);
            tacr.run();
        }
        catch (AcrComm.Exception e) {
            System.out.println(e);
        }
        catch (IOException e) {
            System.out.println(e);
        }
        System.exit(0);
    }

    public void run() throws IOException {
        String line;
        while ((line = this.reader.readLine(this.getPrompt())) != null && this.process(line)) {
        }
    }

    public boolean process(String line) {
        boolean other = false;
        String cLine = line;
        if (line.length() > 0 && line.substring(0, 1).equals("/")) {
            other = true;
            cLine = line.substring(1);
            if (cLine.isEmpty()) {
                this.acrMode ^= true;
                return true;
            }
        }
        if (other ^ this.acrMode) {
            int leng = this.acr.sendStr(cLine, 0);
            boolean cont = true;
            if (leng <= 0) {
                this.out.println((Object)(leng == 0 ? "Controller not responding" : "Controller disconnected"));
                cont = false;
            }
            return cont;
        }
        return this.proc.process(cLine);
    }

    public String getPrompt() {
        return this.acrMode ? this.acr.getPrompt() : ">> ";
    }

    public AcrComm getComm() {
        return this.acr;
    }

    public boolean dispatch(int code, Scanner scan) {
        Object[] args = new Object[16];
        switch (code) {
            case 0: {
                int found = CmndProc.scanArgs((Scanner)scan, (String)"Sb", (Object[])args);
                if (found < 0) break;
                this.acr.sendFile((String)args[0], (found & 2) == 0 ? 0 : (int)((Byte)args[1]).byteValue());
                break;
            }
            case 1: {
                this.acr.drain();
                break;
            }
            case 20: {
                int found = CmndProc.scanArgs((Scanner)scan, (String)"Ii", (Object[])args);
                if (found < 0) break;
                this.mapParms((Integer)args[0], (found & 2) == 0 ? 64 : (Integer)args[1]);
                break;
            }
            case 2: {
                int found = CmndProc.scanArgs((Scanner)scan, (String)"Ii", (Object[])args);
                if (found < 0) break;
                this.dumpParms((Integer)args[0], (found & 2) == 0 ? 1 : (Integer)args[1], 0);
                break;
            }
            case 3: {
                int found = CmndProc.scanArgs((Scanner)scan, (String)"Ii", (Object[])args);
                if (found < 0) break;
                this.dumpParms((Integer)args[0], (found & 2) == 0 ? 1 : (Integer)args[1], 1);
                break;
            }
            case 4: {
                int found = CmndProc.scanArgs((Scanner)scan, (String)"Ii", (Object[])args);
                if (found < 0) break;
                this.dumpParms((Integer)args[0], (found & 2) == 0 ? 1 : (Integer)args[1], 2);
                break;
            }
            case 5: {
                int found = CmndProc.scanArgs((Scanner)scan, (String)"Ii", (Object[])args);
                if (found < 0) break;
                this.dumpParms((Integer)args[0], (found & 2) == 0 ? 1 : (Integer)args[1], 3);
                break;
            }
            case 6: {
                int found = CmndProc.scanArgs((Scanner)scan, (String)"Ii", (Object[])args);
                if (found < 0) break;
                this.showParms((Integer)args[0], (found & 2) == 0 ? 1 : (Integer)args[1], 1);
                break;
            }
            case 7: {
                int found = CmndProc.scanArgs((Scanner)scan, (String)"Ii", (Object[])args);
                if (found < 0) break;
                this.showParms((Integer)args[0], (found & 2) == 0 ? 1 : (Integer)args[1], 2);
                break;
            }
            case 24: {
                int found = CmndProc.scanArgs((Scanner)scan, (String)"Ii", (Object[])args);
                if (found < 0) break;
                this.showUserParms((Integer)args[0], (found & 2) == 0 ? 1 : (Integer)args[1]);
                break;
            }
            case 21: 
            case 30: {
                int found = CmndProc.scanArgs((Scanner)scan, (String)"s", (Object[])args);
                if (found < 0) break;
                int pnum = (found & 1) == 0 ? -1 : this.groupNames.encode((String)args[0], true);
                if (pnum < 0) {
                    this.showPgroups();
                    break;
                }
                this.showPgroup(pnum, code == 30);
                break;
            }
            case 22: {
                int found = CmndProc.scanArgs((Scanner)scan, (String)"II", (Object[])args);
                if (found < 0) break;
                this.acr.setIntParm((Integer)args[0], (Integer)args[1]);
                break;
            }
            case 23: {
                int found = CmndProc.scanArgs((Scanner)scan, (String)"IF", (Object[])args);
                if (found < 0) break;
                this.acr.setFloatParm((Integer)args[0], ((Float)args[1]).floatValue());
                break;
            }
            case 25: {
                int found = CmndProc.scanArgs((Scanner)scan, (String)"IDddddddd", (Object[])args);
                if (found < 0) break;
                double[] dVal = new double[8];
                int count = 0;
                int j = 1;
                while (j <= 8) {
                    if ((found & 1 << j) != 0) {
                        dVal[count++] = (Double)args[j];
                    }
                    ++j;
                }
                this.acr.setUserParms((Integer)args[0], dVal, count);
                break;
            }
            case 16: {
                int found = CmndProc.scanArgs((Scanner)scan, (String)"Issssssss", (Object[])args);
                if (found < 0) break;
                int mask = 0;
                int j = 1;
                while (j < 9) {
                    int type;
                    if ((found & 1 << j) != 0 && (mask |= (type = this.varTypes.encode((String)args[j], true)) < 0 ? type : 1 << type) < 0) break;
                    ++j;
                }
                if (mask < 0) break;
                if (mask == 0) {
                    mask = 255;
                }
                this.dumpVaddr((Integer)args[0], mask);
                break;
            }
            case 17: {
                int type;
                int found = CmndProc.scanArgs((Scanner)scan, (String)"ISiii", (Object[])args);
                if (found < 0 || (type = this.varTypes.encode((String)args[1], true)) < 0) break;
                this.showVars((Integer)args[0], type, (found & 4) == 0 ? 0 : (Integer)args[2], (found & 8) == 0 ? 0 : (Integer)args[3], (found & 0x10) == 0 ? 1 : (Integer)args[4]);
                break;
            }
            case 19: {
                int type;
                int found = CmndProc.scanArgs((Scanner)scan, (String)"ISi", (Object[])args);
                if (found < 0 || (type = this.varTypes.encode((String)args[1], true)) < 0) break;
                this.showVcount((Integer)args[0], type, (found & 4) == 0 ? -1 : (Integer)args[2]);
                break;
            }
            case 18: {
                int type;
                int found = CmndProc.scanArgs((Scanner)scan, (String)"ISiii", (Object[])args);
                if (found < 0 || (type = this.varTypes.encode((String)args[1], true)) < 0) break;
                this.dumpVars((Integer)args[0], type, (found & 4) == 0 ? 0 : (Integer)args[2], (found & 8) == 0 ? 0 : (Integer)args[3], (found & 0x10) == 0 ? 1 : (Integer)args[4]);
                break;
            }
            case 8: {
                int found = CmndProc.scanArgs((Scanner)scan, (String)"Ii", (Object[])args);
                if (found < 0) break;
                this.dumpAddr((Integer)args[0], (found & 2) == 0 ? 1 : (Integer)args[1], 0);
                break;
            }
            case 9: {
                int found = CmndProc.scanArgs((Scanner)scan, (String)"Ii", (Object[])args);
                if (found < 0) break;
                this.dumpAddr((Integer)args[0], (found & 2) == 0 ? 1 : (Integer)args[1], 2);
                break;
            }
            case 10: {
                int found = CmndProc.scanArgs((Scanner)scan, (String)"Ii", (Object[])args);
                if (found < 0) break;
                this.showBits((Integer)args[0], (found & 2) == 0 ? 1 : (Integer)args[1]);
                break;
            }
            case 11: {
                int found = CmndProc.scanArgs((Scanner)scan, (String)"I", (Object[])args);
                if (found < 0) break;
                this.acr.setBit((Integer)args[0]);
                break;
            }
            case 12: {
                int found = CmndProc.scanArgs((Scanner)scan, (String)"I", (Object[])args);
                if (found < 0) break;
                this.acr.clearBit((Integer)args[0]);
                break;
            }
            case 26: {
                int type;
                int found = CmndProc.scanArgs((Scanner)scan, (String)"Si", (Object[])args);
                if (found < 0 || (type = this.timeTypes.encode((String)args[0], true)) < 0) break;
                this.doTime(type, (found & 2) == 0 ? 10 : (Integer)args[1]);
                break;
            }
            case 29: {
                int found = CmndProc.scanArgs((Scanner)scan, (String)"Ii", (Object[])args);
                if (found < 0) break;
                this.clockPeriod = (Integer)args[0];
                if ((found & 2) != 0) {
                    this.clockType = (Integer)args[1];
                }
                if (this.clockPeriod > 0) {
                    if (this.clockThread != null) break;
                    this.clockThread = new Thread(new ClockTest());
                    this.clockThread.start();
                    break;
                }
                if (this.clockThread == null) break;
                this.clockThread.interrupt();
                break;
            }
            case 27: {
                int found = CmndProc.scanArgs((Scanner)scan, (String)"s", (Object[])args);
                if (found < 0) break;
                this.acr.logOpen((found & 1) == 0 ? null : (String)args[0]);
                break;
            }
            case 28: {
                int found = CmndProc.scanArgs((Scanner)scan, (String)"", (Object[])args);
                if (found < 0) break;
                this.acr.logClose();
                break;
            }
            case 13: {
                byte[] byArray = new byte[4];
                byArray[0] = 24;
                byte[] ctrlx = byArray;
                this.acr.sendBin(ctrlx);
                break;
            }
            case 14: {
                byte[] byArray = new byte[4];
                byArray[0] = 25;
                byte[] ctrly = byArray;
                this.acr.sendBin(ctrly);
                break;
            }
            case 15: {
                byte[] byArray = new byte[4];
                byArray[0] = 26;
                byte[] ctrlz = byArray;
                this.acr.sendBin(ctrlz);
                break;
            }
            default: {
                this.out.println((Object)"Command not fully implemented");
            }
        }
        return true;
    }

    private void mapParms(int pnum, int count) {
        char[] line = new char[72];
        int j = 0;
        while (j < line.length) {
            line[j] = 32;
            j += 9;
        }
        int nValid = 0;
        int posn = 1;
        int sPnum = pnum;
        int j2 = 0;
        while (j2 < count) {
            if ((j2 & 0x3F) == 0) {
                if (nValid != 0) {
                    this.out.format("%6s:%s\n", new Object[]{"P" + sPnum, String.copyValueOf(line)});
                }
                nValid = 0;
                posn = 1;
                sPnum = pnum;
            } else if ((j2 & 7) == 0) {
                ++posn;
            }
            if (this.acr.getParmAddr(pnum) == 0) {
                line[posn++] = 46;
            } else {
                line[posn++] = 88;
                ++nValid;
            }
            ++j2;
            ++pnum;
        }
        if (nValid != 0) {
            this.out.format("%6s:%s\n", new Object[]{"P" + sPnum, String.copyValueOf(line, 0, posn)});
        }
    }

    private void dumpParms(int pnum, int count, int type) {
        int j = 0;
        while (j < count) {
            if ((j & 7) == 0) {
                if (j != 0) {
                    this.out.println();
                }
                this.out.format("%6s:", new Object[]{"P" + pnum});
            }
            int value = type == 0 ? this.acr.getParmAsInt(pnum) : (type == 1 ? this.acr.getIntParm(pnum) : (type == 2 ? this.acr.getFloatParmAsInt(pnum) : this.acr.getParmAddr(pnum)));
            this.out.format(" %08x", new Object[]{value});
            ++j;
            ++pnum;
        }
        this.out.println();
    }

    private void showParms(int pnum, int count, int type) {
        int lLine = 81;
        int j = 0;
        while (j < count) {
            String word;
            String string = word = type == 1 ? "  " + this.acr.getIntParm(pnum) : "  " + this.acr.getFloatParm(pnum);
            if (lLine + word.length() > 80) {
                if (j != 0) {
                    this.out.println();
                }
                this.out.format("%6s:", new Object[]{"P" + pnum});
                lLine = 7;
            }
            this.out.print((Object)word);
            lLine += word.length();
            ++j;
            ++pnum;
        }
        this.out.println();
    }

    private void showUserParms(int pnum, int count) {
        double[] value = new double[32];
        int nLine = 0;
        int lLine = 81;
        int nGet = value.length;
        int j = 0;
        while (j < count) {
            if (nGet > count - j) {
                nGet = count - j;
            }
            this.acr.getUserParms(pnum, value, nGet);
            int k = 0;
            while (k < nGet) {
                String word = "  " + value[k];
                if (lLine + word.length() > 80) {
                    if (nLine++ != 0) {
                        this.out.println();
                    }
                    this.out.format("%6s:", new Object[]{"P" + pnum});
                    lLine = 7;
                }
                this.out.print((Object)word);
                lLine += word.length();
                ++k;
                ++pnum;
            }
            j += nGet;
        }
        this.out.println();
    }

    private void showPgroups() {
        this.out.println((Object)"Defined parameter groups:");
        int j = 0;
        while (j < this.groupNames.count()) {
            this.out.format("  %-10s - %s\n", new Object[]{this.groupNames.name(j), this.groups[this.groupNames.code(j)].gName});
            ++j;
        }
    }

    private void showPgroup(int gnum, boolean dump) {
        int tempInt = this.acr.getIntParm(39167);
        float tempFloat = this.acr.getFloatParm(39423);
        ParmGroup group = this.groups[gnum];
        byte[] blank = new byte[group.mxlDesc];
        int j = 0;
        while (j < blank.length) {
            blank[j] = 32;
            ++j;
        }
        String sBlank = new String(blank);
        this.out.println((Object)(String.valueOf(group.gName) + ":"));
        int j2 = 0;
        while (j2 < group.nItem) {
            String sPnum;
            String sValue;
            String desc = group.desc[j2];
            int pnum = group.pnum[j2];
            if (pnum >= 0) {
                sValue = group.type[j2] == 0 ? (!dump ? " " + this.acr.getIntParm(pnum) : String.format(" %08x", this.acr.getIntParm(pnum))) : (!dump ? " " + this.acr.getFloatParm(pnum) : String.format(" %08x", this.acr.getFloatParmAsInt(pnum)));
                sPnum = String.format("[P%-5s]", pnum);
            } else {
                int value;
                String src = desc.substring(0, 4);
                if (group.type[j2] == 0) {
                    this.acr.sendStr("p39167 = " + src, 0);
                    value = this.acr.getIntParm(39167);
                    sValue = !dump ? " " + value : String.format(" %08x", value);
                } else {
                    this.acr.sendStr("p39423 = " + src, 0);
                    if (!dump) {
                        sValue = " " + this.acr.getFloatParm(39423);
                    } else {
                        value = this.acr.getFloatParmAsInt(39423);
                        sValue = String.format(" %08x", value);
                    }
                }
                sPnum = "        ";
            }
            this.out.format("%s  %s:%s  %s\n", new Object[]{sPnum, desc, sBlank.substring(0, group.mxlDesc - desc.length()), sValue});
            ++j2;
        }
        this.acr.setIntParm(39167, tempInt);
        this.acr.setFloatParm(39423, tempFloat);
    }

    private void dumpVaddr(int pnum, int tMask) {
        int nDump = 0;
        int type = 0;
        while (tMask != 0) {
            if ((tMask & 1) != 0) {
                if (nDump++ == 5) {
                    this.out.println();
                }
                int value = this.acr.getVarAddr(pnum, type);
                this.out.format("%s: %08x   ", new Object[]{this.varTypes.decode(type), value});
            }
            ++type;
            tMask >>>= 1;
        }
        this.out.println();
    }

    private void showVcount(int pnum, int type, int array) {
        int count = this.acr.getVarCount(pnum, type, array);
        if (count == 0) {
            return;
        }
        String cType = this.varTypes.decode(type);
        if ((type & 1) == 0) {
            this.out.println((Object)(String.valueOf(cType) + ":  " + count));
        } else if (array >= 0) {
            this.out.println((Object)(String.valueOf(cType) + array + ":  " + count));
        } else {
            int j = 0;
            while (j < count) {
                int aCount = this.acr.getVarCount(pnum, type, j);
                if (aCount > 0) {
                    this.out.println((Object)(String.valueOf(cType) + j + ":  " + aCount));
                }
                ++j;
            }
        }
    }

    private void showVars(int pnum, int type, int array, int index, int count) {
        int lLine = 81;
        if (count <= 0 && (count = this.acr.getVarCount(pnum, type, array)) == 0) {
            return;
        }
        if (index < 0) {
            index = 0;
        }
        if (array < 0) {
            array = 0;
        }
        switch (type) {
            case 4: 
            case 5: {
                String label;
                int[] iVal = new int[count];
                if (type == 4) {
                    label = "LV(";
                    count = this.acr.getVars(pnum, index, count, iVal);
                } else {
                    label = "LA" + array + "(";
                    count = this.acr.getVars(pnum, array, index, count, iVal);
                }
                int j = 0;
                while (j < count) {
                    String word = "  " + iVal[j];
                    if (lLine + word.length() > 80) {
                        if (j != 0) {
                            this.out.println();
                        }
                        String prefix = String.valueOf(label) + index + "):";
                        this.out.print((Object)prefix);
                        lLine = prefix.length();
                    }
                    this.out.print((Object)word);
                    lLine += word.length();
                    ++j;
                    ++index;
                }
                break;
            }
            case 2: 
            case 3: {
                String label;
                float[] fVal = new float[count];
                if (type == 2) {
                    label = "SV(";
                    count = this.acr.getVars(pnum, index, count, fVal);
                } else {
                    label = "SA" + array + "(";
                    count = this.acr.getVars(pnum, array, index, count, fVal);
                }
                int j = 0;
                while (j < count) {
                    String word = "  " + fVal[j];
                    if (lLine + word.length() > 80) {
                        if (j != 0) {
                            this.out.println();
                        }
                        String prefix = String.valueOf(label) + index + "):";
                        this.out.print((Object)prefix);
                        lLine = prefix.length();
                    }
                    this.out.print((Object)word);
                    lLine += word.length();
                    ++j;
                    ++index;
                }
                break;
            }
            case 0: 
            case 1: {
                String label;
                double[] dVal = new double[count];
                if (type == 0) {
                    label = "DV(";
                    count = this.acr.getVars(pnum, index, count, dVal);
                } else {
                    label = "DA" + array + "(";
                    count = this.acr.getVars(pnum, array, index, count, dVal);
                }
                int j = 0;
                while (j < count) {
                    String word = "  " + dVal[j];
                    if (lLine + word.length() > 80) {
                        if (j != 0) {
                            this.out.println();
                        }
                        String prefix = String.valueOf(label) + index + "):";
                        this.out.print((Object)prefix);
                        lLine = prefix.length();
                    }
                    this.out.print((Object)word);
                    lLine += word.length();
                    ++j;
                    ++index;
                }
                break;
            }
            case 6: 
            case 7: {
                String label;
                String[] sVal = new String[count];
                if (type == 6) {
                    label = "$V(";
                    count = this.acr.getVars(pnum, index, count, sVal);
                } else {
                    label = "$A" + array + "(";
                    count = this.acr.getVars(pnum, array, index, count, sVal);
                }
                int j = 0;
                while (j < count) {
                    String word = "  \"" + sVal[j] + "\"";
                    if (lLine + word.length() > 80) {
                        if (j != 0) {
                            this.out.println();
                        }
                        String prefix = String.valueOf(label) + index + "):";
                        this.out.print((Object)prefix);
                        lLine = prefix.length();
                    }
                    this.out.print((Object)word);
                    lLine += word.length();
                    ++j;
                    ++index;
                }
                break;
            }
        }
        if (count > 0) {
            this.out.println();
        }
    }

    private void dumpVars(int pnum, int type, int array, int index, int count) {
        String label;
        if (count <= 0 && (count = this.acr.getVarCount(pnum, type, array)) == 0) {
            return;
        }
        if (index < 0) {
            index = 0;
        }
        if (array < 0) {
            array = 0;
        }
        int wdSize = 1;
        if (type == 0 || type == 1) {
            wdSize = 2;
        }
        int[] iVal = new int[wdSize * count];
        if ((type & 1) == 0) {
            label = String.valueOf(this.varTypes.decode(type)) + "(";
            count = this.acr.peekVars(pnum, type, index, count, iVal);
        } else {
            label = String.valueOf(this.varTypes.decode(type)) + array + "(";
            count = this.acr.peekVars(pnum, type, array, index, count, iVal);
        }
        int lPref = (String.valueOf(label) + 8 * (index + count - 1) / 8 + ")").length();
        int j = 0;
        while (j < wdSize * count) {
            if ((j & 7) == 0) {
                if (j != 0) {
                    this.out.println();
                }
                String prefix = String.valueOf(label) + index + ")";
                this.out.format("%s%s:", new Object[]{prefix, "        ".substring(0, lPref - prefix.length())});
            }
            this.out.format(" %08x", new Object[]{iVal[j]});
            if (wdSize == 2) {
                this.out.format(" %08x", new Object[]{iVal[j + 1]});
            }
            j += wdSize;
            ++index;
        }
        if (count > 0) {
            this.out.println();
        }
    }

    private void dumpAddr(int addr, int count, int type) {
        int nPeek = count < 256 ? count : 255;
        int rCount = count;
        int l = 0;
        int[] value = new int[nPeek];
        int j = 0;
        while (j < count) {
            if (nPeek > rCount) {
                nPeek = rCount;
            }
            this.acr.peek(addr, type, value, nPeek);
            int k = 0;
            while (k < nPeek) {
                if ((l & 7) == 0) {
                    if (l != 0) {
                        this.out.println();
                    }
                    this.out.format("%08x:", new Object[]{addr + 4 * k});
                }
                this.out.format(" %08x", new Object[]{value[k]});
                ++k;
                ++l;
            }
            j += nPeek;
            addr += 4 * nPeek;
            rCount -= nPeek;
        }
        this.out.println();
    }

    private void showBits(int bnum, int count) {
        int pnum = (bnum >> 5) + 4096;
        int value = this.acr.getIntParm(pnum++) >> (bnum & 0x1F);
        int j = 0;
        while (j < count) {
            if ((bnum & 0x1F) == 0 && j != 0) {
                value = this.acr.getIntParm(pnum++);
            }
            if ((j & 0x1F) == 0) {
                if (j != 0) {
                    this.out.println();
                }
                this.out.format("%6s:", new Object[]{"B" + bnum});
            }
            this.out.print((Object)(" " + (value & 1)));
            ++j;
            ++bnum;
            value >>= 1;
        }
        this.out.println();
    }

    private void doTime(int type, int count) {
        int j;
        long sTime = System.currentTimeMillis();
        if (type == 0) {
            j = 0;
            while (j < count) {
                this.acr.getIntParm(6144);
                ++j;
            }
        } else if (type == 1) {
            j = 0;
            while (j < count) {
                this.acr.sendStr("axis0 ppu 1", 0);
                ++j;
            }
        } else if (type == 2) {
            j = 0;
            while (j < count) {
                ++j;
            }
        } else if (type == 3) {
            this.acr.sendStr("prog0", 0);
            this.acr.sendStr("new prog0", 0);
            this.acr.sendStr("program", 0);
            this.acr.sendStr("clear", 0);
            this.acr.sendStr("dim lv(1)", 0);
            this.acr.sendStr("for lv0 = 1 to " + count + " step 1", 0);
            this.acr.sendStr("axis0 ppu 1", 0);
            this.acr.sendStr("next", 0);
            this.acr.sendStr("endp", 0);
            this.acr.sendStr("lrun prog0", 0);
        }
        float delta = (float)(System.currentTimeMillis() - sTime) / 1000.0f;
        this.out.format("Performed %s operations in %.3f seconds\n", new Object[]{count, Float.valueOf(delta)});
    }

    private class ClockTest
    implements Runnable {
        private ClockTest() {
        }

        @Override
        public void run() {
            GregorianCalendar timeC = new GregorianCalendar();
            GregorianCalendar sTimeC = new GregorianCalendar();
            do {
                long time = System.currentTimeMillis();
                if (TestAcrComm.this.clockType == 0) {
                    TestAcrComm.this.acr.sendStr("p39167=s33", 0);
                    int hour = TestAcrComm.this.acr.getIntParm(39167);
                    TestAcrComm.this.acr.sendStr("p39167=s34", 0);
                    int minute = TestAcrComm.this.acr.getIntParm(39167);
                    long sTime = time - 60000L * (long)(minute + 60 * hour);
                    timeC.setTimeInMillis(time);
                    sTimeC.setTimeInMillis(sTime);
                    TestAcrComm.this.out.format("Cur Time: %te-%<tb-%<tY %<tT, Up Time: %02d:%02d, Sta Time: %te-%<tb-%<tY %<tT\n", new Object[]{timeC, hour, minute, sTimeC});
                } else {
                    long sTime = TestAcrComm.this.acr.getIntParm(6916);
                    sTime = time - (0xFFFFFFFFL & sTime);
                    timeC.setTimeInMillis(time);
                    sTimeC.setTimeInMillis(sTime);
                    TestAcrComm.this.out.format("Curr Time: %te-%<tb-%<tY %<tT.%<tL, Base Time: %te-%<tb-%<tY %<tT.%<tL\n", new Object[]{timeC, sTimeC});
                }
                try {
                    Thread.sleep(1000 * TestAcrComm.this.clockPeriod);
                }
                catch (InterruptedException interruptedException) {
                    break;
                }
            } while (TestAcrComm.this.clockPeriod > 0);
            TestAcrComm.this.clockThread = null;
        }
    }

    private class ParmGroup {
        private int nItem = 0;
        private String gName;
        private int mxlDesc = 0;
        private String[] desc;
        private int[] pnum;
        private int[] type;

        ParmGroup(String name, int count) {
            this.gName = name;
            this.desc = new String[count];
            this.pnum = new int[count];
            this.type = new int[count];
        }

        private void add(String iDesc, int iPnum, int iType) {
            this.desc[this.nItem] = iDesc;
            this.pnum[this.nItem] = iPnum;
            this.type[this.nItem] = iType;
            ++this.nItem;
            int lDesc = iDesc.length();
            if (lDesc > this.mxlDesc) {
                this.mxlDesc = lDesc;
            }
        }
    }
}

