/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.drivers.orielshutter;

import org.lsst.ccs.drivers.ascii.Ascii;
import org.lsst.ccs.drivers.commons.DriverConstants;
import org.lsst.ccs.drivers.commons.DriverException;

public class OrielShutter
extends Ascii {
    private int addrOffset = 0;

    public OrielShutter() {
        this.setOptions(Ascii.Option.NO_NET);
    }

    public void open(DriverConstants.ConnType connType, String serialName, int baud, int dataChar) throws DriverException {
        super.open(connType, serialName, baud, 0);
        this.init();
    }

    public void open(String device, int baud, int addr) throws DriverException {
        this.openSerial(device, baud);
        this.addrOffset = addr;
    }

    public void init() {
        this.setCommandTerm(Ascii.Terminator.CR);
    }

    public void reset() throws DriverException {
        this.writeOrielShutter("RST");
    }

    public String getIdent() throws DriverException {
        return this.readOrielShutter("IDN?");
    }

    public void openShutter() throws DriverException {
        this.writeOrielShutter(String.valueOf(64 + this.addrOffset));
    }

    public void closeShutter() throws DriverException {
        this.writeOrielShutter(String.valueOf(65 + this.addrOffset));
    }

    public synchronized void writeOrielShutter(String command) throws DriverException {
        this.write(command);
    }

    public synchronized String readOrielShutter() throws DriverException {
        return this.read();
    }

    public synchronized String readOrielShutter(String command) throws DriverException {
        this.writeOrielShutter(command);
        return this.readOrielShutter();
    }
}

