package org.lsst.ccs.drivers.orielshutter;

import org.lsst.ccs.command.annotations.Argument;
import org.lsst.ccs.command.annotations.Command;
import org.lsst.ccs.drivers.commons.DriverException;

/**
 * Program to test the Oriel Shutter device driver
 * 
 * @author Homer
 */
public class TestO76995 {

    private final OrielShutter mydev = new OrielShutter();
        
    @Command(name = "open", description = "Open a device for use")
    public void open(@Argument(name = "devId", description = "The device ID of the device to open") String MyDevId
                     ) throws DriverException {
        mydev.open(MyDevId, 9600, 0);
    }

    @Command(name="openftdi", description="Open FTDI connection to device")
    public String openftdi(@Argument(name="serialname", description="Serial device name") String host,
          @Argument(name="baud", description="baud") int baud,
          @Argument(name="addr", description="address offset (normally 0)") int addr
    ) throws DriverException
    {
        mydev.openftdi(host, baud, addr);
        return mydev.getIdent();
    }

    @Command(name = "close", description = "Close the device")
    public void close() throws Exception {
        mydev.close();
    }

    @Command(name = "openshutter", description = "Open shutter")
    public void openshutter() throws Exception {
        mydev.openShutter();
    }

    @Command(name = "closeshutter", description = "Close shutter")
    public void closeshutter() throws Exception {
        mydev.closeShutter();
    }

}
