package org.lsst.ccs.drivers.orielshutter;

import java.text.DecimalFormat;
import org.lsst.ccs.drivers.commons.DriverException;
import org.lsst.ccs.drivers.commons.DriverTimeoutException;
import org.lsst.ccs.drivers.ascii.Ascii;

/**
 **************************************************************************
 **
 ** General access routines for the Oriel Shutter device 
 ** @author Homer Neal
 * **************************************************************************
 */
public class OrielShutter extends Ascii {

    /**
     ** Public constants *
     **/

    public enum onOff {

        OFF, ON;
    }

    /**
     ** Private constants *
     */
    private final static byte CR = 0x0d, LF = 0x0a;
    private String terminator = "\r";
    private int timeout = 1000;
    private int addrOffset = 0;


    public OrielShutter() throws DriverException {
    }

    /**
     **
     ** Opens a connection. * * @param device The device name of the serial
     * port
     ** @param baud The baud rate
     ** @param dummy Dummy argument * * @throws DriverException *
     **/
    public void open(String serialname, int port, int addr) throws DriverException
    {
        init();
        addrOffset = addr;
        open(Ascii.CONN_TYPE_SERIAL, serialname, port);
    }

      /**
    **  Opens an FTDI connection.
    */
    public void openftdi(String serialname, int baud, int addr) throws DriverException
    {
        init();
        System.out.println("opening connection to the Oriel Shutter");
        addrOffset = addr;
        open(Ascii.CONN_TYPE_FTDI, serialname, baud);
    
    }

    /**
     **  Initializes device.
     **/
    public void init()
    {
       setTerminator(terminator);
    }    
    
    /**
     ** Closes the connection. * * @throws DriverException *
     **/
    public void close() throws DriverException {
        close();
    }

 
    /** reset to factory defaults **/
    public void reset() throws DriverException {
        writeOrielShutter("RST");
    }



     /** Gets the OrielShutter identity. **/
    public String getIdent() throws DriverException {
        return readOrielShutter("IDN?") ;
    }

    public void openShutter() throws DriverException {
         writeOrielShutter(String.valueOf(0x40+addrOffset));
    }

    public void closeShutter() throws DriverException {
         writeOrielShutter(String.valueOf(0x41+addrOffset));
    }
    /**
     ** Sets the receive timeout. * * @param timeout The receive timeout (ms).
     * 0 means no timeout. * * @throws DriverException *
     */
    public void setTimeout(int timeout) throws DriverException {
        this.timeout = timeout;
    }

     /**
     ** Writes a command. * * @param command The command to write, excluding
     * terminator * * @throws DriverException *
     **/
    public synchronized void writeOrielShutter(String command) throws DriverException {
       // write(command + terminator);
       write(command);
    }

    /**
     ** Reads a response. * * @return The command response string * * @throws
     * DriverException
     ** @throws DriverTimeoutException *
     */
    public synchronized String readOrielShutter() throws DriverException {
        return(read());
    }

    /**
     ** Reads a response after writing a command. * * @param command The
     * command to write, excluding terminator * * @return The command response
     * string * * @throws DriverException
     ** @throws DriverTimeoutException *
     */
    public synchronized String readOrielShutter(String command) throws DriverException {
        writeOrielShutter(command);
        return readOrielShutter();
    }

}
