/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.drivers.ftdi;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.ServerSocket;
import java.net.Socket;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.BlockingQueue;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.lsst.ccs.drivers.commons.DriverException;
import org.lsst.ccs.drivers.ftdi.FtdiLocal;
import org.lsst.ccs.utilities.conv.Convert;

public class FtdiServer
extends Thread {
    static final int SERVER_PORT = 9001;
    static final int MAGIC_NUMBER = 1910895516;
    static final int FUNC_EXCEPTION = 0;
    static final int FUNC_OPEN = 1;
    static final int FUNC_CLOSE = 2;
    static final int FUNC_READ = 3;
    static final int FUNC_WRITE = 4;
    static final int FUNC_TIMEOUTS = 5;
    static final int FUNC_BAUDRATE = 6;
    static final int FUNC_DATACHAR = 7;
    static final int FUNC_QUEUESTAT = 8;
    static final int FUNC_MODEMSTAT = 9;
    static final int FUNC_DTR = 10;
    static final int FUNC_RTS = 11;
    static final int FUNC_FLOWCTRL = 12;
    static final int FUNC_ENABEVENT = 13;
    static final int FUNC_WAITEVENT = 14;
    static final int POSN_MAGIC = 0;
    static final int POSN_LENGTH = 4;
    static final int POSN_FUNCTION = 6;
    static final int POSN_CONTEXT = 8;
    static final int POSN_DATA = 10;
    static final int POSN_EXCPTEXT = 10;
    static final int POSN_INDEX = 10;
    static final int POSN_SERIAL = 14;
    static final int POSN_READLENG = 10;
    static final int POSN_READDATA = 10;
    static final int POSN_WRITEDATA = 10;
    static final int POSN_WRITELENG = 10;
    static final int POSN_RCVETMO = 10;
    static final int POSN_XMITTMO = 14;
    static final int POSN_BAUDRATE = 10;
    static final int POSN_WORDLENG = 10;
    static final int POSN_STOPBITS = 14;
    static final int POSN_PARITY = 18;
    static final int POSN_QUEUESTAT = 10;
    static final int POSN_MODEMSTAT = 10;
    static final int POSN_DTRSET = 10;
    static final int POSN_RTSSET = 10;
    static final int POSN_FLOWCTRL = 10;
    static final int POSN_EVMASKSET = 10;
    static final int POSN_EVENTTMO = 10;
    static final int POSN_EVMASKRET = 10;
    private static final Logger log = Logger.getLogger("ftdiServer");
    private Socket cliSock;
    private final InputStream cliIn;
    private final OutputStream cliOut;
    private final FtdiLocal ftdi = new FtdiLocal();
    private final BlockingQueue<byte[]> readQ = new ArrayBlockingQueue<byte[]>(2);

    public FtdiServer(Socket sock) throws IOException {
        this.cliSock = sock;
        this.cliIn = sock.getInputStream();
        this.cliOut = sock.getOutputStream();
    }

    public static void main(String[] args) throws IOException {
        log.setLevel(Level.INFO);
        log.info("Started server");
        ServerSocket sSock = new ServerSocket(9001, 10);
        while (true) {
            Socket sock = sSock.accept();
            FtdiServer srvr = new FtdiServer(sock);
            srvr.setDaemon(true);
            srvr.start();
        }
    }

    @Override
    public void run() {
        String client = this.cliSock.getInetAddress().getHostName();
        int port = this.cliSock.getPort();
        log.info("Opened connection to " + client + ":" + port);
        Reader rdr = new Reader();
        rdr.setDaemon(true);
        rdr.start();
        IOException excp = null;
        boolean running = true;
        while (running) {
            byte[] rqst = null;
            try {
                rqst = this.receive();
                short rLeng = Convert.bytesToShort((byte[])rqst, (int)4);
                short func = Convert.bytesToShort((byte[])rqst, (int)6);
                switch (func) {
                    case 1: {
                        int index = Convert.bytesToInt((byte[])rqst, (int)10);
                        String serial = null;
                        if (rLeng > 14) {
                            serial = new String(rqst, 14, rLeng - 14);
                        }
                        this.ftdi.open(index, serial);
                        this.sendAck(rqst);
                        break;
                    }
                    case 2: {
                        this.ftdi.close();
                        this.closeNet();
                        running = false;
                        break;
                    }
                    case 3: {
                        this.readQ.offer(rqst);
                        break;
                    }
                    case 4: {
                        int nwrite = this.ftdi.write(rqst, 10, rLeng - 10);
                        byte[] reply = new byte[14];
                        Convert.intToBytes((int)nwrite, (byte[])reply, (int)10);
                        this.send(rqst, reply);
                        break;
                    }
                    case 5: {
                        int rcveTmo = Convert.bytesToInt((byte[])rqst, (int)10);
                        int xmitTmo = Convert.bytesToInt((byte[])rqst, (int)14);
                        this.ftdi.setTimeouts(rcveTmo, xmitTmo);
                        this.sendAck(rqst);
                        break;
                    }
                    case 6: {
                        int baudrate = Convert.bytesToInt((byte[])rqst, (int)10);
                        this.ftdi.setBaudrate(baudrate);
                        this.sendAck(rqst);
                        break;
                    }
                    case 7: {
                        int wordleng = Convert.bytesToInt((byte[])rqst, (int)10);
                        int stopbits = Convert.bytesToInt((byte[])rqst, (int)14);
                        int parity = Convert.bytesToInt((byte[])rqst, (int)18);
                        this.ftdi.setDataCharacteristics(wordleng, stopbits, parity);
                        this.sendAck(rqst);
                        break;
                    }
                    case 12: {
                        int flow = Convert.bytesToInt((byte[])rqst, (int)10);
                        this.ftdi.setFlowControl(flow);
                        this.sendAck(rqst);
                        break;
                    }
                    case 8: {
                        byte[] reply = new byte[14];
                        Convert.intToBytes((int)this.ftdi.getQueueStatus(), (byte[])reply, (int)10);
                        this.send(rqst, reply);
                        break;
                    }
                    case 9: {
                        byte[] reply = new byte[14];
                        Convert.intToBytes((int)this.ftdi.getModemStatus(), (byte[])reply, (int)10);
                        this.send(rqst, reply);
                        break;
                    }
                    case 10: {
                        this.ftdi.setDtr(rqst[10] != 0);
                        this.sendAck(rqst);
                        break;
                    }
                    case 11: {
                        this.ftdi.setRts(rqst[10] != 0);
                        this.sendAck(rqst);
                        break;
                    }
                    case 13: {
                        int mask = Convert.bytesToInt((byte[])rqst, (int)10);
                        this.ftdi.enableEvents(mask);
                        this.sendAck(rqst);
                        break;
                    }
                    case 14: {
                        int timeout = Convert.bytesToInt((byte[])rqst, (int)10);
                        byte[] reply = new byte[14];
                        Convert.intToBytes((int)this.ftdi.awaitEvent(timeout), (byte[])reply, (int)10);
                        this.send(rqst, reply);
                    }
                }
            }
            catch (DriverException ed) {
                try {
                    this.sendException(rqst, (Exception)((Object)ed));
                }
                catch (IOException ei) {
                    excp = ei;
                    running = false;
                }
            }
            catch (IOException ei) {
                excp = ei;
                running = false;
            }
        }
        if (excp != null) {
            if (this.closeNetSilent()) {
                log.warning(excp.toString());
            }
            try {
                this.ftdi.close();
            }
            catch (DriverException driverException) {}
        }
        rdr.interrupt();
        log.info("Closed connection to " + client + ":" + port);
    }

    private byte[] receive() throws IOException {
        byte[] header = new byte[10];
        int leng = 0;
        int recLeng = header.length;
        while (leng < recLeng) {
            int nread = this.cliIn.read(header, leng, recLeng - leng);
            if (nread < 0) break;
            leng += nread;
        }
        if (leng < recLeng) {
            throw new IOException("Client disconnected");
        }
        if (Convert.bytesToInt((byte[])header, (int)0) != 1910895516) {
            throw new IOException("Invalid magic number");
        }
        recLeng = Convert.bytesToShort((byte[])header, (int)4);
        byte[] rqst = new byte[recLeng];
        System.arraycopy(header, 0, rqst, 0, leng);
        while (leng < recLeng) {
            int nread = this.cliIn.read(rqst, leng, recLeng - leng);
            if (nread < 0) break;
            leng += nread;
        }
        if (leng < recLeng) {
            throw new IOException("Client disconnected");
        }
        return rqst;
    }

    private void send(byte[] rqst, byte[] reply) throws IOException {
        Convert.intToBytes((int)1910895516, (byte[])reply, (int)0);
        Convert.shortToBytes((short)((short)reply.length), (byte[])reply, (int)4);
        System.arraycopy(rqst, 6, reply, 6, 2);
        System.arraycopy(rqst, 8, reply, 8, 2);
        this.cliOut.write(reply);
    }

    private void sendAck(byte[] rqst) throws IOException {
        byte[] reply = new byte[10];
        this.send(rqst, reply);
    }

    private void sendException(byte[] rqst, Exception e) throws IOException {
        if (rqst == null) {
            return;
        }
        byte[] text = e.getMessage().getBytes();
        byte[] reply = new byte[10 + text.length];
        System.arraycopy(text, 0, reply, 10, text.length);
        Convert.shortToBytes((short)0, (byte[])rqst, (int)6);
        this.send(rqst, reply);
    }

    private boolean closeNetSilent() {
        boolean wasOpen = true;
        try {
            wasOpen = this.closeNet();
        }
        catch (IOException iOException) {}
        return wasOpen;
    }

    private boolean closeNet() throws IOException {
        boolean wasOpen = false;
        try {
            if (this.cliSock != null) {
                wasOpen = true;
                this.cliSock.close();
            }
        }
        finally {
            this.cliSock = null;
        }
        return wasOpen;
    }

    static /* synthetic */ BlockingQueue access$0(FtdiServer ftdiServer) {
        return ftdiServer.readQ;
    }

    static /* synthetic */ FtdiLocal access$1(FtdiServer ftdiServer) {
        return ftdiServer.ftdi;
    }

    static /* synthetic */ void access$2(FtdiServer ftdiServer, byte[] byArray, byte[] byArray2) throws IOException {
        ftdiServer.send(byArray, byArray2);
    }

    static /* synthetic */ void access$3(FtdiServer ftdiServer, byte[] byArray, Exception exception) throws IOException {
        ftdiServer.sendException(byArray, exception);
    }

    static /* synthetic */ boolean access$4(FtdiServer ftdiServer) {
        return ftdiServer.closeNetSilent();
    }

    static /* synthetic */ Logger access$5() {
        return log;
    }

    private class Reader
    extends Thread {
        private Reader() {
        }

        /*
         * Unable to fully structure code
         */
        @Override
        public void run() {
            excp = null;
            while (true) lbl-1000:
            // 3 sources

            {
                try {
                    rqst = (byte[])FtdiServer.access$0(FtdiServer.this).take();
                }
                catch (InterruptedException v0) {
                    break;
                }
                try {
                    leng = Convert.bytesToInt((byte[])rqst, (int)10);
                    data = new byte[leng];
                    nread = FtdiServer.access$1(FtdiServer.this).read(data);
                    reply = new byte[10 + nread];
                    System.arraycopy(data, 0, reply, 10, nread);
                    FtdiServer.access$2(FtdiServer.this, rqst, reply);
                    continue;
                }
                catch (DriverException ef) {
                    try {
                        FtdiServer.access$3(FtdiServer.this, rqst, (Exception)ef);
                        continue;
                    }
                    catch (IOException ei) {
                        excp = ei;
                        break;
                    }
                }
                ** while (true)
                catch (IOException ei) {
                    excp = ei;
                }
                break;
            }
            if (excp != null) {
                if (FtdiServer.access$4(FtdiServer.this)) {
                    FtdiServer.access$5().warning(excp.toString());
                }
                try {
                    FtdiServer.access$1(FtdiServer.this).close();
                }
                catch (DriverException v1) {}
            }
        }
    }
}

