/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.drivers.optidrive;

import org.lsst.ccs.drivers.modbus.Modbus;
import org.lsst.ccs.drivers.modbus.ModbusException;
import org.lsst.ccs.drivers.optidrive.OptidriveException;

public class Optidrive {
    public static final short CTRL_CONTROL_WORD = 1;
    public static final short CTRL_FREQUENCY_SETPOINT = 2;
    public static final short CTRL_MODBUS_RAMP_TIME = 4;
    public static final short STAT_ERROR_AND_STATUS = 6;
    public static final short STAT_OUTPUT_FREQUENCY = 7;
    public static final short STAT_MOTOR_CURRENT = 8;
    public static final short STAT_DIGITAL_INPUT_STATUS = 11;
    public static final short STAT_RATING_ID = 12;
    public static final short STAT_POWER_RATING = 13;
    public static final short STAT_VOLTAGE_RATING = 14;
    public static final short STAT_IO_SOFTWARE_VERSN = 15;
    public static final short STAT_MOTOR_SOFTWARE_VERSN = 16;
    public static final short STAT_DRIVE_TYPE = 17;
    public static final short STAT_ANALOG_INPUT_1 = 20;
    public static final short STAT_ANALOG_INPUT_2 = 21;
    public static final short STAT_SPEED_REFERENCE = 22;
    public static final short STAT_DC_BUS_VOLTAGE = 23;
    public static final short STAT_DRIVE_TEMPERATURE = 24;
    public static final short PARM_MAX_SPEED_LIMIT = 1;
    public static final short PARM_MIN_SPEED_LIMIT = 2;
    public static final short PARM_ACCEL_RAMP_TIME = 3;
    public static final short PARM_DECEL_RAMP_TIME = 4;
    public static final short PARM_STOP_MODE = 5;
    public static final short PARM_ENERGY_SAVE = 6;
    public static final short PARM_MOTOR_RATED_VOLTAGE = 7;
    public static final short PARM_MOTOR_RATED_CURRENT = 8;
    public static final short PARM_MOTOR_RATED_FREQ = 9;
    public static final short PARM_MOTOR_RATED_SPEED = 10;
    public static final short PARM_BOOST_VOLTAGE = 11;
    public static final short PARM_CONTROL_MODE = 12;
    public static final short PARM_TRIP_LOG = 13;
    public static final short PARM_ACCESS_CODE = 14;
    public static final short PARM_DIGITAL_INPUT_FUNC = 15;
    public static final short PARM_ANALOG_INPUT_FORMAT = 16;
    public static final short PARM_EFF_SWITCH_FREQ = 17;
    public static final short PARM_RELAY_OUTPUT_FUNC = 18;
    public static final short PARM_DIGITAL_OUTPUT_LIMIT = 19;
    public static final short PARM_PRESET_SPEED_1 = 20;
    public static final short PARM_PRESET_SPEED_2 = 21;
    public static final short PARM_PRESET_SPEED_3 = 22;
    public static final short PARM_PRESET_SPEED_4 = 23;
    public static final short PARM_SECOND_DECEL_RAMP = 24;
    public static final short PARM_ANALOG_OUTPUT_FUNC = 25;
    public static final short PARM_SKIP_FREQUENCY = 26;
    public static final short PARM_SKIP_FREQENCY_BAND = 27;
    public static final short PARM_VF_ADJUST_VOLTAGE = 28;
    public static final short PARM_VF_ADJUST_FREQUENCY = 29;
    public static final short PARM_START_MODE = 30;
    public static final short PARM_KEYPAD_RESTART_MODE = 31;
    public static final short PARM_DC_INJECTION_ENABLE = 32;
    public static final short PARM_SPIN_START_ENABLE = 33;
    public static final short PARM_BRAKE_CIRCUIT_ENABLE = 34;
    public static final short PARM_ANALOG_INPUT_SCALING = 35;
    public static final short PARM_BAUDRATE_TRIP_TIME = 36;
    public static final short PARM_ACCESS_CODE_DEFN = 37;
    public static final short PARM_PARAMETER_LOCK = 38;
    public static final short PARM_ANALOG_INPUT_OFFSET = 39;
    public static final short PARM_DISPLAY_SCALE_FACTOR = 40;
    public static final short PARM_USER_PI_P_GAIN = 41;
    public static final short PARM_USER_PI_I_TIME_CONST = 42;
    public static final short PARM_USER_PI_MODE = 43;
    public static final short PARM_USER_PI_REFERENCE = 44;
    public static final short PARM_USER_PI_DIGITAL_REFC = 45;
    public static final short PARM_USER_PI_FEEDBACK = 46;
    public static final short PARM_SECOND_ANALOG_FORMAT = 47;
    private static final int MIN_CTRL_REG_NUMBER = 1;
    private static final int MAX_CTRL_REG_NUMBER = 4;
    private static final int MIN_STAT_REG_NUMBER = 6;
    private static final int MAX_STAT_REG_NUMBER = 24;
    private static final int MIN_PARM_NUMBER = 1;
    private static final int MAX_PARM_NUMBER = 47;
    private static final int PARM_BASE_REGISTER = 128;
    private Modbus mbus;
    private short busAddr;

    public Optidrive() {
        this.mbus = new Modbus();
    }

    public Optidrive(Optidrive od, int busAddr) {
        this.mbus = od.mbus;
        this.busAddr = (short)busAddr;
    }

    public void open(int index, String serial, int busAddr) throws OptidriveException {
        this.open(null, index, serial, busAddr);
    }

    public void open(String node, int index, String serial, int busAddr) throws OptidriveException {
        try {
            this.mbus.open(node, index, serial);
        }
        catch (ModbusException e) {
            throw new OptidriveException(e.getMessage());
        }
        this.busAddr = (short)busAddr;
    }

    public void close() throws OptidriveException {
        try {
            this.mbus.close();
        }
        catch (ModbusException e) {
            throw new OptidriveException(e.getMessage());
        }
    }

    public short readRegister(int nmbr) throws OptidriveException {
        try {
            return this.mbus.readRegisters(this.busAddr, (short)nmbr, (short)1)[0];
        }
        catch (ModbusException e) {
            throw new OptidriveException(e.getMessage());
        }
    }

    public short[] readRegisters(int nmbr, int count) throws OptidriveException {
        try {
            return this.mbus.readRegisters(this.busAddr, (short)nmbr, (short)count);
        }
        catch (ModbusException e) {
            throw new OptidriveException(e.getMessage());
        }
    }

    public void writeRegister(int nmbr, int value) throws OptidriveException {
        try {
            this.mbus.writeRegister(this.busAddr, (short)nmbr, (short)value);
        }
        catch (ModbusException e) {
            throw new OptidriveException(e.getMessage());
        }
    }

    public short getControl(int ctrl) throws OptidriveException {
        Optidrive.checkControlReg(ctrl);
        return this.readRegister(ctrl);
    }

    public short[] getControl(int ctrl, int count) throws OptidriveException {
        Optidrive.checkControlReg(ctrl, count);
        return this.readRegisters(ctrl, count);
    }

    public void setControl(int ctrl, int value) throws OptidriveException {
        Optidrive.checkControlReg(ctrl);
        this.writeRegister(ctrl, value);
    }

    public short getStatus(int stat) throws OptidriveException {
        Optidrive.checkStatusReg(stat);
        return this.readRegister(stat);
    }

    public short[] getStatus(int stat, int count) throws OptidriveException {
        Optidrive.checkStatusReg(stat, count);
        return this.readRegisters(stat, count);
    }

    public short getParameter(int parm) throws OptidriveException {
        Optidrive.checkParameter(parm);
        return this.readRegister(128 + parm);
    }

    public short[] getParameters(int parm, int count) throws OptidriveException {
        Optidrive.checkParameter(parm, count);
        return this.readRegisters(128 + parm, count);
    }

    public void setParameter(int parm, int value) throws OptidriveException {
        Optidrive.checkParameter(parm);
        this.writeRegister(128 + parm, value);
    }

    private static void checkControlReg(int ctrl) throws OptidriveException {
        if (ctrl < 1 || ctrl > 4) {
            throw new OptidriveException("Invalid control register number");
        }
    }

    private static void checkControlReg(int ctrl, int count) throws OptidriveException {
        if (ctrl < 1 || count < 1 || ctrl + count - 1 > 4) {
            throw new OptidriveException("Invalid control register number");
        }
    }

    private static void checkStatusReg(int stat) throws OptidriveException {
        if (stat < 6 || stat > 24) {
            throw new OptidriveException("Invalid status register number");
        }
    }

    private static void checkStatusReg(int stat, int count) throws OptidriveException {
        if (stat < 6 || count < 1 || stat + count - 1 > 24) {
            throw new OptidriveException("Invalid status register number");
        }
    }

    private static void checkParameter(int parm) throws OptidriveException {
        if (parm < 1 || parm > 47) {
            throw new OptidriveException("Invalid parameter number");
        }
    }

    private static void checkParameter(int parm, int count) throws OptidriveException {
        if (parm < 1 || count < 1 || parm + count - 1 > 47) {
            throw new OptidriveException("Invalid parameter number");
        }
    }
}

