/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.shell;

import java.lang.annotation.Annotation;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import org.lsst.ccs.shell.CLIException;
import org.lsst.ccs.shell.Param;
import org.lsst.ccs.shell.ShellCommand;
import org.lsst.ccs.shell.ShellCommandParamSpec;

public class LocalShellCommand
extends ShellCommand {
    private Method method;
    private Object handler;

    public LocalShellCommand(Object handler, Method method, String prefix, String name) {
        super(prefix, name);
        assert (method != null);
        this.setParamSpecs(LocalShellCommand.forMethod(method));
        assert (this.getParamSpecs().length == method.getParameterTypes().length);
        this.method = method;
        this.handler = handler;
        this.setDescription(LocalShellCommand.makeCommandDescription(method, this.getParamSpecs()));
    }

    private static ShellCommandParamSpec[] forMethod(Method theMethod) {
        Class<?>[] paramTypes = theMethod.getParameterTypes();
        ShellCommandParamSpec[] result = new ShellCommandParamSpec[theMethod.getParameterTypes().length];
        Annotation[][] annotations = theMethod.getParameterAnnotations();
        assert (annotations.length == result.length);
        int i = 0;
        while (i < result.length) {
            Param paramAnnotation = null;
            Annotation[] annotationArray = annotations[i];
            int n = annotationArray.length;
            int n2 = 0;
            while (n2 < n) {
                Annotation a = annotationArray[n2];
                if (a instanceof Param) {
                    paramAnnotation = (Param)a;
                    break;
                }
                ++n2;
            }
            if (paramAnnotation != null) {
                assert (!paramAnnotation.name().isEmpty()) : "@Param.name mustn't be empty";
                result[i] = new ShellCommandParamSpec(paramAnnotation.name(), paramTypes[i], paramAnnotation.description(), i);
            } else {
                result[i] = new ShellCommandParamSpec(String.format("p%d", i + 1), paramTypes[i], "", i);
            }
            ++i;
        }
        return result;
    }

    private static String makeCommandDescription(Method method, ShellCommandParamSpec[] paramSpecs) {
        StringBuilder result = new StringBuilder();
        result.append(method.getName());
        result.append('(');
        Class<?>[] paramTypes = method.getParameterTypes();
        assert (paramTypes.length == paramSpecs.length);
        boolean first = true;
        int i = 0;
        while (i < paramTypes.length) {
            if (!first) {
                result.append(", ");
            }
            first = false;
            if (paramSpecs[i] != null) {
                result.append(paramSpecs[i].getName());
                result.append(":");
                result.append(paramTypes[i].getSimpleName());
            } else {
                result.append(paramTypes[i].getSimpleName());
            }
            ++i;
        }
        result.append(") : ");
        result.append(method.getReturnType().getSimpleName());
        return result.toString();
    }

    @Override
    public Object invoke(Object[] parameters) throws CLIException {
        assert (this.method != null);
        try {
            Object result = this.method.invoke(this.handler, parameters);
            return result;
        }
        catch (InvocationTargetException ite) {
            return ite.getCause();
        }
        catch (Exception ex) {
            throw new CLIException(ex);
        }
    }
}

