/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.drivers.modbus;

import java.io.PrintStream;
import java.util.concurrent.ArrayBlockingQueue;
import org.lsst.ccs.drivers.ftdi.Ftdi;
import org.lsst.ccs.drivers.ftdi.FtdiException;
import org.lsst.ccs.drivers.modbus.CRC16;
import org.lsst.ccs.drivers.modbus.ModbusException;
import org.lsst.ccs.utilities.conv.Convert;

public class ModbusSlave {
    private static final int NUM_COILS = 96;
    private static final int NUM_DISCRETES = 16;
    private static final int NUM_REGISTERS = 200;
    private static final int NUM_INPUTS = 10;
    private static final int PACKET_TIMEOUT = 50;
    private static final PrintStream out = System.out;
    private final Reader reader = new Reader();
    private final Thread readMb = new Thread(this.reader);
    private Ftdi ftd = new Ftdi();
    private ArrayBlockingQueue replyQ = new ArrayBlockingQueue(1);
    private int busAddr;
    private byte[] coil = new byte[12];
    private byte[] discrete = new byte[2];
    private short[] register = new short[200];
    private short[] input = new short[10];

    public ModbusSlave(int index, String serial, String node) throws ModbusException {
        int j = 0;
        while (j < this.coil.length) {
            this.coil[j] = -86;
            ++j;
        }
        j = 0;
        while (j < this.discrete.length) {
            this.discrete[j] = 85;
            ++j;
        }
        j = 0;
        while (j < this.register.length) {
            this.register[j] = j;
            j = (short)(j + 1);
        }
        j = 0;
        while (j < this.input.length) {
            this.input[j] = j;
            j = (short)(j + 1);
        }
        try {
            this.ftd.open(node, index, serial);
            this.ftd.setBaudrate(115200);
            this.ftd.setDataCharacteristics(8, 0, 0);
        }
        catch (FtdiException e) {
            throw new ModbusException(e.getMessage());
        }
        this.readMb.setDaemon(true);
        this.readMb.start();
    }

    public static void main(String[] args) throws ModbusException {
        int index = 0;
        if (args.length >= 1) {
            try {
                index = Integer.decode(args[0]);
            }
            catch (NumberFormatException numberFormatException) {
                out.println("Invalid device index");
                System.exit(0);
            }
        }
        String serial = null;
        if (args.length >= 2) {
            serial = args[1];
        }
        int addr = 1;
        if (args.length >= 3) {
            try {
                addr = Integer.decode(args[2]);
            }
            catch (NumberFormatException numberFormatException) {
                out.println("Invalid Modbus address");
                System.exit(0);
            }
        }
        String node = null;
        if (args.length >= 4) {
            node = args[3];
        }
        ModbusSlave slave = new ModbusSlave(index, serial, node);
        slave.setAddress(addr);
        out.println("Slave started");
        int nexcptn = 0;
        while (true) {
            try {
                while (true) {
                    slave.receive();
                    nexcptn = 0;
                }
            }
            catch (ModbusException e) {
                out.println(e);
                if (++nexcptn < 5) continue;
                out.println("Exiting: exception loop");
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            break;
        }
        System.exit(0);
    }

    public void setAddress(int addr) {
        this.busAddr = addr;
    }

    public void receive() throws ModbusException {
        this.checkOpen();
        byte[] cmnd = null;
        while (cmnd == null) {
            try {
                cmnd = (byte[])this.replyQ.take();
            }
            catch (InterruptedException interruptedException) {}
        }
        int addr = cmnd[0] & 0xFF;
        int func = cmnd.length >= 2 ? cmnd[1] & 0xFF : 0;
        out.format("Received command: leng = %s, addr = %s, func = %s\n", cmnd.length, addr, func);
        if (CRC16.generateStd(cmnd) != 0) {
            out.println("Command checksum error");
            return;
        }
        if (addr != this.busAddr) {
            return;
        }
        switch (func) {
            case 1: {
                this.readCoils(cmnd);
                break;
            }
            case 2: {
                this.readDiscretes(cmnd);
                break;
            }
            case 3: {
                this.readRegisters(cmnd);
                break;
            }
            case 4: {
                this.readInputs(cmnd);
                break;
            }
            case 5: {
                this.writeCoil(cmnd);
                break;
            }
            case 6: {
                this.writeRegister(cmnd);
                break;
            }
            case 15: {
                this.writeCoils(cmnd);
                break;
            }
            case 16: {
                this.writeRegisters(cmnd);
                break;
            }
            default: {
                this.sendExceptionResp(cmnd, 1);
            }
        }
    }

    private void readCoils(byte[] cmnd) throws ModbusException {
        int count;
        int addr = ModbusSlave.getAddress(cmnd);
        if (addr + (count = ModbusSlave.getCount(cmnd)) > 96) {
            this.sendExceptionResp(cmnd, 2);
            return;
        }
        int nbyte = (count + 7) / 8;
        byte[] resp = this.createReadResp(cmnd, nbyte);
        int j = 0;
        while (j < nbyte) {
            resp[j + 3] = 0;
            ++j;
        }
        j = 0;
        while (j < count) {
            if ((this.coil[addr >> 3] & 1 << (addr & 7)) != 0) {
                int n = (j >> 3) + 3;
                resp[n] = (byte)(resp[n] | 1 << (j & 7));
            }
            ++j;
            ++addr;
        }
        this.send(resp);
    }

    private void readDiscretes(byte[] cmnd) throws ModbusException {
        int count;
        int addr = ModbusSlave.getAddress(cmnd);
        if (addr + (count = ModbusSlave.getCount(cmnd)) > 16) {
            this.sendExceptionResp(cmnd, 2);
            return;
        }
        int nbyte = (count + 7) / 8;
        byte[] resp = this.createReadResp(cmnd, nbyte);
        int j = 0;
        while (j < nbyte) {
            resp[j + 3] = 0;
            ++j;
        }
        j = 0;
        while (j < count) {
            if ((this.discrete[addr >> 3] & 1 << (addr & 7)) != 0) {
                int n = (j >> 3) + 3;
                resp[n] = (byte)(resp[n] | 1 << (j & 7));
            }
            ++j;
            ++addr;
        }
        this.send(resp);
    }

    private void readRegisters(byte[] cmnd) throws ModbusException {
        int count;
        int addr = ModbusSlave.getAddress(cmnd);
        if (addr + (count = ModbusSlave.getCount(cmnd)) > 200) {
            this.sendExceptionResp(cmnd, 2);
            return;
        }
        byte[] resp = this.createReadResp(cmnd, 2 * count);
        int j = 0;
        while (j < count) {
            Convert.shortToBytesBE((short)this.register[addr], (byte[])resp, (int)(2 * j + 3));
            ++j;
            ++addr;
        }
        this.send(resp);
    }

    private void readInputs(byte[] cmnd) throws ModbusException {
        int count;
        int addr = ModbusSlave.getAddress(cmnd);
        if (addr + (count = ModbusSlave.getCount(cmnd)) > 10) {
            this.sendExceptionResp(cmnd, 2);
            return;
        }
        byte[] resp = this.createReadResp(cmnd, 2 * count);
        int j = 0;
        while (j < count) {
            Convert.shortToBytesBE((short)this.input[addr], (byte[])resp, (int)(2 * j + 3));
            ++j;
            ++addr;
        }
        this.send(resp);
    }

    private void writeCoil(byte[] cmnd) throws ModbusException {
        int addr = ModbusSlave.getAddress(cmnd);
        if (addr >= 96) {
            this.sendExceptionResp(cmnd, 2);
            return;
        }
        short value = Convert.bytesToShortBE((byte[])cmnd, (int)4);
        if ((value & 0xFFFF) == 65280) {
            int n = addr >> 3;
            this.coil[n] = (byte)(this.coil[n] | (byte)(1 << (addr & 7)));
        } else if (value == 0) {
            int n = addr >> 3;
            this.coil[n] = (byte)(this.coil[n] & (byte)(~(1 << (addr & 7))));
        }
        this.sendWriteResp(cmnd);
    }

    private void writeRegister(byte[] cmnd) throws ModbusException {
        int addr = ModbusSlave.getAddress(cmnd);
        if (addr >= 200) {
            this.sendExceptionResp(cmnd, 2);
            return;
        }
        this.register[addr] = Convert.bytesToShortBE((byte[])cmnd, (int)4);
        this.sendWriteResp(cmnd);
    }

    private void writeCoils(byte[] cmnd) throws ModbusException {
        int count;
        int addr = ModbusSlave.getAddress(cmnd);
        if (addr + (count = ModbusSlave.getCount(cmnd)) > 96) {
            this.sendExceptionResp(cmnd, 2);
            return;
        }
        int j = 0;
        while (j < count) {
            if ((cmnd[7 + (j >> 3)] & 1 << (j & 7)) != 0) {
                int n = addr >> 3;
                this.coil[n] = (byte)(this.coil[n] | (byte)(1 << (addr & 7)));
            } else {
                int n = addr >> 3;
                this.coil[n] = (byte)(this.coil[n] & (byte)(~(1 << (addr & 7))));
            }
            ++j;
            ++addr;
        }
        this.sendWriteResp(cmnd);
    }

    private void writeRegisters(byte[] cmnd) throws ModbusException {
        int count;
        int addr = ModbusSlave.getAddress(cmnd);
        if (addr + (count = ModbusSlave.getCount(cmnd)) > 200) {
            this.sendExceptionResp(cmnd, 2);
            return;
        }
        int j = 0;
        while (j < count) {
            this.register[addr] = Convert.bytesToShortBE((byte[])cmnd, (int)(2 * j + 7));
            ++j;
            ++addr;
        }
        this.sendWriteResp(cmnd);
    }

    private void sendWriteResp(byte[] cmnd) throws ModbusException {
        byte[] resp = new byte[8];
        System.arraycopy(cmnd, 0, resp, 0, 6);
        this.send(resp);
    }

    private void sendExceptionResp(byte[] cmnd, int code) throws ModbusException {
        out.println("Sending exception " + code);
        byte[] resp = new byte[5];
        resp[0] = cmnd[0];
        resp[1] = (byte)(cmnd[1] | 0x80);
        resp[2] = (byte)code;
        this.send(resp);
    }

    private void send(byte[] resp) throws ModbusException {
        this.checkOpen();
        int leng = resp.length;
        CRC16.generateStd(resp, 0, leng - 2, resp, leng - 2);
        try {
            this.ftd.write(resp);
        }
        catch (FtdiException e) {
            throw new ModbusException(e.getMessage());
        }
        out.println("Sent response: leng = " + leng);
    }

    private byte[] createReadResp(byte[] cmnd, int nbyte) {
        byte[] resp = new byte[nbyte + 5];
        resp[0] = cmnd[0];
        resp[1] = cmnd[1];
        resp[2] = (byte)nbyte;
        return resp;
    }

    private static int getAddress(byte[] cmnd) {
        return Convert.bytesToShortBE((byte[])cmnd, (int)2) & 0xFFFF;
    }

    private static int getCount(byte[] cmnd) {
        return Convert.bytesToShortBE((byte[])cmnd, (int)4) & 0xFFFF;
    }

    private void checkOpen() throws ModbusException {
        if (this.ftd == null) {
            throw new ModbusException("Port not open");
        }
    }

    private class Reader
    implements Runnable {
        private Reader() {
        }

        @Override
        public void run() {
            byte[] buff = new byte[256];
            try {
                while (true) {
                    int leng = 0;
                    ModbusSlave.this.ftd.setTimeouts(0, 0);
                    int nread = ModbusSlave.this.ftd.read(buff, 0, 1);
                    leng += nread;
                    ModbusSlave.this.ftd.setTimeouts(50, 0);
                    nread = ModbusSlave.this.ftd.read(buff, leng, buff.length - leng);
                    byte[] data = new byte[leng += nread];
                    System.arraycopy(buff, 0, data, 0, leng);
                    ModbusSlave.this.replyQ.offer(data);
                }
            }
            catch (FtdiException e) {
                System.out.println(new ModbusException(e.getMessage()));
                return;
            }
        }
    }
}

