/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.drivers.optidrive;

import java.io.PrintStream;
import jline.console.ConsoleReader;
import org.lsst.ccs.drivers.optidrive.Optidrive;
import org.lsst.ccs.drivers.optidrive.OptidriveException;
import org.lsst.ccs.utilities.sa.CmndProcess;

public class TestOptidrive
implements CmndProcess.Dispatch {
    private static final int CMD_OPEN = 0;
    private static final int CMD_CLOSE = 1;
    private static final int CMD_REGREAD = 2;
    private static final int CMD_REGWRITE = 3;
    private static final int CMD_SETCONTROL = 4;
    private static final int CMD_SHOWCONTROL = 5;
    private static final int CMD_SHOWSTATUS = 6;
    private static final int CMD_SETPARM = 7;
    private static final int CMD_SHOWPARM = 8;
    private static final int NUM_CMDS = 9;
    private static final String[] helpOpen = new String[]{"Open device connection", "open [<index>] [<serial>] [<addr>] [<node>]", "index   The index of the FTDI device to connect to (default 0)", "serial  The serial number of the FTDI device (default none)", "addr    The Modbus address of the drive (default 1)", "node    The node from which Modbus is being served (default local)"};
    private static final String[] helpClose = new String[]{"Close device connection", "close"};
    private static final String[] helpRegread = new String[]{"Reads and displays a set of holding registers", "regread <nmbr> [<count>]", "nmbr   The number of the first holding register to read", "count  The number of holding registers to read (default 1)"};
    private static final String[] helpRegwrite = new String[]{"Writes a holding register", "regwrite <nmbr> <value>", "nmbr    The number of the holding register to write", "value   The value to write"};
    private static final String[] helpSetcontrol = new String[]{"Sets the value of a control register", "setcontrol <ctrl> <value>", "ctrl   The number of the control register to set", "value  The value to set"};
    private static final String[] helpShowcontrol = new String[]{"Shows the values in a set of control registers", "showcontrol <ctrl> [<count>]", "ctrl   The number of the first control register to show", "count  The number of control registers to show (default 1)"};
    private static final String[] helpShowstatus = new String[]{"Shows the values in a set of status registers", "showstatus <stat> [<count>]", "stat   The number of the first status register to show", "count  The number of status registers to show (default 1)"};
    private static final String[] helpSetparm = new String[]{"Sets the value of a parameter", "setparm <parm> <value>", "parm   The number of the parameter to set", "value  The value to set"};
    private static final String[] helpShowparm = new String[]{"Shows the values of a set of parameters", "showparm <parm> [<count>]", "parm   The number of the first parameter to show", "count  The number of parameters to show (default 1)"};
    private static final CmndProcess.Command cmnd = new CmndProcess.Command(9);
    private static final PrintStream out;
    private final CmndProcess proc = new CmndProcess();
    private Optidrive opt = new Optidrive();
    private short busAddr;
    private boolean devOpen;

    static {
        cmnd.add("open", 0, helpOpen, "isws", new CmndProcess.Lookup[0]);
        cmnd.add("close", 1, helpClose, "", new CmndProcess.Lookup[0]);
        cmnd.add("regread", 2, helpRegread, "Ii", new CmndProcess.Lookup[0]);
        cmnd.add("regwrite", 3, helpRegwrite, "II", new CmndProcess.Lookup[0]);
        cmnd.add("setcontrol", 4, helpSetcontrol, "II", new CmndProcess.Lookup[0]);
        cmnd.add("showcontrol", 5, helpShowcontrol, "Ii", new CmndProcess.Lookup[0]);
        cmnd.add("showstatus", 6, helpShowstatus, "Ii", new CmndProcess.Lookup[0]);
        cmnd.add("setparm", 7, helpSetparm, "II", new CmndProcess.Lookup[0]);
        cmnd.add("showparm", 8, helpShowparm, "Ii", new CmndProcess.Lookup[0]);
        out = System.out;
    }

    public static void main(String[] args) {
        new TestOptidrive().run();
        System.exit(0);
    }

    public void run() {
        this.proc.add((CmndProcess.Dispatch)this, cmnd);
        try {
            String line;
            ConsoleReader reader = new ConsoleReader();
            while ((line = reader.readLine(">> ")) != null && this.proc.process(line)) {
            }
            if (this.devOpen) {
                this.opt.close();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public boolean dispatch(int code, int found, Object[] args) {
        try {
            switch (code) {
                case 0: {
                    this.procOpen(found, args);
                    break;
                }
                case 1: {
                    this.procClose(found, args);
                    break;
                }
                case 2: {
                    this.procRegread(found, args);
                    break;
                }
                case 3: {
                    this.procRegwrite(found, args);
                    break;
                }
                case 4: {
                    this.procSetcontrol(found, args);
                    break;
                }
                case 5: {
                    this.procShowcontrol(found, args);
                    break;
                }
                case 6: {
                    this.procShowstatus(found, args);
                    break;
                }
                case 7: {
                    this.procSetparm(found, args);
                    break;
                }
                case 8: {
                    this.procShowparm(found, args);
                    break;
                }
                default: {
                    out.println("Command not fully implemented");
                    break;
                }
            }
        }
        catch (OptidriveException e) {
            out.println(e);
        }
        return true;
    }

    private void procOpen(int found, Object[] args) throws OptidriveException {
        int index = (found & 1) != 0 ? (Integer)args[0] : 0;
        String serial = (found & 2) != 0 ? (String)args[1] : null;
        short addr = (found & 4) != 0 ? (Short)args[2] : (short)1;
        String node = (found & 8) != 0 ? (String)args[3] : null;
        this.opt.open(node, index, serial, addr);
        this.devOpen = true;
        this.busAddr = (found & 4) != 0 ? (Short)args[2] : (short)1;
    }

    private void procClose(int found, Object[] args) throws OptidriveException {
        this.devOpen = false;
        this.opt.close();
    }

    private void procRegread(int found, Object[] args) throws OptidriveException {
        int nmbr = (Integer)args[0];
        int count = (found & 2) != 0 ? (Integer)args[1] : 1;
        short[] reply = this.opt.readRegisters(nmbr, count);
        int j = 0;
        while (j < reply.length) {
            if (j % 10 == 0) {
                if (j != 0) {
                    out.println();
                }
                out.format("%3s:", nmbr + j);
            }
            out.format(" %04x", reply[j]);
            ++j;
        }
        out.println();
    }

    private void procRegwrite(int found, Object[] args) throws OptidriveException {
        this.opt.writeRegister((Integer)args[0], (Integer)args[1]);
    }

    private void procSetcontrol(int found, Object[] args) throws OptidriveException {
        this.opt.setControl((Integer)args[0], (Integer)args[1]);
    }

    private void procShowcontrol(int found, Object[] args) throws OptidriveException {
        int ctrl = (Integer)args[0];
        int count = (found & 2) != 0 ? (Integer)args[1] : 1;
        short[] reply = this.opt.getControl(ctrl, count);
        int j = 0;
        while (j < reply.length) {
            if (j % 10 == 0) {
                if (j != 0) {
                    out.println();
                }
                out.format("%2s:", ctrl + j);
            }
            out.format(" %04x", reply[j]);
            ++j;
        }
        out.println();
    }

    private void procShowstatus(int found, Object[] args) throws OptidriveException {
        int stat = (Integer)args[0];
        int count = (found & 2) != 0 ? (Integer)args[1] : 1;
        short[] reply = this.opt.getStatus(stat, count);
        int j = 0;
        while (j < reply.length) {
            if (j % 10 == 0) {
                if (j != 0) {
                    out.println();
                }
                out.format("%2s:", stat + j);
            }
            out.format(" %04x", reply[j]);
            ++j;
        }
        out.println();
    }

    private void procSetparm(int found, Object[] args) throws OptidriveException {
        this.opt.setParameter((Integer)args[0], (Integer)args[1]);
    }

    private void procShowparm(int found, Object[] args) throws OptidriveException {
        int parm = (Integer)args[0];
        int count = (found & 2) != 0 ? (Integer)args[1] : 1;
        short[] reply = this.opt.getParameters(parm, count);
        int j = 0;
        while (j < reply.length) {
            if (j % 10 == 0) {
                if (j != 0) {
                    out.println();
                }
                out.format("%2s:", parm + j);
            }
            out.format(" %04x", reply[j]);
            ++j;
        }
        out.println();
    }
}

