/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.drivers.ftdi;

import org.lsst.ccs.drivers.ftdi.FtdiClient;
import org.lsst.ccs.drivers.ftdi.FtdiException;
import org.lsst.ccs.drivers.ftdi.FtdiInterface;
import org.lsst.ccs.drivers.ftdi.FtdiLocal;

public class Ftdi
implements FtdiInterface {
    public static final int DATABITS_8 = 8;
    public static final int DATABITS_7 = 7;
    public static final int STOPBITS_1 = 0;
    public static final int STOPBITS_2 = 2;
    public static final int PARITY_NONE = 0;
    public static final int PARITY_ODD = 1;
    public static final int PARITY_EVEN = 2;
    public static final int PARITY_MARK = 3;
    public static final int PARITY_SPACE = 4;
    private FtdiClient client;
    private FtdiLocal local;
    private FtdiInterface ftdi;

    @Override
    public void open(int index, String serial) throws FtdiException {
        this.checkNotOpen();
        if (this.local == null) {
            this.local = new FtdiLocal();
        }
        this.local.open(index, serial);
        this.ftdi = this.local;
    }

    @Override
    public void open(String node, int index, String serial) throws FtdiException {
        if (node == null) {
            this.open(index, serial);
        } else {
            this.checkNotOpen();
            if (this.client == null) {
                this.client = new FtdiClient();
            }
            this.client.open(node, index, serial);
            this.ftdi = this.client;
        }
    }

    @Override
    public void close() throws FtdiException {
        this.checkOpen();
        try {
            this.ftdi.close();
        }
        finally {
            this.ftdi = null;
        }
    }

    @Override
    public void setBaudrate(int baudrate) throws FtdiException {
        this.checkOpen();
        this.ftdi.setBaudrate(baudrate);
    }

    @Override
    public void setDataCharacteristics(int wordLength, int stopBits, int parity) throws FtdiException {
        this.checkOpen();
        this.ftdi.setDataCharacteristics(wordLength, stopBits, parity);
    }

    @Override
    public void setTimeouts(int rcveTimeout, int xmitTimeout) throws FtdiException {
        this.checkOpen();
        this.ftdi.setTimeouts(rcveTimeout, xmitTimeout);
    }

    @Override
    public int read(byte[] data) throws FtdiException {
        this.checkOpen();
        return this.ftdi.read(data, 0, data.length);
    }

    @Override
    public int read(byte[] data, int offset, int count) throws FtdiException {
        this.checkOpen();
        return this.ftdi.read(data, offset, count);
    }

    @Override
    public int write(byte[] data) throws FtdiException {
        this.checkOpen();
        return this.ftdi.write(data, 0, data.length);
    }

    @Override
    public int write(byte[] data, int offset, int count) throws FtdiException {
        this.checkOpen();
        return this.ftdi.write(data, offset, count);
    }

    @Override
    public int getQueueStatus() throws FtdiException {
        this.checkOpen();
        return this.ftdi.getQueueStatus();
    }

    @Override
    public int getModemStatus() throws FtdiException {
        this.checkOpen();
        return this.ftdi.getModemStatus();
    }

    private void checkNotOpen() throws FtdiException {
        if (this.ftdi != null) {
            throw new FtdiException("Device already open");
        }
    }

    private void checkOpen() throws FtdiException {
        if (this.ftdi == null) {
            throw new FtdiException("Device not open");
        }
    }
}

