/*
 * Decompiled with CFR 0.152.
 */
package org.openscada.opc.lib.da;

import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Random;
import org.jinterop.dcom.common.JIException;
import org.openscada.opc.dcom.common.EventHandler;
import org.openscada.opc.dcom.common.KeyedResult;
import org.openscada.opc.dcom.common.KeyedResultSet;
import org.openscada.opc.dcom.common.Result;
import org.openscada.opc.dcom.common.ResultSet;
import org.openscada.opc.dcom.da.IOPCDataCallback;
import org.openscada.opc.dcom.da.OPCDATASOURCE;
import org.openscada.opc.dcom.da.OPCITEMDEF;
import org.openscada.opc.dcom.da.OPCITEMRESULT;
import org.openscada.opc.dcom.da.OPCITEMSTATE;
import org.openscada.opc.dcom.da.impl.OPCAsyncIO2;
import org.openscada.opc.dcom.da.impl.OPCGroupStateMgt;
import org.openscada.opc.dcom.da.impl.OPCItemMgt;
import org.openscada.opc.dcom.da.impl.OPCSyncIO;
import org.openscada.opc.lib.da.AddFailedException;
import org.openscada.opc.lib.da.Item;
import org.openscada.opc.lib.da.ItemState;
import org.openscada.opc.lib.da.Server;
import org.openscada.opc.lib.da.WriteRequest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Group {
    private static Logger _log = LoggerFactory.getLogger(Group.class);
    private static Random _random = new Random();
    private Server _server = null;
    private final int _serverHandle;
    private OPCGroupStateMgt _group = null;
    private OPCItemMgt _items = null;
    private OPCSyncIO _syncIO = null;
    private final Map<String, Integer> _itemHandleMap = new HashMap<String, Integer>();
    private final Map<Integer, Item> _itemMap = new HashMap<Integer, Item>();
    private final Map<Integer, Item> _itemClientMap = new HashMap<Integer, Item>();

    Group(Server server, int serverHandle, OPCGroupStateMgt group) throws IllegalArgumentException, UnknownHostException, JIException {
        _log.debug("Creating new group instance with COM group " + group);
        this._server = server;
        this._serverHandle = serverHandle;
        this._group = group;
        this._items = group.getItemManagement();
        this._syncIO = group.getSyncIO();
    }

    public void setActive(boolean state) throws JIException {
        this._group.setState(null, state, null, null, null, null);
    }

    public void remove() throws JIException {
        this._server.removeGroup(this, true);
    }

    public boolean isActive() throws JIException {
        return this._group.getState().isActive();
    }

    public String getName() throws JIException {
        return this._group.getState().getName();
    }

    public void setName(String name) throws JIException {
        this._group.setName(name);
    }

    public Item addItem(String item) throws JIException, AddFailedException {
        Map<String, Item> items = this.addItems(item);
        return items.get(item);
    }

    public synchronized Map<String, Result<OPCITEMRESULT>> validateItems(String ... items) throws JIException {
        OPCITEMDEF[] defs = new OPCITEMDEF[items.length];
        for (int i = 0; i < items.length; ++i) {
            defs[i] = new OPCITEMDEF();
            defs[i].setItemID(items[i]);
        }
        KeyedResultSet<OPCITEMDEF, OPCITEMRESULT> result = this._items.validate(defs);
        HashMap<String, Result<OPCITEMRESULT>> resultMap = new HashMap<String, Result<OPCITEMRESULT>>();
        for (KeyedResult keyedResult : result) {
            resultMap.put(((OPCITEMDEF)keyedResult.getKey()).getItemID(), new Result<OPCITEMRESULT>((OPCITEMRESULT)keyedResult.getValue(), keyedResult.getErrorCode()));
        }
        return resultMap;
    }

    public synchronized Map<String, Item> addItems(String ... items) throws JIException, AddFailedException {
        Map<String, Integer> handles = this.findItems(items);
        ArrayList<Integer> foundItems = new ArrayList<Integer>(items.length);
        ArrayList<String> missingItems = new ArrayList<String>();
        for (Map.Entry<String, Integer> entry : handles.entrySet()) {
            if (entry.getValue() == null) {
                missingItems.add(entry.getKey());
                continue;
            }
            foundItems.add(entry.getValue());
        }
        HashSet<Integer> newClientHandles = new HashSet<Integer>();
        OPCITEMDEF[] itemDef = new OPCITEMDEF[missingItems.size()];
        for (int i = 0; i < missingItems.size(); ++i) {
            Integer clientHandle;
            OPCITEMDEF def = new OPCITEMDEF();
            def.setItemID((String)missingItems.get(i));
            def.setActive(true);
            while (this._itemClientMap.containsKey(clientHandle = Integer.valueOf(_random.nextInt())) || newClientHandles.contains(clientHandle)) {
            }
            newClientHandles.add(clientHandle);
            def.setClientHandle(clientHandle);
            itemDef[i] = def;
        }
        HashMap<String, Integer> failedItems = new HashMap<String, Integer>();
        KeyedResultSet<OPCITEMDEF, OPCITEMRESULT> result = this._items.add(itemDef);
        int i = 0;
        for (KeyedResult keyedResult : result) {
            if (keyedResult.getErrorCode() == 0) {
                Item item = new Item(this, ((OPCITEMRESULT)keyedResult.getValue()).getServerHandle(), itemDef[i].getClientHandle(), ((OPCITEMDEF)keyedResult.getKey()).getItemID());
                this.addItem(item);
                foundItems.add(item.getServerHandle());
            } else {
                failedItems.put(((OPCITEMDEF)keyedResult.getKey()).getItemID(), keyedResult.getErrorCode());
            }
            ++i;
        }
        if (failedItems.size() != 0) {
            throw new AddFailedException(failedItems, this.findItems(foundItems));
        }
        return this.findItems(foundItems);
    }

    private synchronized void addItem(Item item) {
        _log.debug(String.format("Adding item: '%s', %d", item.getId(), item.getServerHandle()));
        this._itemHandleMap.put(item.getId(), item.getServerHandle());
        this._itemMap.put(item.getServerHandle(), item);
        this._itemClientMap.put(item.getClientHandle(), item);
    }

    private synchronized void removeItem(Item item) {
        this._itemHandleMap.remove(item.getId());
        this._itemMap.remove(item.getServerHandle());
        this._itemClientMap.remove(item.getClientHandle());
    }

    protected Item getItemByOPCItemId(String opcItemId) {
        Integer serverHandle = this._itemHandleMap.get(opcItemId);
        if (serverHandle == null) {
            _log.debug(String.format("Failed to locate item with id '%s'", opcItemId));
            return null;
        }
        _log.debug(String.format("Item '%s' has server id '%d'", opcItemId, serverHandle));
        return this._itemMap.get(serverHandle);
    }

    private synchronized Map<String, Integer> findItems(String[] items) {
        HashMap<String, Integer> data = new HashMap<String, Integer>();
        for (int i = 0; i < items.length; ++i) {
            data.put(items[i], this._itemHandleMap.get(items[i]));
        }
        return data;
    }

    private synchronized Map<String, Item> findItems(Collection<Integer> handles) {
        HashMap<String, Item> itemMap = new HashMap<String, Item>();
        for (Integer i : handles) {
            Item item = this._itemMap.get(i);
            if (item == null) continue;
            itemMap.put(item.getId(), item);
        }
        return itemMap;
    }

    protected void checkItems(Item[] items) {
        for (Item item : items) {
            if (item.getGroup() == this) continue;
            throw new IllegalArgumentException("Item does not belong to this group");
        }
    }

    public void setActive(boolean state, Item ... items) throws JIException {
        this.checkItems(items);
        Integer[] handles = new Integer[items.length];
        for (int i = 0; i < items.length; ++i) {
            handles[i] = items[i].getServerHandle();
        }
        this._items.setActiveState(state, handles);
    }

    protected Integer[] getServerHandles(Item[] items) {
        this.checkItems(items);
        Integer[] handles = new Integer[items.length];
        for (int i = 0; i < items.length; ++i) {
            handles[i] = items[i].getServerHandle();
        }
        return handles;
    }

    public synchronized Map<Item, Integer> write(WriteRequest ... requests) throws JIException {
        Item[] items = new Item[requests.length];
        for (int i = 0; i < requests.length; ++i) {
            items[i] = requests[i].getItem();
        }
        Integer[] handles = this.getServerHandles(items);
        org.openscada.opc.dcom.da.WriteRequest[] wr = new org.openscada.opc.dcom.da.WriteRequest[items.length];
        for (int i = 0; i < items.length; ++i) {
            wr[i] = new org.openscada.opc.dcom.da.WriteRequest(handles[i], requests[i].getValue());
        }
        ResultSet<org.openscada.opc.dcom.da.WriteRequest> resultSet = this._syncIO.write(wr);
        HashMap<Item, Integer> result = new HashMap<Item, Integer>();
        for (int i = 0; i < requests.length; ++i) {
            Result entry = (Result)resultSet.get(i);
            result.put(requests[i].getItem(), entry.getErrorCode());
        }
        return result;
    }

    public synchronized Map<Item, ItemState> read(boolean device, Item ... items) throws JIException {
        Integer[] handles = this.getServerHandles(items);
        KeyedResultSet<Integer, OPCITEMSTATE> states = this._syncIO.read(device ? OPCDATASOURCE.OPC_DS_DEVICE : OPCDATASOURCE.OPC_DS_CACHE, handles);
        HashMap<Item, ItemState> data = new HashMap<Item, ItemState>();
        for (KeyedResult keyedResult : states) {
            Item item = this._itemMap.get(keyedResult.getKey());
            ItemState state = new ItemState(keyedResult.getErrorCode(), ((OPCITEMSTATE)keyedResult.getValue()).getValue(), ((OPCITEMSTATE)keyedResult.getValue()).getTimestamp().asCalendar(), ((OPCITEMSTATE)keyedResult.getValue()).getQuality());
            data.put(item, state);
        }
        return data;
    }

    public Server getServer() {
        return this._server;
    }

    public synchronized void clear() throws JIException {
        Integer[] handles = this._itemMap.keySet().toArray(new Integer[0]);
        try {
            this._items.remove(handles);
        }
        finally {
            this._itemHandleMap.clear();
            this._itemMap.clear();
            this._itemClientMap.clear();
        }
    }

    public synchronized OPCAsyncIO2 getAsyncIO20() {
        return this._group.getAsyncIO2();
    }

    public synchronized EventHandler attach(IOPCDataCallback dataCallback) throws JIException {
        return this._group.attach(dataCallback);
    }

    public Item findItemByClientHandle(int clientHandle) {
        return this._itemClientMap.get(clientHandle);
    }

    public int getServerHandle() {
        return this._serverHandle;
    }

    public synchronized void removeItem(String opcItemId) throws IllegalArgumentException, UnknownHostException, JIException {
        _log.debug(String.format("Removing item '%s'", opcItemId));
        Item item = this.getItemByOPCItemId(opcItemId);
        if (item != null) {
            this._group.getItemManagement().remove(item.getServerHandle());
            this.removeItem(item);
            _log.debug(String.format("Removed item '%s'", opcItemId));
        } else {
            _log.warn(String.format("Unable to find item '%s'", opcItemId));
        }
    }
}

