package org.openscada.opc.lib.common;

/**
 * Enumerates the authentication/session protocols that may be used for a connection to a DCOM
 * service.
 * @author tether
 * <p>
 * The NTLM protocols are all obsolete and easily crackable by today's standards. Best to use them
 * only local account credentials rather than those for a domain-wide account.
 */
public enum ConnectionProtocol {
    
    /** The really, really old NTLM v1 used for authentication only. Many systems won't accept it any more. */
    NTLMV1_AUTHENTICATION,
    
    /** The slightly less old NTLM v2 used for authentication only. */
    NTLMV2_AUTHENTICATION,
    
    /** NTLM v2 authentication combined with encrypted & verified session packets. */
    NTLMV2_SESSION_SECURITY;
    
}
