/*
 * Decompiled with CFR 0.152.
 */
package org.jinterop.dcom.core;

import java.util.ArrayList;
import java.util.HashMap;
import ndr.NdrException;
import ndr.NdrObject;
import ndr.NetworkDataRepresentation;
import org.jinterop.dcom.common.JIRuntimeException;
import org.jinterop.dcom.common.JISystem;
import org.jinterop.dcom.core.JIInterfacePointer;
import org.jinterop.dcom.core.JIOrpcThat;
import org.jinterop.dcom.core.JIOrpcThis;
import rpc.core.UUID;

final class JIRemUnknown
extends NdrObject {
    public static final String IID_IUnknown = "00000143-0000-0000-c000-000000000046";
    private String ipidOfIUnknown = null;
    private String requestedIID = null;
    private JIInterfacePointer iidPtr = null;

    JIRemUnknown(String ipidOfIUnknown, String requestedIID) {
        this.ipidOfIUnknown = ipidOfIUnknown;
        this.requestedIID = requestedIID;
    }

    @Override
    public int getOpnum() {
        return 6;
    }

    @Override
    public void write(NetworkDataRepresentation ndr) {
        JIOrpcThis orpcthis = new JIOrpcThis();
        orpcthis.encode(ndr);
        UUID uuid = new UUID(this.ipidOfIUnknown);
        try {
            uuid.encode(ndr, ndr.buf);
        }
        catch (NdrException e) {
            JISystem.getLogger().throwing("JIRemUnknown", "write", e);
        }
        ndr.writeUnsignedShort(1);
        ndr.writeUnsignedShort(0);
        ndr.writeUnsignedLong(1);
        uuid = new UUID(this.requestedIID);
        try {
            uuid.encode(ndr, ndr.buf);
        }
        catch (NdrException e) {
            JISystem.getLogger().throwing("JIRemUnknown", "Performing a QueryInterface for " + this.requestedIID, e);
        }
        ndr.writeUnsignedLong(0);
    }

    @Override
    public void read(NetworkDataRepresentation ndr) {
        JIOrpcThat.decode(ndr);
        ndr.readUnsignedLong();
        int hresult1 = ndr.readUnsignedLong();
        if (hresult1 != 0) {
            throw new JIRuntimeException(hresult1);
        }
        ndr.readUnsignedLong();
        this.iidPtr = JIInterfacePointer.decode(ndr, new ArrayList(), 0, new HashMap());
        hresult1 = ndr.readUnsignedLong();
        if (hresult1 != 0) {
            throw new JIRuntimeException(hresult1);
        }
    }

    public JIInterfacePointer getInterfacePointer() {
        return this.iidPtr;
    }
}

