package org.lsst.ccs.drivers.opc;

import java.util.Optional;

/**
 * Contains the three basic OPC data quality indicators, derived from the upper two bits of the least
 * significant byte of the quality code.
 * @author tether
 */
public enum Quality {
    /** Known to be bad. */
    BAD,
    
    /** Possibly bad but can't tell for various reasons.  */
    UNCERTAIN,
    
    /** Known to be good. */
    GOOD,
    
    /** An illegal quality code was returned from the server. */
    ILLEGAL_QUALITY;
    
    /**
     * Determines the overall quality from the 16-bit raw OPC quality code.
     * @param qcode The raw quality code.
     * @return The quality enumerator.
     */
    public static Quality fromQualityCode(final int qcode) {
        final int bits = (qcode >> 6) & 3;
        Quality result = ILLEGAL_QUALITY;
        if (bits == 0) {result = BAD;}
        else if (bits == 1) {result = UNCERTAIN;}
        else if (bits == 3) {result = GOOD;}
        return result;
    }
}
