/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.drivers.opc;

import java.io.IOException;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import jline.console.ConsoleReader;
import org.lsst.ccs.command.annotations.Argument;
import org.lsst.ccs.command.annotations.Command;
import org.lsst.ccs.drivers.commons.DriverException;
import org.lsst.ccs.drivers.opc.OPCClient;
import org.lsst.ccs.drivers.opc.OPCItem;

public class OPCDriver {
    private final ConsoleReader console = new ConsoleReader();
    private Optional<OPCClient> client = Optional.empty();

    @Command(description="Creates an OPCClient object for a Windows OPC DA server, closing any existing connection.")
    public String open(@Argument(name="host", description="A host name or a dotted IPv4 address.") String host, @Argument(name="domain", description="The local Windows domain of the host.") String domain, @Argument(name="classID", description="The CLSID string of the OPC service.") String classID, @Argument(name="username", description="A user name known on the host. You'll be prompted for the password which won't echo.") String username) throws Exception {
        String response = "Done.";
        this.client.ifPresent(OPCClient::close);
        try {
            String password = this.console.readLine("Password? ", new Character('\u0000'));
            this.client = Optional.of(new OPCClient(host, domain, classID, username, password));
        }
        catch (Exception exc) {
            this.client = Optional.empty();
            throw exc;
        }
        return response;
    }

    @Command(description="Call client.close() if a client has been created using open().")
    public String close() {
        this.client.ifPresent(OPCClient::close);
        this.client = Optional.empty();
        return "Done.";
    }

    @Command(description="Calls client.setGroup() if the client exists.")
    public String setGroup(String ... itemNames) throws DriverException {
        String response = "Done.";
        if (this.client.isPresent()) {
            List<String> names = Arrays.asList(itemNames);
            this.client = Optional.of(this.client.get().setGroup(names));
        } else {
            response = "Use open() to create a client.";
        }
        return response;
    }

    @Command(description="Calls client.readGroup(true) if a client exists.")
    public String readGroup() throws Throwable {
        String response = "Done.";
        if (this.client.isPresent()) {
            this.client = Optional.of(this.client.get().readGroup(true));
            Optional<Throwable> exc = this.client.get().getException();
            if (exc.isPresent()) {
                throw exc.get();
            }
        } else {
            response = "Use open() to create a client.";
        }
        return response;
    }

    @Command(description="Calls client.getData() if a client exists.")
    public String getData() {
        String response = "Use open() to create a client.";
        if (this.client.isPresent()) {
            List<OPCItem> items = this.client.get().getData();
            if (items.isEmpty()) {
                response = "No data. Have you called setGroup() and readGroup()?";
            } else {
                StringBuilder buf = new StringBuilder();
                items.stream().forEachOrdered(itm -> {
                    buf.append("\ntag:       ");
                    buf.append(itm.getTag());
                    buf.append("\ntime:      ");
                    buf.append(itm.getTimestamp());
                    buf.append("\nbase type: ");
                    buf.append((Object)itm.getType());
                    buf.append("\narray?:    ");
                    buf.append(itm.isArray());
                    buf.append("\nvalue:     ");
                    buf.append(itm.getValue().toString());
                    buf.append("\nquality:   ");
                    buf.append((Object)itm.getQuality());
                    buf.append("\nmodifier:  ");
                    buf.append(itm.getModifier());
                    buf.append("\n");
                });
                response = buf.toString();
            }
        }
        return response;
    }

    @Command(description="Calls client.isOpen() if the client exists.")
    public String isOpen() {
        String response = "Use open() to create a client.";
        if (this.client.isPresent()) {
            response = "" + this.client.get().isOpen();
        }
        return response;
    }
}

