/*
 * Decompiled with CFR 0.152.
 */
package org.openscada.opc.lib.da;

import java.net.UnknownHostException;
import org.jinterop.dcom.common.JIException;
import org.openscada.opc.dcom.common.EventHandler;
import org.openscada.opc.dcom.common.KeyedResult;
import org.openscada.opc.dcom.common.KeyedResultSet;
import org.openscada.opc.dcom.common.ResultSet;
import org.openscada.opc.dcom.da.IOPCDataCallback;
import org.openscada.opc.dcom.da.OPCDATASOURCE;
import org.openscada.opc.dcom.da.ValueData;
import org.openscada.opc.dcom.da.impl.OPCAsyncIO2;
import org.openscada.opc.lib.common.NotConnectedException;
import org.openscada.opc.lib.da.AccessBase;
import org.openscada.opc.lib.da.DuplicateGroupException;
import org.openscada.opc.lib.da.Group;
import org.openscada.opc.lib.da.Item;
import org.openscada.opc.lib.da.ItemState;
import org.openscada.opc.lib.da.Server;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Async20Access
extends AccessBase
implements IOPCDataCallback {
    private static Logger logger = LoggerFactory.getLogger(Async20Access.class);
    private EventHandler eventHandler = null;
    private boolean initialRefresh = false;

    public Async20Access(Server server, int period, boolean initialRefresh) throws IllegalArgumentException, UnknownHostException, NotConnectedException, JIException, DuplicateGroupException {
        super(server, period);
        this.initialRefresh = initialRefresh;
    }

    public Async20Access(Server server, int period, boolean initialRefresh, String logTag) throws IllegalArgumentException, UnknownHostException, NotConnectedException, JIException, DuplicateGroupException {
        super(server, period, logTag);
        this.initialRefresh = initialRefresh;
    }

    @Override
    protected synchronized void start() throws JIException, IllegalArgumentException, UnknownHostException, NotConnectedException, DuplicateGroupException {
        if (this.isActive()) {
            return;
        }
        super.start();
        this.eventHandler = this.group.attach(this);
        if (!this.items.isEmpty() && this.initialRefresh) {
            OPCAsyncIO2 async20 = this.group.getAsyncIO20();
            if (async20 == null) {
                throw new NotConnectedException();
            }
            this.group.getAsyncIO20().refresh(OPCDATASOURCE.OPC_DS_CACHE, 0);
        }
    }

    @Override
    protected synchronized void stop() throws JIException {
        if (!this.isActive()) {
            return;
        }
        if (this.eventHandler != null) {
            try {
                this.eventHandler.detach();
            }
            catch (Throwable e) {
                logger.warn("Failed to detach group", e);
            }
            this.eventHandler = null;
        }
        super.stop();
    }

    @Override
    public void cancelComplete(int transactionId, int serverGroupHandle) {
    }

    @Override
    public void dataChange(int transactionId, int serverGroupHandle, int masterQuality, int masterErrorCode, KeyedResultSet<Integer, ValueData> result) {
        logger.debug("dataChange - transId {}, items: {}", (Object)transactionId, (Object)result.size());
        Group group = this.group;
        if (group == null) {
            return;
        }
        for (KeyedResult keyedResult : result) {
            Item item = group.findItemByClientHandle((Integer)keyedResult.getKey());
            logger.debug("Update for '{}'", (Object)item.getId());
            this.updateItem(item, new ItemState(keyedResult.getErrorCode(), ((ValueData)keyedResult.getValue()).getValue(), ((ValueData)keyedResult.getValue()).getTimestamp(), ((ValueData)keyedResult.getValue()).getQuality()));
        }
    }

    @Override
    public void readComplete(int transactionId, int serverGroupHandle, int masterQuality, int masterErrorCode, KeyedResultSet<Integer, ValueData> result) {
        logger.debug("readComplete - transId {}", (Object)transactionId);
    }

    @Override
    public void writeComplete(int transactionId, int serverGroupHandle, int masterErrorCode, ResultSet<Integer> result) {
        logger.debug("writeComplete - transId {}", (Object)transactionId);
    }
}

