/*
 * To change this license header, choose License Headers in Project Properties.
 * To change this template file, choose Tools | Templates
 * and open the template in the editor.
 */
package org.lsst.ccs.drivers.opc;

import java.math.BigDecimal;
import java.time.Instant;
import java.util.Arrays;
import java.util.Date;
import java.util.stream.Collectors;
import org.jinterop.dcom.core.IJIUnsigned;
import org.jinterop.dcom.core.JIArray;
import org.jinterop.dcom.core.JICurrency;
import org.jinterop.dcom.core.JIString;
import org.lsst.ccs.drivers.commons.DriverException;

/**
 * Contains one data item read from the OPC DA server; the actual value plus metadata.
 * @author tether
 */
public class OPCItem {
    private final String tag;
    private final Object value;
    private final ScalarType type;
    private final boolean arrayFlag;
    private final Quality quality;
    private final String modifier;
    private final Instant timestamp;

    OPCItem(
            final String tag,
            final Object value,
            final ScalarType type,
            final boolean isArray,
            final Quality quality,
            final String modifier,
            final Instant timestamp
    )
    {
        this.tag = tag;
        this.value = value;
        this.type = type;
        this.arrayFlag = isArray;
        this.quality = quality;
        this.modifier = modifier;
        this.timestamp = timestamp;
    }

    /** Gets the name of the item on the server.
     *  @return The name.
     */
    public String getTag() {return tag;}

    /**
     * Returns the value as an Object which will be an instance
     * of one of a few standard Java classes, or an array of same.
     * <ul>
     * <li>Double for VT_R{8, 4}.</li>
     * <li>Long for VT_{I,UI}{1, 2, 4} and VT_ERROR.</li>
     * <li>BigDecimal for VT_CY.</li>
     * <li>String for VT_BSTR.</li>
     * <li>Boolean for VT_BOOL.</li>
     * <li>Instant for VT_DATE.</li>
     * <li>String for anything else.</li>
     * </ul>
     * @return The value.
     * @See ScalarType.
     */
    public Object getValue() {return value;}

    /**
     * Gets the server type of the item (if scalar) or the server type of the array elements.
     * @return The type.
     */
    public ScalarType getType() {return type;}

    /**
     * Determines if this item is an array.
     * @return true for arrays, false for scalars.
     */
    public boolean isArray() {return arrayFlag;}

    /**
     * Gets the basic quality of the item.
     * @return The quality.
     */
    public Quality getQuality() {return quality;}

    /**
     * Gets a string containing more detailed information about the item's quality.
     * @return The expanded quality string.
     */
    public String getModifier() {return modifier;}

    /**
     * Gets the time at which the item was updated by the server.
     * @return The timestamp.
     */
    public Instant getTimestamp() {return timestamp;}
}
