package org.lsst.ccs.drivers.newportlamp;

import org.lsst.ccs.command.annotations.Argument;
import org.lsst.ccs.command.annotations.Command;
import org.lsst.ccs.drivers.commons.DriverException;
import org.lsst.ccs.drivers.commons.DriverTimeoutException;

/**
 *************************************************************************** 
 ** 
 ** Program to test the NewportLamp device driver
 ** 
 ** @author Homer
 ** 
 *************************************************************************** 
 */
public class TestN69911 {

	protected NewportLamp mydev;       
        
    @Command(name = "open", description = "Open a device for use")
	public void open(
            @Argument(name="connType", description="type of connection NETWORK(0), FTDI(1), SERIAL(2)") int itype,
            @Argument(name = "devId", description = "The device ID of the device to open") String MyDevId
                ) throws DriverException {
		
    	    mydev = new NewportLamp();
			mydev.open(itype,MyDevId,9600);
    }

    @Command(name="openftdi", description="Open FTDI connection to device")
    public String openftdi(@Argument(name="serialname", description="FTDI id") String host,
          @Argument(name="baud", description="baud") int baud) throws DriverException
    {
    	mydev = new NewportLamp();
        mydev.openftdi(host, baud);
        return mydev.getIdent();
    }


    @Command(name = "close", description = "Close the device")
	public void close() throws Exception {
    	mydev.close();
	}

    @Command(name="getState", description = "Return On(true) or Off(false)")
    public boolean getState() throws Exception {
        return mydev.getState();
    }

    @Command(name = "readamps", description = "Read amps ")
	public double readamps(
                ) throws Exception {
    	    return mydev.getAmps();
	}
    @Command(name = "readwatts", description = "Read watts ")
	public double readwatts(
                ) throws Exception {
    	    return mydev.getWatts();
	}
    @Command(name = "readcurrentpreset", description = "Read Current Preset ")
	public double readcurrentpreset( ) throws Exception {
        return mydev.getCurrentPreset();
    }
    @Command(name = "setcurrentpreset", description = "set Current Preset ")
	public void setcurrentpreset(
        @Argument(name="current", description="current preset value") double a) throws Exception {
        mydev.setCurrentPreset(a);
    }
    @Command(name = "readcurrentlimit", description = "Read Current Limit ")
	public double readcurrentlimit( ) throws Exception {
        return mydev.getCurrentLim();
    }
    @Command(name = "setcurrentlimit", description = "set Current Limit ")
	public void setcurrentlimit(
        @Argument(name="current", description="current limit value") double a) throws Exception {
        mydev.setCurrentLim(a);
    }
    @Command(name = "readpowerpreset", description = "Read Power Preset ")
	public int readpowerpreset( ) throws Exception {
        return mydev.getPowerPreset();
    }
    @Command(name = "setpowerpreset", description = "set Power Preset ")
	public void setpowerpreset(
        @Argument(name="power", description="power preset value") int p) throws Exception {
        mydev.setPowerPreset(p);
    }
    @Command(name = "readpowerlimit", description = "Read Power Limit ")
	public int readpowerlim( ) throws Exception {
        return mydev.getPowerLim();
    }
    @Command(name = "setpowerlimit", description = "set Power Limit ")
	public void setpowerlimit(
        @Argument(name="power", description="power limit value") int p) throws Exception {
        mydev.setPowerLim(p);
    }

    @Command(name = "readident", description = "Read ident")
	public String readident(
                ) throws Exception {
    	    return mydev.getIdent();
	}

    @Command(name = "getstatus", description = "Read power state of lamp")
	public String getstatus(
                ) throws Exception {
            return mydev.getStatus();
	}
    @Command(name="getlampon", description = "Returns true if lamp on status bit is high")
    public boolean getlampon() throws Exception {
        return mydev.statusLampOn();
    }

    @Command(name="getpowermode", description = "Returns true if power mode status bit is on")
    public boolean getpowermode() throws Exception {
        return mydev.statusPowerMode();
    }
    @Command(name="getcurrentmode", description = "Returns true if current mode status bit is on")
    public boolean getcurrentmode() throws Exception {
        return mydev.statusCurrentMode();
    }

    @Command(name="geterror", description="Returns full error byte in HEX")
    public String geterror() throws Exception {
        return mydev.getError();
    }

    @Command(name="checkerrorcommand", description="Parses error string")
    public boolean checkerrorcommand(String err) throws Exception {
        return mydev.parseErrorCommand(err);
    }
    @Command(name="checkerrorcomplete", description="Parses error string")
    public boolean checkerrorcomplete(String err) throws Exception {
        return mydev.parseErrorOpComplete(err);
    }

    @Command(name = "setstate", description = "Set power state of lamp")
	public void setstate(
            @Argument(name = "state", description = "boolean state of device; true = ON") boolean on
                ) throws Exception {
    	    mydev.setState(on);
	}

}
