package org.lsst.ccs.drivers.newportlamp;

import org.lsst.ccs.command.annotations.Argument;
import org.lsst.ccs.command.annotations.Command;
import org.lsst.ccs.drivers.commons.DriverException;
import org.lsst.ccs.drivers.commons.DriverTimeoutException;

/**
 *************************************************************************** 
 ** 
 ** Program to test the NewportLamp device driver
 ** 
 ** @author Homer
 ** 
 *************************************************************************** 
 */
public class NewportLampTest {

	protected NewportLamp mydev;       
        
    @Command(name = "open", description = "Open a device for use")
	public void open(
            @Argument(name = "devId", description = "The device ID of the device to open") String MyDevId
                ) throws DriverException {
		
    	    mydev = new NewportLamp();
			mydev.open(MyDevId,19200,0);
    }

    @Command(name = "close", description = "Close the device")
	public void close() throws Exception {
    	mydev.close();
	}

    @Command(name = "readamps", description = "Read amps ")
	public double readamps(
                ) throws Exception {
    	    return mydev.getAmps();
	}

    @Command(name = "readident", description = "Read ident")
	public String readident(
                ) throws Exception {
    	    return mydev.getIdent();
	}

    @Command(name = "getstate", description = "Read power state of lamp")
	public boolean getstate(
                ) throws Exception {
            return mydev.getState();
	}

    @Command(name = "setstate", description = "Set power state of lamp")
	public void setstate(
            @Argument(name = "state", description = "boolean state of device; true = ON") boolean on
                ) throws Exception {
    	    mydev.setState(on);
	}

}