/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.drivers.newportlamp;

import org.lsst.ccs.drivers.ascii.Ascii;
import org.lsst.ccs.drivers.commons.DriverException;

public class NewportLamp
extends Ascii {
    private static final byte CR = 13;
    private static final byte LF = 10;
    private String terminator = "\r\n";
    private int timeout = 1000;
    private String saddr;

    public void open(String serialname, int port, int addr) throws DriverException {
        this.open(2, serialname, port);
        Integer iaddr = addr;
        this.saddr = iaddr.toString();
        this.init();
    }

    public void openftdi(String serialname, int port, int addr) throws DriverException {
        System.out.println("opening connection to the Newport Lamp");
        this.open(1, serialname, port);
        Integer iaddr = addr;
        this.saddr = iaddr.toString();
        this.init();
    }

    public void init() {
    }

    public void close() throws DriverException {
    }

    public void setState(boolean on) throws DriverException {
        if (on) {
            this.writeNewportLamp("START");
        } else {
            this.writeNewportLamp("STOP");
        }
    }

    public boolean getState() throws DriverException {
        Integer.decode(this.readNewportLamp("STB?")).intValue();
        return false;
    }

    public String getIdent() throws DriverException {
        return this.readNewportLamp("IDN?");
    }

    public double getAmps() throws DriverException {
        return Double.valueOf(this.readNewportLamp("AMPS?"));
    }

    public void setTimeout(int timeout) throws DriverException {
        this.timeout = timeout;
    }

    public synchronized void writeNewportLamp(String command) throws DriverException {
        this.write(String.valueOf(command) + this.terminator);
    }

    public synchronized String readNewportLamp() throws DriverException {
        return this.read();
    }

    public synchronized String readNewportLamp(String command) throws DriverException {
        this.writeNewportLamp(command);
        return this.readNewportLamp();
    }

    public static enum onOff {
        OFF,
        ON;

    }
}

