/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.drivers.ftdi;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.Socket;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.concurrent.ArrayBlockingQueue;
import org.lsst.ccs.drivers.commons.DriverException;
import org.lsst.ccs.drivers.ftdi.FtdiInterface;
import org.lsst.ccs.utilities.conv.Convert;

public class FtdiClient
implements FtdiInterface {
    private Socket srvSock;
    private InputStream srvIn;
    private OutputStream srvOut;
    private Map<Integer, ArrayBlockingQueue> queueMap = new HashMap<Integer, ArrayBlockingQueue>();
    private ThreadLocal<Integer> threadId;
    private ThreadLocal<ArrayBlockingQueue> threadQueue;
    private int currThreadId = 0;

    @Override
    public void open(int index, String serial) throws DriverException {
        throw new DriverException("Invalid local open call");
    }

    @Override
    public void open(String node, int index, String serial) throws DriverException {
        try {
            this.srvSock = new Socket(node, 9001);
            this.srvIn = this.srvSock.getInputStream();
            this.srvOut = this.srvSock.getOutputStream();
        }
        catch (IOException e) {
            throw new DriverException((Throwable)e);
        }
        this.queueMap.clear();
        this.threadId = new ThreadLocal();
        this.threadQueue = new ThreadLocal();
        Reader rdr = new Reader();
        rdr.setDaemon(true);
        rdr.start();
        byte[] bSerial = serial == null ? new byte[]{} : serial.getBytes();
        int lSerial = bSerial.length;
        byte[] rqst = new byte[14 + lSerial];
        Convert.intToBytes((int)index, (byte[])rqst, (int)10);
        System.arraycopy(bSerial, 0, rqst, 14, lSerial);
        try {
            this.send(1, rqst);
            this.receive();
        }
        catch (DriverException e) {
            this.closeNetSilent();
            throw e;
        }
    }

    @Override
    public void close() throws DriverException {
        byte[] rqst = new byte[10];
        this.send(2, rqst);
        this.closeNet();
    }

    @Override
    public void setBaudrate(int baudrate) throws DriverException {
        byte[] rqst = new byte[14];
        Convert.intToBytes((int)baudrate, (byte[])rqst, (int)10);
        this.send(6, rqst);
        this.receive();
    }

    @Override
    public void setDataCharacteristics(int wordLength, int stopBits, int parity) throws DriverException {
        byte[] rqst = new byte[22];
        Convert.intToBytes((int)wordLength, (byte[])rqst, (int)10);
        Convert.intToBytes((int)stopBits, (byte[])rqst, (int)14);
        Convert.intToBytes((int)parity, (byte[])rqst, (int)18);
        this.send(7, rqst);
        this.receive();
    }

    @Override
    public void setTimeouts(int rcveTimeout, int xmitTimeout) throws DriverException {
        byte[] rqst = new byte[18];
        Convert.intToBytes((int)rcveTimeout, (byte[])rqst, (int)10);
        Convert.intToBytes((int)xmitTimeout, (byte[])rqst, (int)14);
        this.send(5, rqst);
        this.receive();
    }

    @Override
    public int read(byte[] data) throws DriverException {
        return this.read(data, 0, data.length);
    }

    @Override
    public int read(byte[] data, int offset, int count) throws DriverException {
        byte[] rqst = new byte[14];
        Convert.intToBytes((int)count, (byte[])rqst, (int)10);
        this.send(3, rqst);
        byte[] reply = this.receive();
        int nread = reply.length - 10;
        System.arraycopy(reply, 10, data, offset, nread);
        return nread;
    }

    @Override
    public int write(byte[] data) throws DriverException {
        return this.write(data, 0, data.length);
    }

    @Override
    public int write(byte[] data, int offset, int count) throws DriverException {
        byte[] rqst = new byte[10 + count];
        System.arraycopy(data, offset, rqst, 10, count);
        this.send(4, rqst);
        return Convert.bytesToInt((byte[])this.receive(), (int)10);
    }

    @Override
    public int getQueueStatus() throws DriverException {
        byte[] rqst = new byte[10];
        this.send(8, rqst);
        return Convert.bytesToInt((byte[])this.receive(), (int)10);
    }

    @Override
    public int getModemStatus() throws DriverException {
        byte[] rqst = new byte[10];
        this.send(9, rqst);
        return Convert.bytesToInt((byte[])this.receive(), (int)10);
    }

    private void send(int function, byte[] rqst) throws DriverException {
        int context;
        Integer id = this.threadId.get();
        if (id == null) {
            context = this.currThreadId++;
            this.threadId.set(context);
            this.threadQueue.set(new ArrayBlockingQueue(1));
            this.queueMap.put(context, this.threadQueue.get());
        } else {
            context = id;
        }
        Convert.intToBytes((int)1910895516, (byte[])rqst, (int)0);
        Convert.shortToBytes((short)((short)rqst.length), (byte[])rqst, (int)4);
        Convert.shortToBytes((short)((short)function), (byte[])rqst, (int)6);
        Convert.shortToBytes((short)((short)context), (byte[])rqst, (int)8);
        try {
            this.srvOut.write(rqst);
        }
        catch (IOException e) {
            throw new DriverException((Throwable)e);
        }
    }

    private byte[] receive() throws DriverException {
        Object replyObj = null;
        try {
            replyObj = this.threadQueue.get().take();
        }
        catch (InterruptedException interruptedException) {}
        if (replyObj instanceof DriverException) {
            throw (DriverException)replyObj;
        }
        byte[] reply = replyObj;
        if (Convert.bytesToShort((byte[])reply, (int)6) == 0) {
            String text = new String(reply, 10, reply.length - 10);
            throw new DriverException(text);
        }
        return reply;
    }

    private boolean closeNetSilent() {
        boolean wasOpen = true;
        try {
            wasOpen = this.closeNet();
        }
        catch (DriverException driverException) {}
        return wasOpen;
    }

    private boolean closeNet() throws DriverException {
        boolean wasOpen = false;
        IOException ei = null;
        try {
            if (this.srvSock != null) {
                wasOpen = true;
                this.srvSock.close();
            }
        }
        catch (IOException e) {
            ei = e;
        }
        this.srvSock = null;
        if (ei != null) {
            throw new DriverException((Throwable)ei);
        }
        return wasOpen;
    }

    private class Reader
    extends Thread {
        private Reader() {
        }

        @Override
        public void run() {
            DriverException excp;
            block12: {
                excp = null;
                try {
                    while (true) {
                        byte[] header = new byte[10];
                        int leng = 0;
                        int recLeng = header.length;
                        while (leng < recLeng) {
                            int nread = FtdiClient.this.srvIn.read(header, leng, recLeng - leng);
                            if (nread < 0) break;
                            leng += nread;
                        }
                        if (leng < recLeng) {
                            throw new DriverException("Server disconnected");
                        }
                        if (Convert.bytesToInt((byte[])header, (int)0) != 1910895516) {
                            System.out.print("Header =");
                            int j = 0;
                            while (j < header.length) {
                                System.out.format(" %02x", header[j]);
                                ++j;
                            }
                            System.out.println();
                            throw new DriverException("Invalid magic number");
                        }
                        recLeng = Convert.bytesToShort((byte[])header, (int)4);
                        byte[] reply = new byte[recLeng];
                        System.arraycopy(header, 0, reply, 0, leng);
                        while (leng < recLeng) {
                            int nread = FtdiClient.this.srvIn.read(reply, leng, recLeng - leng);
                            if (nread < 0) break;
                            leng += nread;
                        }
                        if (leng < recLeng) {
                            throw new DriverException("Server disconnected");
                        }
                        short context = Convert.bytesToShort((byte[])reply, (int)8);
                        ((ArrayBlockingQueue)FtdiClient.this.queueMap.get(context)).offer(reply);
                    }
                }
                catch (DriverException e) {
                    excp = e;
                    FtdiClient.this.closeNetSilent();
                }
                catch (IOException e) {
                    if (!FtdiClient.this.closeNetSilent()) break block12;
                    excp = new DriverException((Throwable)e);
                }
            }
            if (excp != null) {
                Iterator queues = FtdiClient.this.queueMap.values().iterator();
                while (queues.hasNext()) {
                    ((ArrayBlockingQueue)queues.next()).offer(excp);
                }
            }
        }
    }
}

