package org.lsst.ccs.drivers.netbotz;

import org.lsst.ccs.command.annotations.Argument;
import org.lsst.ccs.command.annotations.Command;
import org.lsst.ccs.drivers.commons.DriverException;
import java.io.IOException;

/**
 *************************************************************************** 
 ** 
 **  Program to test the NetBotz device driver
 **
 **  @author Homer Neal
 ** 
 *************************************************************************** 
 */
public class TestNetbotz {


    private NetbotzDriver apcnb = new NetbotzDriver();

    public enum onOff {
        OFF, ON;
    }


   /**
    *************************************************************************** 
    ** 
    **  Constructor
    ** 
    *************************************************************************** 
    */
    public TestNetbotz()
    {
//        scpi = apcnb;
    }



   /**
    *************************************************************************** 
    ** 
    **  Opens connection to a device.
    ** 
    *************************************************************************** 
    */

    @Command(name="open", description="Open connection for NetBotz readings retrieval")
    public void open(@Argument(name="envirofile", description="environment file")
                     String envirofile
                     ) throws DriverException
    {
        apcnb.open(envirofile);
        return;
    }

   /**
    *************************************************************************** 
    ** 
    **  Get environment values
    ** 
    *************************************************************************** 
    */
    @Command(name = "getenviro", description = "read line of readings from the NetBotz environment log")
    public String getEnviro() throws DriverException
    {

        try {
            apcnb.GetEnviro();
        } catch (IOException e) {
                System.out.println("Failed to retrieve environment readings " + e);
        }
        
        return 
                "Humidity = " + Double.toString(apcnb.getHumidity()) +
                ", Temperature = " + Double.toString(apcnb.getTemperature()) +
                ", Dew = " + Double.toString(apcnb.getDew()) +
                ", Particle Count = " + Double.toString(apcnb.getPartCnt())
                ;
    }


}
