package org.lsst.ccs.drivers.netbotz;

import org.lsst.ccs.command.annotations.Argument;
import org.lsst.ccs.command.annotations.Command;
import org.lsst.ccs.drivers.commons.DriverException;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;

/**
 **************************************************************************
 **
 ** General access routines for the NetBotz Environment Monitor 
 ** Note that the current driver just obtains the values from a file 
 ** written by a cron job. 
 ** @author Homer Neal
 * **************************************************************************
 */
public class NetbotzDriver {

    /**
     **************************************************************************
     **
     ** Public constants *
     * **************************************************************************
     */
    /**
     **************************************************************************
     **
     ** Private constants *
     * **************************************************************************
     */
    private double Humidity;           // Cleanroom Humidity
    private double Temperature;        // Cleanroom Temperature
    private double Dew;                // Cleanroom Dew point
    private double PartCnt;            // Cleanroom Particle Count

    private String envirofile = "/home/homer/bnlenviro.dat";

    private File nblog = null;
    private BufferedReader in = null;
    String line = null;

    boolean isConnected = false;

    long prevTime = 0; // previous time the env data was acquired

    /**
     **************************************************************************
     **
     ** Constructor * *
     * **************************************************************************
     */
    public NetbotzDriver() {
    }

    /**
     **************************************************************************
     **
     ** Open the device * * @param envirofile - the environment log file to
     * retrieve values from
     *
     * @throws org.lsst.ccs.drivers.commons.DriverException * *
     * **************************************************************************
     */
    public void open(String envirofile) throws DriverException {

        this.envirofile = envirofile;
        nblog = new File(this.envirofile);

        if (!nblog.exists()) {
            System.out.println("Environment data file is inaccessible!");
            throw new DriverException();
        }

        try {
            in = new BufferedReader(new FileReader(nblog));
            isConnected = true;
        } catch (IOException b) {
            System.out.println("Unable to start BufferedReader connection to NetBotz data file" + b);
            isConnected = false;
        }
    }

    /**
     **************************************************************************
     **
     ** Close the device * *
     * **************************************************************************
     */
    public void close() {
        try {
            in.close();
        } catch (IOException ex) {
            System.out.println("NetbotzDriver: Attempt to close stream failed!" + ex);
        }
    }

    /**
     **************************************************************************
     **
     ** return Humidity * *
     * @return 
     * **************************************************************************
     */
    public double getHumidity() {
        return Humidity;
    }

    /**
     **************************************************************************
     **
     ** return Temperature * *
     * @return 
     * **************************************************************************
     */
    public double getTemperature() {
        return Temperature;
    }

    /**
     **************************************************************************
     **
     ** return Dew
     * @return 
     * **************************************************************************
     */
    public double getDew() {
        return Dew;
    }

    /**
     **************************************************************************
     **
     ** return Particle Count * *
     * @return 
     * **************************************************************************
     */
    public double getPartCnt() {
        return PartCnt;
    }

    @Override
    public String toString() {
        return "Humidity=" + Humidity
                + ", Temperature=" + Temperature
                + ", Dew=" + Dew
                + ", PartCnt=" + PartCnt;
    }

    /**
     **************************************************************************
     **
     ** retrieve Netbotz readings * *
     * **************************************************************************
     */
    public void GetEnviro() throws IOException {
        if (isConnected) {

            long now = System.currentTimeMillis();

            if ((now - prevTime) > 5000) { // don't reread in less than 5 seconds
                prevTime = now;

                try {
                    while (in.ready()) { // go to the last line
                        line = in.readLine();
                    }
                    String svals[] = line.split(",");
                    if (svals.length > 4) {
                        Humidity = Double.valueOf((svals[5].split(" "))[3]);
//                System.out.println("Humidity =  "+Humidity);
                        Temperature = Double.valueOf((svals[6].split(" "))[3]);
//                System.out.println("Temperature = "+Temperature);
                        Dew = Double.valueOf((svals[4].split(" "))[3]);
//                System.out.println("Dew =  "+Dew);
                        PartCnt = Double.max(Double.valueOf((svals[2].split(" "))[3]),Double.valueOf((svals[3].split(" "))[3]));
//                System.out.println("Particle Count =  "+PartCnt);
                    } else {
                        System.out.println("Environment data currently unavailable.");
                    }
                } catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
    }

    /**
     **************************************************************************
     **
     ** return NetBotz readings * *
     * **************************************************************************
     */
    public void GetEnviro(Double Humidity, Double Temperature, Double Dew, Double PartCnt) throws IOException {
        try {
            GetEnviro(); // read values
            Humidity = this.Humidity;
            Temperature = this.Temperature;
            Dew = this.Dew;
            PartCnt = this.PartCnt;
        } catch (IOException e) {
            System.out.println("Error retrieving NetBotz readings =  " + e);
        }
    }

}
