/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.utilities.tracers;

import java.net.URL;
import java.util.Arrays;
import java.util.Iterator;
import java.util.Properties;
import java.util.ServiceLoader;
import org.lsst.ccs.bootstrap.BootstrapResourceUtils;
import org.lsst.ccs.utilities.jars.CommonResources;
import org.lsst.ccs.utilities.jars.MavenResources;

public class Tracer {
    static Strategy reporter;
    static final String[] keys;

    static {
        String properties;
        ServiceLoader<Strategy> loader = ServiceLoader.load(Strategy.class);
        boolean found = false;
        try {
            Iterator<Strategy> iterator = loader.iterator();
            if (iterator.hasNext()) {
                Strategy rep;
                reporter = rep = iterator.next();
                found = true;
            }
        }
        catch (Exception exception) {}
        if (!found) {
            String className = BootstrapResourceUtils.getBootstrapSystemProperties().getProperty("org.lsst.ccs.traceReporter");
            if (className == null) {
                reporter = new Strategy(){

                    @Override
                    public void report(String report) {
                        System.out.println(report);
                    }

                    @Override
                    public void addReportLine(String line) {
                        System.out.println(String.valueOf('\t') + line);
                    }

                    @Override
                    public void endReport() {
                    }
                };
            } else {
                try {
                    Class<?> clazz = Class.forName(className);
                    reporter = (Strategy)clazz.newInstance();
                }
                catch (Exception exc) {
                    throw new Error("incorrect class for trace configuration", exc);
                }
            }
        }
        keys = (properties = BootstrapResourceUtils.getBootstrapSystemProperties().getProperty("org.lsst.ccs.traces")) != null ? properties.split(",") : new String[0];
    }

    public static void setReporter(Strategy reporter) {
        Tracer.reporter = reporter;
    }

    public static Strategy getReporter() {
        return reporter;
    }

    public static String[] getKeys() {
        return Arrays.copyOf(keys, keys.length);
    }

    public static boolean trace(String traceString) {
        reporter.report(traceString);
        reporter.endReport();
        return true;
    }

    public static boolean trace(String filter, String traceString) {
        String[] stringArray = keys;
        int n = keys.length;
        int n2 = 0;
        while (n2 < n) {
            String key = stringArray[n2];
            if (key.equalsIgnoreCase(filter)) {
                reporter.report(traceString);
                reporter.endReport();
                return true;
            }
            ++n2;
        }
        return true;
    }

    public static <T extends Enum> boolean trace(T enumElement, String traceString) {
        return Tracer.trace(String.valueOf(enumElement), traceString);
    }

    public static boolean stackTrace() {
        Tracer.stackTrace(3);
        return true;
    }

    public static boolean stackTrace(String filter) {
        String[] stringArray = keys;
        int n = keys.length;
        int n2 = 0;
        while (n2 < n) {
            String key = stringArray[n2];
            if (key.equalsIgnoreCase(filter)) {
                Tracer.stackTrace(3);
                return true;
            }
            ++n2;
        }
        return true;
    }

    public static <T extends Enum> boolean stackTrace(T enumElement) {
        String filter = String.valueOf(enumElement);
        String[] stringArray = keys;
        int n = keys.length;
        int n2 = 0;
        while (n2 < n) {
            String key = stringArray[n2];
            if (key.equalsIgnoreCase(filter)) {
                Tracer.stackTrace(3);
                return true;
            }
            ++n2;
        }
        return true;
    }

    protected static void stackTrace(int levelOut) {
        StackTraceElement[] stack = Thread.currentThread().getStackTrace();
        reporter.report("-----------------");
        int ix = levelOut;
        while (ix < stack.length) {
            StackTraceElement element = stack[ix];
            reporter.addReportLine(element.toString());
            ++ix;
        }
        reporter.endReport();
    }

    public static boolean traceProperties(Object obj, String propFile) {
        if (obj != null) {
            URL[] resURLs;
            Class<?> clazz = obj instanceof Class ? (Class<?>)obj : obj.getClass();
            reporter.report("properties for :" + clazz.getSimpleName() + " [" + clazz.getPackage() + "]");
            URL[] uRLArray = resURLs = CommonResources.getURLsFor(obj, propFile);
            int n = resURLs.length;
            int n2 = 0;
            while (n2 < n) {
                URL url = uRLArray[n2];
                Properties props = CommonResources.getPropertiesFrom(url);
                reporter.addReportLine(" -> " + (props.size() != 0 ? props : " no project property"));
                reporter.addReportLine("\t (in: " + CommonResources.getResourceContainer(url, propFile) + " ) ");
                ++n2;
            }
            reporter.endReport();
        }
        return true;
    }

    public static boolean traceInfos(Object obj) {
        if (obj != null) {
            Class<?> clazz = obj instanceof Class ? (Class<?>)obj : obj.getClass();
            reporter.report("infos for :" + clazz.getSimpleName() + " [" + clazz.getPackage() + "]");
            reporter.endReport();
        }
        return true;
    }

    public static boolean traceWhere(Object obj) {
        String[] urlNames = CommonResources.getClassURLNamesFor(obj);
        reporter.report("where is :" + (obj instanceof Class ? obj : obj.getClass()));
        String[] stringArray = urlNames;
        int n = urlNames.length;
        int n2 = 0;
        while (n2 < n) {
            String name = stringArray[n2];
            reporter.addReportLine("  -> " + name);
            ++n2;
        }
        reporter.endReport();
        return true;
    }

    public static boolean tracePomProperties(String orgName, String projectName) {
        URL[] urlsPom = MavenResources.getPomURLs(orgName, projectName);
        reporter.report("poms for :" + orgName + " " + projectName);
        URL[] uRLArray = urlsPom;
        int n = urlsPom.length;
        int n2 = 0;
        while (n2 < n) {
            URL url = uRLArray[n2];
            Properties props = CommonResources.getPropertiesFrom(url);
            reporter.addReportLine(" -> " + (props.size() != 0 ? props : " no project property"));
            ++n2;
        }
        reporter.endReport();
        return true;
    }

    public static boolean traceOurMavenProperties(String projectName) {
        URL[] urlsPom = MavenResources.getMavenProjectURLs(projectName);
        reporter.report("project maven properties for :" + projectName);
        URL[] uRLArray = urlsPom;
        int n = urlsPom.length;
        int n2 = 0;
        while (n2 < n) {
            URL url = uRLArray[n2];
            Properties props = CommonResources.getPropertiesFrom(url);
            reporter.addReportLine(" -> " + (props.size() != 0 ? props : " no project property"));
            ++n2;
        }
        reporter.endReport();
        return true;
    }

    public static boolean version(String vcsString, Class clazz, String orgName, String projectName) {
        String[] stringArray = keys;
        int n = keys.length;
        int n2 = 0;
        while (n2 < n) {
            String key = stringArray[n2];
            if (key.equalsIgnoreCase("VERSION")) {
                Properties props = MavenResources.getPomProperties(orgName, projectName);
                String version = props.getProperty("version", "unknown version");
                String message = String.format("VERSION: %s %s (with loaders %s,%s,%s)", clazz.getCanonicalName(), vcsString, clazz.getClassLoader(), Thread.currentThread().getContextClassLoader(), ClassLoader.getSystemClassLoader());
                reporter.report(message);
                message = String.format("-------: %s %s ", projectName, version);
                reporter.report(message);
                reporter.endReport();
                return true;
            }
            ++n2;
        }
        return true;
    }

    public static boolean version(String vcsString, Class clazz, String projectName) {
        return Tracer.version(vcsString, clazz, "org.lsst", projectName);
    }

    public static boolean injectSideEffect(String enablingSystemProperty, Runnable sideEffectCode) {
        boolean activation = Boolean.getBoolean(enablingSystemProperty);
        if (activation) {
            sideEffectCode.run();
        }
        return true;
    }

    public static class MultiReporter
    implements Strategy {
        Strategy[] strategies;

        public MultiReporter(Strategy ... strategies) {
            this.strategies = strategies;
        }

        @Override
        public void report(String report) {
            Strategy[] strategyArray = this.strategies;
            int n = this.strategies.length;
            int n2 = 0;
            while (n2 < n) {
                Strategy strategy = strategyArray[n2];
                strategy.report(report);
                ++n2;
            }
        }

        @Override
        public void addReportLine(String line) {
            Strategy[] strategyArray = this.strategies;
            int n = this.strategies.length;
            int n2 = 0;
            while (n2 < n) {
                Strategy strategy = strategyArray[n2];
                strategy.addReportLine(line);
                ++n2;
            }
        }

        @Override
        public void endReport() {
            Strategy[] strategyArray = this.strategies;
            int n = this.strategies.length;
            int n2 = 0;
            while (n2 < n) {
                Strategy strategy = strategyArray[n2];
                strategy.endReport();
                ++n2;
            }
        }
    }

    public static interface Strategy {
        public void report(String var1);

        public void addReportLine(String var1);

        public void endReport();
    }
}

