package org.lsst.ccs.drivers.netbotz;

import org.lsst.ccs.command.annotations.Argument;
import org.lsst.ccs.command.annotations.Command;
import org.lsst.ccs.drivers.commons.DriverException;
import org.lsst.ccs.drivers.commons.DriverTimeoutException;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;


/**
 **************************************************************************
 **
 ** General access routines for this device
 **
 ** Driver methods are annotated for use by CCS command dictionary and shell
 ** system. Exceptions are passed through to next level where either subsystem
 ** or shell code handles them.
 **
 ** @author Your Name
 **
 ***************************************************************************
 */


public class NetbotzDriver {

    /**
     **************************************************************************
     **
     ** Public constants
     **
     ***************************************************************************
     */

    /**
     **************************************************************************
     **
     ** Private constants
     **
     ***************************************************************************
     */
    private double Humidity;           // Cleanroom Humidity
    private double Temperature;        // Cleanroom Temperature
    private double Dew;                // Cleanroom Dew point
    private double PartCnt;            // Cleanroom Particle Count

        private String envirofile = "/home/homer/bnlenviro.dat" ;

    /**
     **************************************************************************
     **
     ** Constructor
     **
     **
     ***************************************************************************
     */
    public NetbotzDriver()  {
    }


    /**
     **************************************************************************
     **
     ** Open the device
     **
     ** @param envirofile - the environment log file to retrieve values from
     * @throws org.lsst.ccs.drivers.commons.DriverException
     **
     **
     ***************************************************************************
     */

    public void open(String envirofile) throws DriverException {

        this.envirofile = envirofile;
        File nblog = new File(this.envirofile);

        if (!nblog.exists()) {
            System.out.println("Environment data file is innaccessible!");
            throw new DriverException();
        }
    }

    /**
     **************************************************************************
     **
     ** Close the device
     **
     **
     ***************************************************************************
     */
    public void close()  {
    }


   /**
     **************************************************************************
     **
     ** return Humidity
     **
     **
     ***************************************************************************
     */
    public double getHumidity()
    {
        return Humidity;
    }

   /**
     **************************************************************************
     **
     ** return Temperature
     **
     **
     ***************************************************************************
     */
    public double getTemperature()
    {
        return Temperature;
    }

   /**
     **************************************************************************
     **
     ** return Dew
     **
     **
     ***************************************************************************
     */
    public double getDew()
    {
        return Dew;
    }

  /**
     **************************************************************************
     **
     ** return Particle Count
     **
     **
     ***************************************************************************
     */
     public double getPartCnt()
    {
        return PartCnt;
    }

    @Override
    public String toString()
    {
        return "Humidity=" + Humidity
                + ", Temperature=" + Temperature
                + ", Dew=" + Dew
                + ", PartCnt=" + PartCnt;
    }

   /**
     **************************************************************************
     **
     ** retrieve Netbotz readings
     **
     **
     ***************************************************************************
     */
    public void GetEnviro() throws IOException
    {
        File nblog = new File(envirofile);
//        System.out.println("Accessing tne enviro file - "+envirofile);

        if (nblog.exists()) {
//            System.out.println("reading enviro file");

            String line = null;

            try {
                BufferedReader in = new BufferedReader(new FileReader(nblog));
                while(in.ready()) { // go to the last line
                  line = in.readLine();
                }
                String svals[] = line.split(",");
                if (svals.length>4) {
                Humidity = Double.valueOf((svals[3].split(" "))[3]);
//                System.out.println("Humidity =  "+Humidity);
                Temperature = Double.valueOf((svals[4].split(" "))[3]);
//                System.out.println("Temperature = "+Temperature);
                Dew = Double.valueOf((svals[2].split(" "))[3]);
//                System.out.println("Dew =  "+Dew);
//                PartCnt = Double.valueOf((svals[5].split(" "))[3]);
//                System.out.println("Particle Count =  "+PartCnt);
                } else {
                    System.out.println("Enviro file currently not ready to be read. Perhaps it is being updated.");
                }
                in.close();
            } catch (IOException e) {
                e.printStackTrace();
            }
        }
    }
    
      /**
     **************************************************************************
     **
     ** return NetBotz readings
     **
     **
     ***************************************************************************
     */
     public void GetEnviro(Double Humidity, Double Temperature, Double Dew, Double PartCnt) throws IOException
    {
        try {
            GetEnviro(); // read values
            Humidity = this.Humidity;
            Temperature = this.Temperature;
            Dew = this.Dew;
            PartCnt = this.PartCnt;
        } catch (IOException e) {
            System.out.println("Error retrieving NetBotz readings =  "+e);
        }
    }

}

