/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.drivers.nanotec;

import java.util.Date;
import org.lsst.ccs.command.annotations.Argument;
import org.lsst.ccs.command.annotations.Command;
import org.lsst.ccs.drivers.commons.DriverException;
import org.lsst.ccs.drivers.nanotec.NanotecPD4N;

public class TestPD4N {
    private final NanotecPD4N pd4n = new NanotecPD4N();

    @Command(name="timestamp", description="Prints current time")
    public String timestamp() {
        Date now = new Date();
        return now.toString();
    }

    @Command(name="open", description="Open connection to device")
    public void open(@Argument(name="ident", description="Identification") String ident) throws DriverException {
        this.pd4n.open(ident);
        this.pd4n.writeGeneral(NanotecPD4N.CmndGeneral.ENCODER_DIR, 1);
    }

    @Command(name="open", description="Open connection with specified baud rate")
    public void open(@Argument(name="ident", description="Identification") String ident, @Argument(name="baudRate", description="must match NanotecPD4N.DataRate enumeration") int baudRate) throws DriverException {
        this.pd4n.open(ident, baudRate);
        this.pd4n.writeGeneral(NanotecPD4N.CmndGeneral.ENCODER_DIR, 1);
    }

    @Command(name="readAll", description="Read all controller settings and data")
    public String readAll() {
        String table = "Read all stepper motor settings and data\n" + this.timestamp() + "\n";
        NanotecPD4N.CmndGeneral[] cmndN = NanotecPD4N.CmndGeneral.values();
        int nN = cmndN.length;
        for (int i = 0; i < nN; ++i) {
            table = table + String.format("\n   %-22s", new Object[]{cmndN[i]});
            try {
                String respN = this.pd4n.readGeneral(cmndN[i]);
                table = table + respN + "   " + cmndN[i].getUnits();
                continue;
            }
            catch (DriverException ex) {
                table = table + ex.getMessage();
            }
        }
        table = table + "\n\n";
        table = table + String.format("Checksum in use %14b\n\n", this.isChecksumUsed());
        table = table + this.readMotionRecord();
        return table;
    }

    @Command(name="isChecksumUsed", description="<true|false> if checksum is <in use | not in use>")
    public boolean isChecksumUsed() {
        return this.pd4n.readChecksumUsage();
    }

    @Command(name="readMotionRecord", description="Read all motion-record settings")
    public String readMotionRecord() {
        String table = "Stepper motor motion-record settings\n" + this.timestamp() + "\n";
        NanotecPD4N.CmndMotion[] cmndN = NanotecPD4N.CmndMotion.values();
        int nN = cmndN.length;
        for (int i = 0; i < nN; ++i) {
            table = table + String.format("\n   %-22s", new Object[]{cmndN[i]});
            try {
                String respN = this.pd4n.readMotion(cmndN[i]);
                table = table + String.format("%-12s", respN) + cmndN[i].getUnits();
                continue;
            }
            catch (DriverException ex) {
                table = table + ex.getMessage();
            }
        }
        table = table + "\n";
        return table;
    }

    @Command(name="readGeneral", description="Read specified general quantity")
    public String readGeneral(@Argument(name="enum quantity", description="name of general quantity") NanotecPD4N.CmndGeneral quantity) throws DriverException {
        return this.pd4n.readGeneral(quantity);
    }

    @Command(name="setGeneral", description="set a general parameter")
    public void setGeneral(@Argument(name="enum quantity", description="CmndGeneral instance") NanotecPD4N.CmndGeneral param, @Argument(name="value", description="value to be set") int value) throws DriverException {
        this.pd4n.writeGeneral(param, value);
    }

    @Command(name="setLimitSwitchBehavior", description="select behavior when motor reaches limit switch")
    public void setLimitSwitchBehavior(@Argument(name="boolean choice", description="<true|false> for <free backward motion|stop>") boolean choice) throws DriverException {
        this.pd4n.setLimitSwitchBehavior(choice);
    }

    @Command(name="showLimitSwitchBehavior", description="show motor behavior upon reaching a limit switch")
    public String showLimitSwitchBehavior() throws DriverException {
        int behavior = Integer.parseInt(this.pd4n.readGeneral(NanotecPD4N.CmndGeneral.SWITCH_BEHAVIOR));
        return NanotecPD4N.LimitSwitchBehavior.decode(behavior);
    }

    @Command(name="readEncoder", description="Read motor encoder position")
    public int readEncoder() throws DriverException {
        String resp = this.pd4n.readGeneral(NanotecPD4N.CmndGeneral.READ_ENCODER);
        return Integer.parseInt(resp);
    }

    @Command(name="readTemperature", description="Read motor temperature in degrees C")
    public String readTemperature() throws DriverException {
        double temp = this.pd4n.readTemperature();
        return String.format("% .2f", temp);
    }

    @Command(name="readTempRepeat", description="Read motor T multiple times")
    public String readTempRepeat(@Argument(name="repeats", description="number of times") int nRepeat) throws DriverException {
        Object output = "";
        for (int i = 0; i < nRepeat; ++i) {
            output = (String)output + " " + this.readTemperature();
        }
        return output;
    }

    @Command(name="readFlags", description="Read useful status flags and error flag")
    public String readFlags() throws DriverException {
        boolean ready = this.pd4n.isMotorReady();
        boolean posErr = this.pd4n.isPositionError();
        boolean error = this.pd4n.getErrorFlag();
        int switches = this.pd4n.getLimitSwitches();
        return "Ready = " + Boolean.toString(ready) + ", Position error = " + Boolean.toString(posErr) + ", Error = " + Boolean.toString(error) + ", Limit switches = " + Integer.toString(switches);
    }

    @Command(name="decodeLastError", description="Decode last error types")
    public String decodeLastError() throws DriverException {
        return this.pd4n.getErrorType();
    }

    @Command(name="resetError", description="Reset controller error flags")
    public void resetError() throws DriverException {
        this.pd4n.resetError();
    }

    @Command(name="readMotion", description="Read specified motion quantity")
    public String readMotion(@Argument(name="enum quantity", description="name of motion quantity") NanotecPD4N.CmndMotion quantity) throws DriverException {
        return this.pd4n.readMotion(quantity);
    }

    @Command(name="setMotion", description="set a motion-record parameter")
    public void setMotion(@Argument(name="enum quantity", description="CmndMotion instance") NanotecPD4N.CmndMotion param, @Argument(name="value", description="value to be set") int value) throws DriverException {
        this.pd4n.writeMotion(param, value);
    }

    @Command(name="saveMotionRecord", description="save current motion record")
    public void saveMotionRecord(@Argument(name="recordNumber", description="location in EEPROM (1 to 32)") int recordNumber) throws DriverException {
        this.pd4n.saveRecord(recordNumber);
    }

    @Command(name="loadMotionRecord", description="load motion record from EEPROM")
    public void loadMotionRecord(@Argument(name="recordNumber", description="location in EEPROM (1 to 32)") int recordNumber) throws DriverException {
        this.pd4n.loadRecord(recordNumber);
    }

    @Command(name="move", description="Start motor and move")
    public void move() throws DriverException {
        this.pd4n.startMotor();
    }

    @Command(name="stop", description="stop motor, using current brake ramp")
    public void stop() throws DriverException {
        this.pd4n.stopMotor(1);
    }

    @Command(name="stopQuick", description="stop motor, using quickstop ramp")
    public void stopQ() throws DriverException {
        this.pd4n.stopMotor(0);
    }

    @Command(name="setBaudRate", description="Select baud rate")
    public void setBaudRate(@Argument(name="<DataRate>", description="enumerated value, BAUD_110 to BAUD_115200 (default)") NanotecPD4N.DataRate value) throws DriverException {
        this.pd4n.writeGeneral(NanotecPD4N.CmndGeneral.BAUD_RATE, value.getCode());
    }

    @Command(name="useChecksum", description="set usage of CRC checksum")
    public void useChecksum(@Argument(name="boolean setting", description="<true|false> to <use | not use>") boolean setting) throws DriverException {
        this.pd4n.setChecksumUsage(setting);
    }

    @Command(name="setDebug", description="enable/disable debug printout")
    public void setDebug(@Argument(name="enable", description="setting") boolean enable) {
        this.pd4n.setDebug(enable);
    }
}

