/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.drivers.motrona;

import org.lsst.ccs.drivers.ascii.Ascii;
import org.lsst.ccs.drivers.commons.DriverConstants;
import org.lsst.ccs.drivers.commons.DriverException;

public class MotronaIV251
extends Ascii {
    private final int TIMEOUT = 1000;
    boolean debug = false;
    private final int BAUD_DEFAULT = 9600;
    private final int FORMAT_DEFAULT = SerialFormat.FORMAT_7EVEN1.getOpenFormat();
    private final String ADDR = "11";
    private static final int ACK_RESP_LEN = 1;
    private static final int INV_RESP_LEN = 4;
    private static final int MIN_READ_LEN = 6;
    private static final int MAX_READ_LEN = 15;
    private static final int DATA_OFFSET = 3;
    private static final int NON_DATA_LEN = 5;
    private final byte STX = (byte)2;
    private final byte ETX = (byte)3;
    private final byte EOT = (byte)4;
    private final byte ENQ = (byte)5;
    private final byte ACK = (byte)6;
    private final byte NAK = (byte)21;
    private static final String Lbl = "MotronaIV251:  ";
    private int errorBitLocation;
    private int errorBitPolarity;

    public MotronaIV251() {
        super(Ascii.Option.NO_NET);
    }

    @Override
    public void open(DriverConstants.ConnType connType, String ident, int baudRate, int commParm) throws DriverException {
        super.open(connType, ident, baudRate == 0 ? 9600 : baudRate, commParm == -1 ? this.FORMAT_DEFAULT : commParm);
        this.setTimeout(1000);
        SerialRate rate = SerialRate.valueOf("BAUD_" + Integer.toString(baudRate));
        if (this.debug) {
            System.out.println("Opening connection with " + rate.toString());
        }
        try {
            this.setParam(CmndParam.SERIAL_TIMER, 0);
            this.setParam(CmndParam.SERIAL_VALUE, 9);
            this.setParam(CmndParam.SERIAL_PROTOCOL, 0);
            this.activateData();
        }
        catch (DriverException e) {
            this.closeSilent();
            throw e;
        }
    }

    public void open(String serialName) throws DriverException {
        this.openSerial(serialName, 9600, this.FORMAT_DEFAULT);
    }

    public int readParam(CmndParam cmnd) throws DriverException {
        String cmndBody = cmnd.getRegister();
        String cmndText = "Read " + cmnd.toString();
        byte[] response = this.respToRead(cmndBody, cmndText);
        String strdata = new String(response, 3, response.length - 5);
        return Integer.parseInt(strdata);
    }

    public void setParam(CmndParam cmnd, int value) throws DriverException {
        if (value < cmnd.getMinValue() || value > cmnd.getMaxValue()) {
            throw new IllegalArgumentException(Lbl + String.format("Value out of range %d to %d", cmnd.getMinValue(), cmnd.getMaxValue()));
        }
        String cmndBody = cmnd.getRegister() + String.format("%d", value);
        String cmndText = "Set " + cmnd.toString() + " " + Integer.toString(value);
        this.respToWrite(cmndBody, cmndText);
    }

    public void setAndActivateParam(CmndParam cmnd, int value) throws DriverException {
        this.setParam(cmnd, value);
        this.activateData();
    }

    void setBaudRate(int value) throws DriverException {
        SerialRate rate = SerialRate.valueOf("BAUD_" + Integer.toString(value));
        this.setParam(CmndParam.SERIAL_BAUD_RATE, rate.rateCode);
    }

    void setFormat(SerialFormat format) throws DriverException {
        this.setParam(CmndParam.SERIAL_FORMAT, format.code);
    }

    public void activateData() throws DriverException {
        String cmndBody = CmndOp.ACTIVATE_DATA.getRegister() + "1";
        String cmndText = "Operation ACTIVATE_DATA";
        this.respToWrite(cmndBody, cmndText);
        this.errorBitLocation = this.readParam(CmndParam.SSI_ERROR_BIT);
        this.errorBitPolarity = this.readParam(CmndParam.SSI_ERROR_POLARITY);
    }

    public void saveToEEProm() throws DriverException {
        String cmndBody = CmndOp.SAVE_TO_EEPROM.getRegister() + "1";
        String cmndText = "Operation SAVE_TO_EEPROM";
        this.respToWrite(cmndBody, cmndText);
    }

    public int readEncoder() throws DriverException {
        String cmndBody = CmndOp.POSITION.getRegister();
        String cmndText = "Read encoder position";
        byte[] response = this.respToRead(cmndBody, cmndText);
        String strdata = new String(response, 3, response.length - 5);
        return Integer.parseInt(strdata);
    }

    public int readErrorBit() throws DriverException {
        String cmndBody = CmndOp.ERROR_BIT.getRegister();
        String cmndText = "Read encoder error bit";
        byte[] response = this.respToRead(cmndBody, cmndText);
        String strdata = new String(response, 3, response.length - 5);
        int errbit = Integer.parseInt(strdata) >>> this.errorBitLocation & 1;
        return this.errorBitPolarity == 1 ? errbit : 1 - errbit;
    }

    private synchronized byte[] respToWrite(String commandBody, String cmndText) throws DriverException {
        byte[] command = new byte[commandBody.length() + 6];
        command[0] = 4;
        System.arraycopy("11".getBytes(), 0, command, 1, 2);
        command[3] = 2;
        System.arraycopy(commandBody.getBytes(), 0, command, 4, commandBody.length());
        command[command.length - 2] = 3;
        command[command.length - 1] = this.computeBCC(command, 4, 1);
        this.flush();
        this.writeBytes(command);
        if (this.debug) {
            System.out.println("Write Command  " + cmndText);
            String sent = "  byte buffer sent:  ";
            for (int isent = 0; isent < command.length; ++isent) {
                sent = sent + String.format("%02x ", command[isent]);
            }
            System.out.println(sent);
        }
        return this.read(false);
    }

    private synchronized byte[] respToRead(String commandBody, String cmndText) throws DriverException {
        byte[] command = new byte[commandBody.length() + 4];
        command[0] = 4;
        System.arraycopy("11".getBytes(), 0, command, 1, 2);
        System.arraycopy(commandBody.getBytes(), 0, command, 3, commandBody.length());
        command[command.length - 1] = 5;
        this.flush();
        this.writeBytes(command);
        if (this.debug) {
            System.out.println("Read Command  " + cmndText);
            String sent = "  byte buffer sent:  ";
            for (int isent = 0; isent < command.length; ++isent) {
                sent = sent + String.format("%02x ", command[isent]);
            }
            System.out.println(sent);
        }
        return this.read(true);
    }

    private byte[] read(boolean readCmnd) throws DriverException {
        byte[] buff = new byte[25];
        int maxExpectedLen = readCmnd ? 15 : 4;
        int curr = 0;
        while (true) {
            curr += this.readBytes(buff, curr);
            if (this.debug) {
                String rsp = "  Response buffer: ";
                for (int irsp = 0; irsp < curr; ++irsp) {
                    rsp = rsp + String.format("%02x ", buff[irsp]);
                }
                System.out.println(rsp);
            }
            if (curr > maxExpectedLen) {
                throw new DriverException(Lbl + String.format("response of %d bytes, max. expected = %d", curr - 1, maxExpectedLen));
            }
            if (this.getIndex(buff, (byte)4) == 3) {
                throw new DriverException("MotronaIV251:   invalid register " + String.format("0x%02x%02x", buff[1], buff[2]));
            }
            if (this.getIndex(buff, (byte)21) == 0) {
                throw new DriverException("MotronaIV251:   error in read command");
            }
            if (readCmnd) {
                int indexETX = this.getIndex(buff, (byte)3);
                if (indexETX <= -1) continue;
                if (curr >= indexETX + 2) {
                    byte cBCC = this.computeBCC(buff, 1, buff.length - indexETX - 1);
                    if (buff[indexETX + 1] == cBCC) break;
                    if (this.debug) {
                        System.out.println(String.format("  received BCC = %02x, excpected = %02x", buff[indexETX + 1], cBCC));
                    }
                    throw new DriverException("MotronaIV251:   checksum incorrect in read-response");
                }
                if (indexETX >= 4) continue;
                throw new DriverException(Lbl + String.format(" read-response too short (ETX found at byte %d", indexETX));
            }
            if (this.getIndex(buff, (byte)6) == 0) break;
        }
        byte[] response = new byte[curr];
        System.arraycopy(buff, 0, response, 0, curr);
        return response;
    }

    private int getIndex(byte[] array, byte xxx) {
        int index = -1;
        if (array.length > 0) {
            for (int i = 0; i < array.length; ++i) {
                if (array[i] != xxx) continue;
                index = i;
                break;
            }
        }
        return index;
    }

    private byte computeBCC(byte[] array, int omitFirst, int omitLast) {
        byte BCC = 0;
        if (array.length - omitFirst - omitLast > 0) {
            for (int i = omitFirst; i < array.length - omitLast; ++i) {
                BCC = (byte)(BCC ^ array[i]);
            }
        }
        return BCC;
    }

    static enum SerialFormat {
        FORMAT_7EVEN1(0, Ascii.DataBits.SEVEN, Ascii.Parity.EVEN, Ascii.StopBits.ONE),
        FORMAT_7EVEN2(1, Ascii.DataBits.SEVEN, Ascii.Parity.EVEN, Ascii.StopBits.TWO),
        FORMAT_7ODD1(2, Ascii.DataBits.SEVEN, Ascii.Parity.ODD, Ascii.StopBits.ONE),
        FORMAT_7ODD2(3, Ascii.DataBits.SEVEN, Ascii.Parity.ODD, Ascii.StopBits.TWO),
        FORMAT_7NONE1(4, Ascii.DataBits.SEVEN, Ascii.Parity.NONE, Ascii.StopBits.ONE),
        FORMAT_7NONE2(5, Ascii.DataBits.SEVEN, Ascii.Parity.NONE, Ascii.StopBits.TWO),
        FORMAT_8EVEN1(6, Ascii.DataBits.EIGHT, Ascii.Parity.EVEN, Ascii.StopBits.ONE),
        FORMAT_8ODD1(7, Ascii.DataBits.EIGHT, Ascii.Parity.ODD, Ascii.StopBits.ONE),
        FORMAT_8NONE1(8, Ascii.DataBits.EIGHT, Ascii.Parity.NONE, Ascii.StopBits.ONE),
        FORMAT_8NONE2(9, Ascii.DataBits.EIGHT, Ascii.Parity.NONE, Ascii.StopBits.ONE);

        private int code;
        private Ascii.DataBits dbits;
        private Ascii.Parity parity;
        private Ascii.StopBits sbits;

        private SerialFormat(int code, Ascii.DataBits dbits, Ascii.Parity parity, Ascii.StopBits sbits) {
            this.code = code;
            this.dbits = dbits;
            this.parity = parity;
            this.sbits = sbits;
        }

        int getOpenFormat() {
            return Ascii.makeDataCharacteristics(this.dbits, this.sbits, this.parity, Ascii.FlowCtrl.NONE);
        }

        public static SerialFormat decode(int code) throws DriverException {
            SerialFormat[] form = SerialFormat.values();
            int n = form.length;
            int found = -1;
            for (int i = 0; i < n; ++i) {
                if (form[i].code != code) continue;
                found = i;
                break;
            }
            if (found == -1) {
                throw new DriverException("MotronaIV251:  invalid format code");
            }
            return form[found];
        }
    }

    static enum SerialRate {
        BAUD_9600(0),
        BAUD_4800(1),
        BAUD_2400(2),
        BAUD_1200(3),
        BAUD_600(4),
        BAUD_19200(5),
        BAUD_38400(6);

        private int rateCode;

        private SerialRate(int rateCode) {
            this.rateCode = rateCode;
        }

        public static SerialRate decode(int code) throws DriverException {
            SerialRate[] rates = SerialRate.values();
            int n = rates.length;
            int found = -1;
            for (int i = 0; i < n; ++i) {
                if (rates[i].rateCode != code) continue;
                found = i;
                break;
            }
            if (found == -1) {
                throw new DriverException("MotronaIV251:  invalid format code");
            }
            return rates[found];
        }
    }

    public static enum CmndParam {
        SSI_LOW_BIT("08", 0, 25),
        SSI_HIGH_BIT("09", 1, 25),
        SSI_BAUD_RATE("10", 100, 100000),
        SSI_WAIT_TIME("11", 0, 10000),
        SSI_OFFSET("12", 0, 99999999),
        SSI_SET_VALUE("13", 0, 99999999),
        SSI_ERROR_BIT("14", 0, 25),
        SSI_ERROR_POLARITY("15", 0, 1),
        UNIT_NUMBER("90", 0, 99),
        SERIAL_BAUD_RATE("91", 0, 6),
        SERIAL_FORMAT("92", 0, 9),
        SERIAL_PROTOCOL("30", 0, 1),
        SERIAL_TIMER("31", 0, 999999),
        SERIAL_VALUE("32", 0, 19);

        private String register;
        private int minValue;
        private int maxValue;

        private CmndParam(String register, int minValue, int maxValue) {
            this.register = register;
            this.minValue = minValue;
            this.maxValue = maxValue;
        }

        public String getRegister() {
            return this.register;
        }

        public int getMinValue() {
            return this.minValue;
        }

        public int getMaxValue() {
            return this.maxValue;
        }
    }

    public static enum CmndOp {
        POSITION(":9", 1),
        ERROR_BIT(";9", 1),
        ACTIVATE_DATA("67", 0),
        SAVE_TO_EEPROM("68", 0);

        private String register;
        private int type;

        private CmndOp(String register, int type) {
            this.register = register;
            this.type = type;
        }

        public String getRegister() {
            return this.register;
        }
    }
}

