/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.drivers.modbus;

import java.io.PrintStream;
import org.lsst.ccs.command.annotations.Argument;
import org.lsst.ccs.command.annotations.Command;
import org.lsst.ccs.drivers.ascii.Ascii;
import org.lsst.ccs.drivers.commons.DriverException;
import org.lsst.ccs.drivers.modbus.Modbus;

public class TestModbus {
    protected final PrintStream out = System.out;
    protected final Modbus mod;

    public TestModbus() {
        this.mod = new Modbus();
    }

    public TestModbus(Modbus mbus) {
        this.mod = mbus;
    }

    @Command(name="open", description="Open connection to general device")
    public void open(@Argument(name="type", description="Connection type") Modbus.ConnType type, @Argument(name="ident", description="Device identifier") String ident) throws DriverException {
        this.mod.open(type, ident);
    }

    @Command(name="open", description="Open connection to general device")
    public void open(@Argument(name="type", description="Connection type") Modbus.ConnType type, @Argument(name="ident", description="Device identifier") String ident, @Argument(name="param", description="Device parameter") int param) throws DriverException {
        this.mod.open(type, ident, param);
    }

    @Command(name="open", description="Open connection to serial device")
    public void open(@Argument(name="type", description="Connection type: net, serial or ftdi") Modbus.ConnType type, @Argument(name="ident", description="Device identifier") String ident, @Argument(name="baud", description="Baud rate") int baud, @Argument(name="dbits", description="The number of data bits") Ascii.DataBits dbits, @Argument(name="sbits", description="The number of stop bits") Ascii.StopBits sbits, @Argument(name="parity", description="The parity") Ascii.Parity parity, @Argument(name="flow", description="The flow control") Ascii.FlowCtrl flow) throws DriverException {
        this.mod.open(type, ident, baud, Modbus.makeDataCharacteristics((Ascii.DataBits)dbits, (Ascii.StopBits)sbits, (Ascii.Parity)parity, (Ascii.FlowCtrl)flow));
    }

    @Command(name="close", description="Close connection to device")
    public void close() throws DriverException {
        this.mod.close();
    }

    @Command(name="setaddress", description="Set the address mode")
    public void setAddress(@Argument(name="mode", description="The address mode: off or on") OnOff mode) throws DriverException {
        this.mod.setAddressMode(mode == OnOff.ON);
    }

    @Command(name="showaddress", description="Show the address mode")
    public void showAddress() throws DriverException {
        this.out.println("Address mode is " + (this.mod.isAddressMode() ? "on" : "off"));
    }

    @Command(name="settimeout", description="Set the timeout")
    public void setTimeout(@Argument(name="timeout", description="The timeout (sec)") double timeout) throws DriverException {
        this.mod.setTimeout(timeout);
    }

    @Command(name="coilread", description="Read a set of coils")
    public void coilRead(@Argument(name="address", description="The Modbus address") int addr, @Argument(name="number", description="First coil to read") int nmbr, @Argument(name="count", description="Number of coils to read") int count) throws DriverException {
        byte[] reply = this.mod.readCoils((short)addr, (short)nmbr, (short)count);
        int nvalue = count <= 8 * reply.length ? count : 8 * reply.length;
        for (int j = 0; j < nvalue; ++j) {
            if (j % 20 == 0) {
                if (j != 0) {
                    this.out.println();
                }
                this.out.format("%4s:", addr + j);
            }
            this.out.format("%2s", (reply[j >> 3] & 1 << (j & 7)) != 0 ? 1 : 0);
        }
        this.out.println();
    }

    @Command(name="discread", description="Read a set of discretes")
    public void discRead(@Argument(name="address", description="The Modbus address") int addr, @Argument(name="number", description="First discrete to read") int nmbr, @Argument(name="count", description="Number of discretes to read") int count) throws DriverException {
        byte[] reply = this.mod.readDiscretes((short)addr, (short)nmbr, (short)count);
        int nvalue = count <= 8 * reply.length ? count : 8 * reply.length;
        for (int j = 0; j < nvalue; ++j) {
            if (j % 20 == 0) {
                if (j != 0) {
                    this.out.println();
                }
                this.out.format("%4s:", nmbr + j);
            }
            this.out.format("%2s", (reply[j >> 3] & 1 << (j & 7)) != 0 ? 1 : 0);
        }
        this.out.println();
    }

    @Command(name="regread", description="Read a set of registers")
    public void regRead(@Argument(name="address", description="The Modbus address") int addr, @Argument(name="number", description="First register to read") int nmbr, @Argument(name="count", description="Number of registers to read") int count) throws DriverException {
        short[] reply = this.mod.readRegisters((short)addr, (short)nmbr, (short)count);
        for (int j = 0; j < reply.length; ++j) {
            if (j % 10 == 0) {
                if (j != 0) {
                    this.out.println();
                }
                this.out.format("%4s:", nmbr + j);
            }
            this.out.format(" %04x", reply[j]);
        }
        this.out.println();
    }

    @Command(name="inpread", description="Read a set of inputs")
    public void inpRead(@Argument(name="address", description="The Modbus address") int addr, @Argument(name="number", description="First input to read") int nmbr, @Argument(name="count", description="Number of inputs to read") int count) throws DriverException {
        short[] reply = this.mod.readInputs((short)addr, (short)nmbr, (short)count);
        for (int j = 0; j < reply.length; ++j) {
            if (j % 10 == 0) {
                if (j != 0) {
                    this.out.println();
                }
                this.out.format("%4s:", nmbr + j);
            }
            this.out.format(" %04x", reply[j]);
        }
        this.out.println();
    }

    @Command(name="coilwrite", description="Write a set of coils")
    public void coilWrite(@Argument(name="address", description="The Modbus address") int addr, @Argument(name="number", description="First coil to write") int nmbr, int ... values) throws DriverException {
        int count = values.length;
        if (count == 0) {
            throw new DriverException("No values supplied");
        }
        if (count == 1) {
            this.mod.writeCoil((short)addr, (short)nmbr, values[0] != 0);
        } else {
            byte[] coils = new byte[(count + 7) / 8];
            int value = 0;
            int index = 0;
            for (int j = 0; j < count; ++j) {
                if ((j & 7) == 0 && j > 0) {
                    coils[index++] = (byte)value;
                    value = 0;
                }
                if (values[j] == 0) continue;
                value |= 1 << (j & 7);
            }
            coils[index] = (byte)value;
            this.mod.writeCoils((short)addr, (short)nmbr, (short)count, coils);
        }
    }

    @Command(name="regwrite", description="Write a set of registers")
    public void regWrite(@Argument(name="address", description="The Modbus address") int addr, @Argument(name="number", description="First register to write") int nmbr, int ... values) throws DriverException {
        int count = values.length;
        if (count == 0) {
            throw new DriverException("No values supplied");
        }
        if (count == 1) {
            this.mod.writeRegister((short)addr, (short)nmbr, (short)values[0]);
        } else {
            short[] sValues = new short[count];
            for (int j = 0; j < count; ++j) {
                sValues[j] = (short)values[j];
            }
            this.mod.writeRegisters((short)addr, (short)nmbr, sValues);
        }
    }

    protected static enum OnOff {
        ON,
        OFF;

    }
}

