/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.drivers.modbus;

import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.TimeUnit;
import org.lsst.ccs.drivers.ftdi.Ftdi;
import org.lsst.ccs.drivers.ftdi.FtdiException;
import org.lsst.ccs.drivers.modbus.CRC16;
import org.lsst.ccs.drivers.modbus.ModbusException;
import org.lsst.ccs.utilities.conv.Convert;

public class Modbus {
    static final byte FUNC_READ_COILS = 1;
    static final byte FUNC_READ_DISCRETES = 2;
    static final byte FUNC_READ_REGISTERS = 3;
    static final byte FUNC_READ_INPUTS = 4;
    static final byte FUNC_WRITE_COIL = 5;
    static final byte FUNC_WRITE_REGISTER = 6;
    static final byte FUNC_WRITE_COILS = 15;
    static final byte FUNC_WRITE_REGISTERS = 16;
    static final int EXCP_ILL_FUNC = 1;
    static final int EXCP_ILL_ADDR = 2;
    static final int EXCP_ILL_VALUE = 3;
    static final int EXCP_SRVR_FAIL = 4;
    static final int BAUD_RATE = 115200;
    private static final int READ_TIMEOUT = 2000;
    private static final int CLOSE_TIMEOUT = 5000;
    private static final int READ_INTERVAL = 1000;
    private static final int PACKET_INTERVAL = 50;
    private final Reader reader = new Reader();
    private Thread readMb;
    private Ftdi ftd = new Ftdi();
    private ArrayBlockingQueue replyQ = new ArrayBlockingQueue(1);
    private ArrayBlockingQueue closeQ = new ArrayBlockingQueue(1);
    private boolean closed = true;

    public void open(int index, String serial) throws ModbusException {
        this.open(null, index, serial);
    }

    public void open(String node, int index, String serial) throws ModbusException {
        try {
            this.ftd.open(node, index, serial);
            this.ftd.setBaudrate(115200);
            this.ftd.setDataCharacteristics(8, 0, 0);
        }
        catch (FtdiException e) {
            throw new ModbusException(e.getMessage());
        }
        this.closed = false;
        this.readMb = new Thread(this.reader);
        this.readMb.setDaemon(true);
        this.readMb.start();
    }

    public void close() throws ModbusException {
        if (this.closed) {
            throw new ModbusException("Device not open");
        }
        this.closeQ.clear();
        this.closed = true;
        Object result = null;
        try {
            result = this.closeQ.poll(5000L, TimeUnit.MILLISECONDS);
        }
        catch (InterruptedException interruptedException) {}
        if (result == null) {
            throw new ModbusException("Close timeout");
        }
        if (result instanceof ModbusException) {
            throw (ModbusException)result;
        }
    }

    public Ftdi getFtdi() {
        return this.ftd;
    }

    public byte[] readCoils(short dAddr, short cNmbr, short count) throws ModbusException {
        byte[] cmnd = new byte[8];
        cmnd[1] = 1;
        Convert.shortToBytesBE((short)((short)(cNmbr - 1)), (byte[])cmnd, (int)2);
        Convert.shortToBytesBE((short)count, (byte[])cmnd, (int)4);
        byte[] resp = this.send(dAddr, cmnd, 2000);
        int nbyte = resp[2] & 0xFF;
        byte[] value = new byte[nbyte];
        System.arraycopy(resp, 3, value, 0, nbyte);
        return value;
    }

    public byte[] readDiscretes(short dAddr, short iNmbr, short count) throws ModbusException {
        byte[] cmnd = new byte[8];
        cmnd[1] = 2;
        Convert.shortToBytesBE((short)((short)(iNmbr - 1)), (byte[])cmnd, (int)2);
        Convert.shortToBytesBE((short)count, (byte[])cmnd, (int)4);
        byte[] resp = this.send(dAddr, cmnd, 2000);
        int nbyte = resp[2] & 0xFF;
        byte[] value = new byte[nbyte];
        System.arraycopy(resp, 3, value, 0, nbyte);
        return value;
    }

    public short[] readRegisters(short dAddr, short rNmbr, short count) throws ModbusException {
        byte[] cmnd = new byte[8];
        cmnd[1] = 3;
        Convert.shortToBytesBE((short)((short)(rNmbr - 1)), (byte[])cmnd, (int)2);
        Convert.shortToBytesBE((short)count, (byte[])cmnd, (int)4);
        byte[] resp = this.send(dAddr, cmnd, 2000);
        int nvalue = (resp[2] & 0xFF) / 2;
        short[] value = new short[nvalue];
        int j = 0;
        while (j < nvalue) {
            value[j] = Convert.bytesToShortBE((byte[])resp, (int)(2 * j + 3));
            ++j;
        }
        return value;
    }

    public short[] readInputs(short dAddr, short rNmbr, short count) throws ModbusException {
        byte[] cmnd = new byte[8];
        cmnd[1] = 4;
        Convert.shortToBytesBE((short)((short)(rNmbr - 1)), (byte[])cmnd, (int)2);
        Convert.shortToBytesBE((short)count, (byte[])cmnd, (int)4);
        byte[] resp = this.send(dAddr, cmnd, 2000);
        int nvalue = (resp[2] & 0xFF) / 2;
        short[] value = new short[nvalue];
        int j = 0;
        while (j < nvalue) {
            value[j] = Convert.bytesToShortBE((byte[])resp, (int)(2 * j + 3));
            ++j;
        }
        return value;
    }

    public void writeRegister(short dAddr, short rNmbr, short value) throws ModbusException {
        byte[] cmnd = new byte[8];
        cmnd[1] = 6;
        Convert.shortToBytesBE((short)((short)(rNmbr - 1)), (byte[])cmnd, (int)2);
        Convert.shortToBytesBE((short)value, (byte[])cmnd, (int)4);
        this.send(dAddr, cmnd, 2000);
    }

    public void writeCoil(short dAddr, short cNmbr, boolean value) throws ModbusException {
        byte[] cmnd = new byte[8];
        cmnd[1] = 5;
        Convert.shortToBytesBE((short)((short)(cNmbr - 1)), (byte[])cmnd, (int)2);
        Convert.shortToBytesBE((short)((short)(value ? 65280 : 0)), (byte[])cmnd, (int)4);
        this.send(dAddr, cmnd, 2000);
    }

    public void writeRegisters(short dAddr, short rNmbr, short[] value) throws ModbusException {
        int count = value.length;
        byte[] cmnd = new byte[2 * count + 9];
        cmnd[1] = 16;
        Convert.shortToBytesBE((short)((short)(rNmbr - 1)), (byte[])cmnd, (int)2);
        Convert.shortToBytesBE((short)((short)count), (byte[])cmnd, (int)4);
        cmnd[6] = (byte)(2 * count);
        int j = 0;
        while (j < count) {
            Convert.shortToBytesBE((short)value[j], (byte[])cmnd, (int)(2 * j + 7));
            ++j;
        }
        this.send(dAddr, cmnd, 2000);
    }

    public void writeCoils(short dAddr, short cNmbr, short count, byte[] value) throws ModbusException {
        int nbyte = (count + 7) / 8;
        byte[] cmnd = new byte[nbyte + 9];
        cmnd[1] = 15;
        Convert.shortToBytesBE((short)((short)(cNmbr - 1)), (byte[])cmnd, (int)2);
        Convert.shortToBytesBE((short)count, (byte[])cmnd, (int)4);
        cmnd[6] = (byte)nbyte;
        System.arraycopy(value, 0, cmnd, 7, nbyte);
        this.send(dAddr, cmnd, 2000);
    }

    public byte[] send(short addr, byte[] cmnd, int timeout) throws ModbusException {
        this.replyQ.clear();
        cmnd[0] = (byte)addr;
        int leng = cmnd.length;
        CRC16.generateStd(cmnd, 0, leng - 2, cmnd, leng - 2);
        try {
            this.ftd.write(cmnd);
        }
        catch (FtdiException e) {
            throw new ModbusException(e.getMessage());
        }
        byte[] respObj = null;
        try {
            respObj = (byte[])this.replyQ.poll(timeout, TimeUnit.MILLISECONDS);
        }
        catch (InterruptedException interruptedException) {}
        if (respObj == null) {
            throw new ModbusException("Read timeout");
        }
        if (respObj instanceof ModbusException) {
            throw (ModbusException)respObj;
        }
        byte[] resp = respObj;
        if (CRC16.generateStd(resp) != 0) {
            throw new ModbusException("Reply checksum error");
        }
        if ((resp[0] & 0xFF) != addr) {
            throw new ModbusException("Invalid reply address");
        }
        if ((resp[1] & 0x7F) != cmnd[1]) {
            throw new ModbusException("Invalid reply function code");
        }
        if ((resp[1] & 0x80) != 0) {
            String message;
            byte code = resp[2];
            switch (code) {
                case 1: {
                    message = "illegal function";
                    break;
                }
                case 2: {
                    message = "illegal data address";
                    break;
                }
                case 3: {
                    message = "illegal data value";
                    break;
                }
                case 4: {
                    message = "server device failure";
                    break;
                }
                default: {
                    message = "unknown code (" + code + ")";
                }
            }
            throw new ModbusException("Reply exception: " + message);
        }
        return resp;
    }

    private class Reader
    implements Runnable {
        private Reader() {
        }

        @Override
        public void run() {
            FtdiException excp;
            block10: {
                excp = null;
                byte[] buff = new byte[256];
                while (true) {
                    int leng = 0;
                    int nread = 0;
                    try {
                        Modbus.this.ftd.setTimeouts(1000, 0);
                        while (!Modbus.this.closed && nread == 0) {
                            nread = Modbus.this.ftd.read(buff, 0, 1);
                        }
                        if (Modbus.this.closed) break;
                        leng += nread;
                        Modbus.this.ftd.setTimeouts(50, 0);
                        nread = Modbus.this.ftd.read(buff, leng, buff.length - leng);
                    }
                    catch (FtdiException e) {
                        excp = e;
                        break;
                    }
                    byte[] data = new byte[leng += nread];
                    System.arraycopy(buff, 0, data, 0, leng);
                    Modbus.this.replyQ.offer(data);
                }
                try {
                    Modbus.this.ftd.close();
                }
                catch (FtdiException e) {
                    if (!Modbus.this.closed) break block10;
                    excp = e;
                }
            }
            if (!Modbus.this.closed) {
                Modbus.this.closed = true;
                Modbus.this.replyQ.offer(new ModbusException(excp.getMessage()));
            } else if (excp == null) {
                Modbus.this.closeQ.offer(new Object());
            } else {
                Modbus.this.closeQ.offer(new ModbusException(excp.getMessage()));
            }
        }
    }
}

