/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.drivers.mmr;

import org.lsst.ccs.command.annotations.Argument;
import org.lsst.ccs.command.annotations.Command;
import org.lsst.ccs.drivers.commons.DriverException;
import org.lsst.ccs.drivers.mmr.Mmr;

public class TestMmr
implements Mmr.Listener {
    protected Mmr mmr = new Mmr();
    int nSkip;
    int nLeft;

    @Command(name="open", description="Open connection to device")
    public void open(@Argument(name="type", description="Connection type: serial or ftdi") ConnType type, @Argument(name="ident", description="Device identifier") String ident) throws DriverException {
        this.mmr.open(type.getValue(), ident);
    }

    @Command(name="close", description="Close connection to device")
    public void close() throws DriverException {
        this.mmr.close();
    }

    @Command(name="listen", description="Turns listener on or off")
    public void write(@Argument(name="onoff", description="state: on or off") OnOff onoff) {
        if (onoff.getValue()) {
            this.mmr.addListener(this);
        } else {
            this.mmr.removeListener();
        }
    }

    @Command(name="skip", description="Sets data message skip count")
    public void write(@Argument(name="count", description="Items to skip") int count) {
        this.nSkip = count;
        this.nLeft = 0;
    }

    @Override
    public void processData(double[] data) {
        if (this.nLeft-- > 0) {
            return;
        }
        System.out.format("A = %s, T0 = %s, T1 = %s, P0 = %s, P1 = %s, D0 = %s, D1 = %s, I = %s\n", data[0], data[1], data[2], data[3], data[4], data[5], data[6], data[7]);
        this.nLeft = this.nSkip;
    }

    @Override
    public void setPowered(boolean on) {
        System.out.println("Power turned " + (on ? "on" : "off"));
    }

    @Override
    public void setClosed(Exception e) {
        System.out.println("Connection closed: " + e);
    }

    public static enum ConnType {
        FTDI(1),
        SERIAL(2);

        int value;

        private ConnType(int value) {
            this.value = value;
        }

        public int getValue() {
            return this.value;
        }
    }

    public static enum OnOff {
        ON(true),
        OFF(false);

        boolean value;

        private OnOff(boolean value) {
            this.value = value;
        }

        public boolean getValue() {
            return this.value;
        }
    }
}

