/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.drivers.ascii;

import java.io.OutputStream;
import java.io.PrintStream;
import jline.console.ConsoleReader;
import org.kohsuke.args4j.Argument;
import org.kohsuke.args4j.CmdLineException;
import org.kohsuke.args4j.CmdLineParser;
import org.kohsuke.args4j.Option;
import org.lsst.ccs.drivers.ascii.Ascii;
import org.lsst.ccs.drivers.commons.DriverException;
import org.lsst.ccs.drivers.commons.DriverTimeoutException;

public class TalkAscii {
    private static final PrintStream out = System.out;
    private static final String[] terms = new String[]{"\r\n", "\r", "\n"};
    private final Thread readW = new Thread(new Reader());
    private final Ascii dev = new Ascii();
    private int nRead = 0;
    private int nByte = 0;
    private int nTimeout = 0;
    private boolean open;

    public static void main(String[] args) {
        Options optns = new Options();
        CmdLineParser parser = new CmdLineParser((Object)optns);
        try {
            parser.parseArgument(args);
            if (optns.showHelp) {
                TalkAscii.showHelp(parser);
            } else {
                new TalkAscii().run(optns);
            }
        }
        catch (CmdLineException e) {
            if (!optns.showHelp) {
                out.println(e.getMessage());
            }
            TalkAscii.showHelp(parser);
        }
        catch (Exception e) {
            out.println(e);
        }
        System.exit(0);
    }

    private void run(Options optns) throws Exception {
        String line;
        this.dev.open(optns.type, optns.ident, optns.parm, Ascii.makeDataCharacteristics(optns.dataBits, optns.stopBits, optns.parity, optns.flowCtrl));
        this.open = true;
        this.dev.setTimeout(0.2);
        this.dev.setTerminator(terms[optns.term.ordinal()]);
        this.readW.setDaemon(true);
        this.readW.start();
        ConsoleReader readC = new ConsoleReader();
        out.println("Connected. Type CTRL-D to exit, CR for read stats.");
        while ((line = readC.readLine("")) != null) {
            if (line.isEmpty()) {
                out.format("#reads: %s; #bytes: %s; #timeouts: %s %n", this.nRead, this.nByte, this.nTimeout);
                continue;
            }
            this.dev.write(line);
        }
        this.open = false;
        this.dev.close();
    }

    private static void showHelp(CmdLineParser parser) {
        out.println("Usage: TalkAscii [options...] <ident> <parm>");
        out.println("Parameters & options:");
        parser.printUsage((OutputStream)out);
    }

    private class Reader
    implements Runnable {
        private Reader() {
        }

        @Override
        public void run() {
            while (TalkAscii.this.open) {
                try {
                    Thread.yield();
                    String reply = TalkAscii.this.dev.read();
                    out.println(reply);
                    TalkAscii.this.nRead++;
                    TalkAscii.this.nByte = TalkAscii.this.nByte + reply.length();
                }
                catch (DriverTimeoutException e) {
                    TalkAscii.this.nTimeout++;
                }
                catch (DriverException e) {
                    if (!TalkAscii.this.open) continue;
                    out.println((Object)e);
                    System.exit(0);
                }
            }
        }
    }

    private static class Options {
        @Option(name="-c", metaVar="<connType>", usage="Connection type: net (default), ftdi or serial")
        private final Ascii.ConnType type = Ascii.ConnType.NET;
        @Option(name="-p", metaVar="<parity>", usage="Parity: none (default), odd, even, mark or space")
        private final Ascii.Parity parity = Ascii.Parity.NONE;
        @Option(name="-d", metaVar="<dbits>", usage="No. data bits: eight (default) or seven")
        private final Ascii.DataBits dataBits = Ascii.DataBits.EIGHT;
        @Option(name="-s", metaVar="<sbits>", usage="No. stop bits: one (default) or two")
        private final Ascii.StopBits stopBits = Ascii.StopBits.ONE;
        @Option(name="-f", metaVar="<flow>", usage="Flow control: none (default), rts, dtr or xon")
        private final Ascii.FlowCtrl flowCtrl = Ascii.FlowCtrl.NONE;
        @Option(name="-r", metaVar="<timeout>", usage="Read timeout (sec) (default = 0.2)")
        private final double timeout = 0.2;
        @Option(name="-t", metaVar="<term>", usage="Command terminator: crlf (default), cr or lf")
        private final Terminator term = Terminator.CRLF;
        @Option(name="-help", usage="Displays this help")
        private boolean showHelp;
        @Argument(index=0, required=true, metaVar="<ident>", usage="Device identifier (node, serial no. or device name)")
        private String ident;
        @Argument(index=1, required=true, metaVar="<parm>", usage="Device parameter (port number or baud rate)")
        private int parm;

        private Options() {
        }
    }

    private static enum Terminator {
        CRLF,
        CR,
        LF;

    }
}

