/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.command;

import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.Set;
import org.lsst.ccs.command.BasicCommand;
import org.lsst.ccs.command.CommandInvocationException;
import org.lsst.ccs.command.CommandSet;
import org.lsst.ccs.command.CompositeCommandDictionary;
import org.lsst.ccs.command.Dictionary;

public class CompositeCommandSet
implements CommandSet {
    private Set<CommandSet> commands = new LinkedHashSet<CommandSet>();
    private CompositeCommandDictionary dict = new CompositeCommandDictionary();

    public void add(CommandSet set) {
        this.commands.add(set);
        this.dict.add(set.getCommandDictionary());
    }

    public void remove(CommandSet set) {
        this.commands.remove(set);
        this.dict.remove(set.getCommandDictionary());
    }

    public Set<CommandSet> getCommandSets() {
        return Collections.unmodifiableSet(this.commands);
    }

    @Override
    public Dictionary getCommandDictionary() {
        return this.dict;
    }

    @Override
    public Object invoke(BasicCommand command) throws CommandInvocationException {
        for (CommandSet set : this.commands) {
            if (!set.getCommandDictionary().containsCommand(command)) continue;
            return set.invoke(command);
        }
        throw new CommandInvocationException("Error: No handler found for command %s with %d arguments", command.getCommand(), command.getArgumentCount());
    }
}

