/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.utilities.logging;

import java.io.FilePermission;
import java.io.IOException;
import java.net.URLClassLoader;
import java.security.AccessControlException;
import java.security.AccessController;
import java.security.Permission;
import java.security.PrivilegedAction;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import java.util.StringTokenizer;
import java.util.WeakHashMap;
import java.util.logging.Filter;
import java.util.logging.Formatter;
import java.util.logging.Handler;
import java.util.logging.Level;
import java.util.logging.LogManager;
import java.util.logging.Logger;
import java.util.logging.SimpleFormatter;
import org.lsst.ccs.bootstrap.resources.BootstrapResourceUtils;

public class ContextLogManager
extends LogManager {
    protected final Map<ClassLoader, ClassLoaderLogInfo> classLoaderLoggers = new WeakHashMap<ClassLoader, ClassLoaderLogInfo>();
    protected ThreadLocal<String> prefix = new ThreadLocal();
    protected volatile boolean useShutdownHook = true;

    public ContextLogManager() {
        try {
            Runtime.getRuntime().addShutdownHook(new Cleaner());
        }
        catch (IllegalStateException illegalStateException) {}
    }

    public boolean isUseShutdownHook() {
        return this.useShutdownHook;
    }

    public void setUseShutdownHook(boolean useShutdownHook) {
        this.useShutdownHook = useShutdownHook;
    }

    @Override
    public synchronized boolean addLogger(final Logger logger) {
        String useParentHandlersString;
        String loggerName = logger.getName();
        ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
        ClassLoaderLogInfo info = this.getClassLoaderInfo(classLoader);
        if (info.loggers.containsKey(loggerName)) {
            return false;
        }
        info.loggers.put(loggerName, logger);
        final String levelString = this.getProperty(String.valueOf(loggerName) + ".level");
        if (levelString != null) {
            try {
                AccessController.doPrivileged(new PrivilegedAction(){

                    public Object run() {
                        logger.setLevel(Level.parse(levelString.trim()));
                        return null;
                    }
                });
            }
            catch (IllegalArgumentException illegalArgumentException) {}
        }
        int dotIndex = loggerName.lastIndexOf(46);
        while (dotIndex >= 0) {
            String parentName = loggerName.substring(0, dotIndex);
            if (this.getProperty(String.valueOf(parentName) + ".level") != null) {
                Logger.getLogger(parentName);
                break;
            }
            dotIndex = loggerName.lastIndexOf(46, dotIndex - 1);
        }
        LogNode node = info.rootNode.findNode(loggerName);
        node.logger = logger;
        Logger parentLogger = node.findParentLogger();
        if (parentLogger != null) {
            ContextLogManager.doSetParentLogger(logger, parentLogger);
        }
        node.setParentLogger(logger);
        String handlers = this.getProperty(String.valueOf(loggerName) + ".handlers");
        if (handlers != null) {
            logger.setUseParentHandlers(false);
            StringTokenizer tok = new StringTokenizer(handlers, ",");
            while (tok.hasMoreTokens()) {
                String handlerName = tok.nextToken().trim();
                Handler handler = null;
                ClassLoader current = classLoader;
                while (current != null) {
                    info = this.classLoaderLoggers.get(current);
                    if (info != null && (handler = info.handlers.get(handlerName)) != null) break;
                    current = current.getParent();
                }
                if (handler == null) continue;
                logger.addHandler(handler);
            }
        }
        if (Boolean.valueOf(useParentHandlersString = this.getProperty(String.valueOf(loggerName) + ".useParentHandlers")).booleanValue()) {
            logger.setUseParentHandlers(true);
        }
        return true;
    }

    @Override
    public synchronized Logger getLogger(String name) {
        ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
        return this.getClassLoaderInfo((ClassLoader)classLoader).loggers.get(name);
    }

    @Override
    public synchronized Enumeration<String> getLoggerNames() {
        ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
        return Collections.enumeration(this.getClassLoaderInfo((ClassLoader)classLoader).loggers.keySet());
    }

    @Override
    public String getProperty(String name) {
        ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
        String prefix = this.prefix.get();
        if (prefix != null) {
            name = String.valueOf(prefix) + name;
        }
        ClassLoaderLogInfo info = this.getClassLoaderInfo(classLoader);
        String result = info.props.getProperty(name);
        if (result == null && info.props.isEmpty()) {
            ClassLoader current = classLoader.getParent();
            while (current != null) {
                info = this.classLoaderLoggers.get(current);
                if (info != null && ((result = info.props.getProperty(name)) != null || !info.props.isEmpty())) break;
                current = current.getParent();
            }
            if (result == null) {
                result = super.getProperty(name);
            }
        }
        if (result != null) {
            Properties props = BootstrapResourceUtils.getBootstrapSystemProperties();
            result = this.replace(result, props);
        }
        return result;
    }

    private synchronized void setLevelsOnExistingLoggers(Properties props) {
        Enumeration<?> enum_ = props.propertyNames();
        while (enum_.hasMoreElements()) {
            String key = (String)enum_.nextElement();
            if (!key.endsWith(".level")) continue;
            int ix = key.length() - 6;
            String name = key.substring(0, ix);
            Level level = this.getLevelProperty(key, null);
            if (level == null) {
                System.err.println("Bad level value for property: " + key);
                continue;
            }
            Logger l = this.getLogger(name);
            if (l == null) continue;
            l.setLevel(level);
        }
    }

    public String getStringProperty(String name, String defaultValue) {
        String val = this.getProperty(name);
        if (val == null) {
            return defaultValue;
        }
        return val.trim();
    }

    public int getIntProperty(String name, int defaultValue) {
        String val = this.getProperty(name);
        if (val == null) {
            return defaultValue;
        }
        try {
            return Integer.parseInt(val.trim());
        }
        catch (Exception exception) {
            return defaultValue;
        }
    }

    public boolean getBooleanProperty(String name, boolean defaultValue) {
        String val = this.getProperty(name);
        if (val == null) {
            return defaultValue;
        }
        if ((val = val.toLowerCase()).equals("true") || val.equals("1")) {
            return true;
        }
        if (val.equals("false") || val.equals("0")) {
            return false;
        }
        return defaultValue;
    }

    public Level getLevelProperty(String name, Level defaultValue) {
        String val = this.getProperty(name);
        if (val == null) {
            return defaultValue;
        }
        try {
            return Level.parse(val.trim());
        }
        catch (Exception exception) {
            return defaultValue;
        }
    }

    public Filter getFilterProperty(String name, Filter defaultValue) {
        String val = this.getProperty(name);
        try {
            if (val != null) {
                Class<?> clz = ClassLoader.getSystemClassLoader().loadClass(val);
                return (Filter)clz.newInstance();
            }
        }
        catch (Exception exception) {}
        return defaultValue;
    }

    public Formatter getFormatterProperty(String name, Formatter defaultValue) {
        String val = this.getProperty(name);
        try {
            if (val != null) {
                Class<?> clz = ClassLoader.getSystemClassLoader().loadClass(val);
                return (Formatter)clz.newInstance();
            }
        }
        catch (Exception exception) {}
        return defaultValue;
    }

    @Override
    public void readConfiguration() throws IOException, SecurityException {
        this.checkAccess();
        this.readConfiguration(Thread.currentThread().getContextClassLoader());
    }

    public void readConfiguration(Properties properties) throws IOException, SecurityException {
        this.checkAccess();
        this.reset();
        this.readConfiguration(properties, Thread.currentThread().getContextClassLoader());
    }

    @Override
    public void reset() throws SecurityException {
        Thread thread = Thread.currentThread();
        if (thread.getClass().getName().startsWith("java.util.logging.LogManager$")) {
            return;
        }
        ClassLoader classLoader = thread.getContextClassLoader();
        ClassLoaderLogInfo clLogInfo = this.getClassLoaderInfo(classLoader);
        this.resetLoggers(clLogInfo);
        super.reset();
    }

    public void shutdown() {
        for (ClassLoaderLogInfo clLogInfo : this.classLoaderLoggers.values()) {
            this.resetLoggers(clLogInfo);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void resetLoggers(ClassLoaderLogInfo clLogInfo) {
        ClassLoaderLogInfo classLoaderLogInfo = clLogInfo;
        synchronized (classLoaderLogInfo) {
            for (Logger logger : clLogInfo.loggers.values()) {
                Handler[] handlers;
                Handler[] handlerArray = handlers = logger.getHandlers();
                int n = handlers.length;
                int n2 = 0;
                while (n2 < n) {
                    Handler handler = handlerArray[n2];
                    logger.removeHandler(handler);
                    ++n2;
                }
            }
            for (Handler handler : clLogInfo.handlers.values()) {
                try {
                    handler.close();
                }
                catch (Exception exception) {}
            }
            clLogInfo.handlers.clear();
        }
    }

    protected ClassLoaderLogInfo getClassLoaderInfo(ClassLoader classLoader) {
        ClassLoaderLogInfo info;
        if (classLoader == null) {
            classLoader = ClassLoader.getSystemClassLoader();
        }
        if ((info = this.classLoaderLoggers.get(classLoader)) == null) {
            final ClassLoader classLoaderParam = classLoader;
            AccessController.doPrivileged(new PrivilegedAction(){

                public Object run() {
                    try {
                        ContextLogManager.this.readConfiguration(classLoaderParam);
                    }
                    catch (IOException iOException) {}
                    return null;
                }
            });
            info = this.classLoaderLoggers.get(classLoader);
        }
        return info;
    }

    protected void readConfiguration(ClassLoader classLoader) throws IOException {
        Properties bootstrapSystemProperties;
        String configFileStr;
        ClassLoaderLogInfo info;
        Properties loggingProperties;
        block9: {
            loggingProperties = null;
            try {
                if (classLoader instanceof URLClassLoader && ((URLClassLoader)classLoader).findResource("logging.properties") != null) {
                    loggingProperties = BootstrapResourceUtils.getBootstrapProperties("logging.properties", false, classLoader);
                }
            }
            catch (AccessControlException ace) {
                Logger log;
                info = this.classLoaderLoggers.get(ClassLoader.getSystemClassLoader());
                if (info == null || (log = info.loggers.get("")) == null) break block9;
                Permission perm = ace.getPermission();
                if (perm instanceof FilePermission && perm.getActions().equals("read")) {
                    log.warning("Reading " + perm.getName() + " is not permitted.");
                }
                log.warning("Reading logging.properties is not permitted in some context");
                log.warning("Original error was: " + ace.getMessage());
            }
        }
        if (loggingProperties == null && classLoader == ClassLoader.getSystemClassLoader() && (configFileStr = (bootstrapSystemProperties = BootstrapResourceUtils.getBootstrapSystemProperties()).getProperty("java.util.logging.config.file")) != null) {
            loggingProperties = BootstrapResourceUtils.getBootstrapProperties(this.replace(configFileStr, bootstrapSystemProperties), false, classLoader);
        }
        RootLogger localRootLogger = new RootLogger();
        if (loggingProperties == null) {
            ClassLoader current = classLoader.getParent();
            ClassLoaderLogInfo info2 = null;
            while (current != null && info2 == null) {
                info2 = this.getClassLoaderInfo(current);
                current = current.getParent();
            }
            if (info2 != null) {
                localRootLogger.setParent(info2.rootNode.logger);
            }
        }
        info = new ClassLoaderLogInfo(new LogNode(null, localRootLogger));
        this.classLoaderLoggers.put(classLoader, info);
        if (loggingProperties != null) {
            this.readConfiguration(loggingProperties, classLoader);
        }
        this.addLogger(localRootLogger);
    }

    protected void readConfiguration(Properties properties, ClassLoader classLoader) throws IOException {
        ClassLoaderLogInfo info = this.classLoaderLoggers.get(classLoader);
        info.setProperties(properties);
        String rootHandlers = info.props.getProperty(".handlers");
        String handlers = info.props.getProperty("handlers");
        Logger localRootLogger = info.rootNode.logger;
        if (handlers != null) {
            StringTokenizer tok = new StringTokenizer(handlers, ",");
            while (tok.hasMoreTokens()) {
                int pos;
                String handlerName;
                String handlerClassName = handlerName = tok.nextToken().trim();
                String prefix = "";
                if (handlerClassName.length() <= 0) continue;
                if (Character.isDigit(handlerClassName.charAt(0)) && (pos = handlerClassName.indexOf(46)) >= 0) {
                    prefix = handlerClassName.substring(0, pos + 1);
                    handlerClassName = handlerClassName.substring(pos + 1);
                }
                try {
                    this.prefix.set(prefix);
                    Handler handler = (Handler)classLoader.loadClass(handlerClassName).newInstance();
                    this.prefix.set(null);
                    this.configureHandler(handlerName, handler);
                    info.handlers.put(handlerName, handler);
                    if (rootHandlers != null) continue;
                    localRootLogger.addHandler(handler);
                }
                catch (Exception e) {
                    System.err.println("Handler error");
                    e.printStackTrace();
                }
            }
        }
    }

    protected void configureHandler(String handlerName, Handler handler) {
        Level level = this.getLevelProperty(String.valueOf(handlerName) + ".level", null);
        if (level == null) {
            level = this.getLevelProperty(".level", Level.OFF);
        }
        handler.setLevel(level);
        Filter filter = this.getFilterProperty(String.valueOf(handlerName) + ".filter", null);
        if (filter == null) {
            filter = this.getFilterProperty(".filter", null);
        }
        if (filter != null) {
            handler.setFilter(filter);
        }
        Formatter formatter = this.getFormatterProperty(String.valueOf(handlerName) + ".formatter", new SimpleFormatter());
        handler.setFormatter(formatter);
    }

    protected static void doSetParentLogger(final Logger logger, final Logger parent) {
        AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                logger.setParent(parent);
                return null;
            }
        });
    }

    protected String replace(String str, Properties props) {
        String propName;
        String replacement;
        int pos_end;
        String result = str;
        int pos_start = result.indexOf("${");
        if (pos_start != -1 && (pos_end = result.indexOf(125)) != -1 && (replacement = props.getProperty(propName = result.substring(pos_start + 2, pos_end))) != null) {
            result = pos_start > 0 ? String.valueOf(result.substring(0, pos_start)) + replacement + this.replace(result.substring(pos_end + 1), props) : String.valueOf(replacement) + this.replace(result.substring(pos_end + 1), props);
        }
        return result;
    }

    protected static final class ClassLoaderLogInfo {
        final LogNode rootNode;
        final Map<String, Logger> loggers = new HashMap<String, Logger>();
        final Map<String, Handler> handlers = new HashMap<String, Handler>();
        Properties props = new Properties();

        ClassLoaderLogInfo(LogNode rootNode) {
            this.rootNode = rootNode;
        }

        void setProperties(Properties props) {
            this.props = props;
        }
    }

    private final class Cleaner
    extends Thread {
        private Cleaner() {
        }

        @Override
        public void run() {
            if (ContextLogManager.this.useShutdownHook) {
                ContextLogManager.this.shutdown();
            }
        }
    }

    protected static final class LogNode {
        Logger logger;
        protected final Map<String, LogNode> children = new HashMap<String, LogNode>();
        protected final LogNode parent;

        LogNode(LogNode parent, Logger logger) {
            this.parent = parent;
            this.logger = logger;
        }

        LogNode(LogNode parent) {
            this(parent, null);
        }

        /*
         * Unable to fully structure code
         */
        LogNode findNode(String name) {
            currentNode = this;
            if (!this.logger.getName().equals(name)) ** GOTO lbl17
            return this;
lbl-1000:
            // 1 sources

            {
                dotIndex = name.indexOf(46);
                if (dotIndex < 0) {
                    nextName = name;
                    name = null;
                } else {
                    nextName = name.substring(0, dotIndex);
                    name = name.substring(dotIndex + 1);
                }
                childNode = currentNode.children.get(nextName);
                if (childNode == null) {
                    childNode = new LogNode(currentNode);
                    currentNode.children.put(nextName, childNode);
                }
                currentNode = childNode;
lbl17:
                // 2 sources

                ** while (name != null)
            }
lbl18:
            // 1 sources

            return currentNode;
        }

        Logger findParentLogger() {
            Logger logger = null;
            LogNode node = this.parent;
            while (node != null && logger == null) {
                logger = node.logger;
                node = node.parent;
            }
            return logger;
        }

        void setParentLogger(Logger parent) {
            for (LogNode childNode : this.children.values()) {
                if (childNode.logger == null) {
                    childNode.setParentLogger(parent);
                    continue;
                }
                ContextLogManager.doSetParentLogger(childNode.logger, parent);
            }
        }
    }

    protected class RootLogger
    extends Logger {
        public RootLogger() {
            super("", null);
        }
    }
}

